/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.shrinkbar;

import com.nepxion.swing.gradient.JTexturePainter;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.shrinkbar.JShrinkOutlookBar;
import com.nepxion.swing.shrinkbar.ShrinkOutlookListener;
import com.nepxion.swing.style.texture.shrink.IOutlookTextureStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.TexturePaint;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;

public class JShrinkOutlook
extends JPanel {
    private JShrinkOutlookBar shrinkOutlookBar;
    private JLabel handlerLabel;
    private JLabel titleLabel;
    private JLabel iconLabel;
    private JBasicScrollPane scrollPane;
    private Icon icon;
    private Icon selectedIcon;
    private boolean selected = false;
    private IOutlookTextureStyle outlookTextureStyle;

    public JShrinkOutlook(JShrinkOutlookBar shrinkOutlookBar) {
        this.shrinkOutlookBar = shrinkOutlookBar;
        this.outlookTextureStyle = shrinkOutlookBar.getOutlookTextureStyle();
        this.initComponents();
    }

    private void initComponents() {
        ShrinkOutlookListener shrinkOutlookListener = new ShrinkOutlookListener(this);
        this.handlerLabel = new JLabel();
        this.handlerLabel.setIcon(this.outlookTextureStyle.getHandlerImageIcon());
        this.handlerLabel.setVerticalAlignment(0);
        this.handlerLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 18));
        this.handlerLabel.addMouseListener(shrinkOutlookListener);
        this.titleLabel = new JLabel();
        this.titleLabel.setForeground(this.outlookTextureStyle.getForeground());
        this.titleLabel.setVerticalAlignment(0);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.titleLabel.addMouseListener(shrinkOutlookListener);
        this.iconLabel = new JLabel();
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        this.iconLabel.addMouseListener(shrinkOutlookListener);
        this.scrollPane = new JBasicScrollPane();
        this.scrollPane.setMinimumSize(new Dimension(0, 0));
        this.scrollPane.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(JShrinkOutlook.this.outlookTextureStyle.getScrollBorderColor());
                g.drawLine(0, height - 1, width, height - 1);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 1, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.handlerLabel, "East");
        this.add((Component)this.iconLabel, "West");
        this.add((Component)this.titleLabel, "Center");
    }

    public JShrinkOutlookBar getShrinkOutlookBar() {
        return this.shrinkOutlookBar;
    }

    public Component getContentPane() {
        JViewport viewport = this.scrollPane.getViewport();
        if (viewport.getComponentCount() == 0) {
            return null;
        }
        return viewport.getComponent(0);
    }

    public void setContentPane(Component contentPane) {
        this.scrollPane.getViewport().add(contentPane);
    }

    public JBasicScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    @Override
    public String getToolTipText() {
        return this.titleLabel.getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.titleLabel.setToolTipText(toolTipText);
        this.iconLabel.setToolTipText(toolTipText);
        this.handlerLabel.setToolTipText(toolTipText);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.selectedIcon == null) {
            this.selectedIcon = icon;
        }
        if (this.selected) {
            this.iconLabel.setIcon(this.selectedIcon);
        } else {
            this.iconLabel.setIcon(icon);
        }
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

    public Font getTitleFont() {
        return this.titleLabel.getFont();
    }

    public void setTitleFont(Font font) {
        this.titleLabel.setFont(font);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        if (!this.selected) {
            this.shrinkOutlookBar.closeAllShrinkOutlooks();
        }
        this.selected = selected;
        if (selected) {
            this.handlerLabel.setIcon(this.outlookTextureStyle.getSelectionHandlerImageIcon());
            this.titleLabel.setForeground(this.outlookTextureStyle.getSelectionForeground());
        } else {
            this.handlerLabel.setIcon(this.outlookTextureStyle.getHandlerImageIcon());
            this.titleLabel.setForeground(this.outlookTextureStyle.getForeground());
        }
        this.shrinkOutlookBar.updateLayoutConstraint(this.scrollPane, selected);
        this.shrinkOutlookBar.setFillContentPaneVisible(!selected);
        this.shrinkOutlookBar.revalidate();
    }

    protected void toggleSelection() {
        boolean selected = this.isSelected();
        this.setSelected(!selected);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.outlookTextureStyle.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.selected) {
            ImageIcon selectionBackgroundImageIcon = this.outlookTextureStyle.getSelectionBackgroundImageIcon();
            TexturePaint selectionBackgroundTexturePainter = JTexturePainter.getCacheTexturePaint(selectionBackgroundImageIcon.getImage());
            g2d.setPaint(selectionBackgroundTexturePainter);
            if (this.selectedIcon != null) {
                this.iconLabel.setIcon(this.selectedIcon);
            } else {
                this.iconLabel.setIcon(this.icon);
            }
        } else {
            ImageIcon backgroundImageIcon = this.outlookTextureStyle.getBackgroundImageIcon();
            TexturePaint backgroundTexturePainter = JTexturePainter.getCacheTexturePaint(backgroundImageIcon.getImage());
            g2d.setPaint(backgroundTexturePainter);
            this.iconLabel.setIcon(this.icon);
        }
        g2d.fillRect(0, 0, width, height);
    }
}

