/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AsianFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.JFreeChart;

public class ChartPDFUtil {
    public static void writeChartAsPDF(String filePath, JFreeChart chart, int width, int height, String author, String subject) throws IOException, DocumentException {
        ChartPDFUtil.writeChartAsPDF(new File(filePath), chart, width, height, author, subject);
    }

    public static void writeChartAsPDF(File file, JFreeChart chart, int width, int height, String author, String subject) throws IOException, DocumentException {
        ChartPDFUtil.writeChartAsPDF(new FileOutputStream(file), chart, width, height, author, subject);
    }

    public static void writeChartAsPDF(FileOutputStream fileOutputStream, JFreeChart chart, int width, int height, String author, String subject) throws IOException, DocumentException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        Rectangle rectangle = new Rectangle((float)width, (float)height);
        Document document = new Document(rectangle, 50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)bufferedOutputStream);
        if (author != null) {
            document.addAuthor(author);
        }
        if (subject != null) {
            document.addSubject(subject);
        }
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)width, (float)height);
        AsianFontMapper fontMapper = new AsianFontMapper("STSong-Light", "UniGB-UCS2-H");
        Graphics2D graphics2D = pdfTemplate.createGraphics((float)width, (float)height, (FontMapper)fontMapper);
        Rectangle2D.Double doubleValue = new Rectangle2D.Double(0.0, 0.0, width, height);
        chart.draw(graphics2D, (Rectangle2D)doubleValue);
        graphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
        document.close();
        bufferedOutputStream.close();
    }
}

