/*
 * Decompiled with CFR 0.152.
 */
package twaver.network;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import twaver.TWaverUtil;
import twaver.base.A.E.P;
import twaver.network.NetworkPrintPreviewer;
import twaver.network.TNetwork;

public class NetworkPrinter
implements Printable {
    private boolean C = false;
    private TNetwork B = null;
    private PageFormat A = null;
    private NetworkPrintPreviewer D = null;

    public NetworkPrinter(TNetwork network) {
        this.B = network;
    }

    public void preview() {
        if (this.D != null) {
            this.D.toFront();
        } else {
            this.getPageFormat();
            Window parent = P.B(this.getNetwork());
            this.D = parent instanceof Frame ? new NetworkPrintPreviewer((Frame)parent, this) : new NetworkPrintPreviewer((Dialog)parent, this);
            this.D.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e2) {
                    NetworkPrinter.this.D = null;
                }
            });
        }
    }

    public boolean isPrinting() {
        return this.C;
    }

    public boolean isPreviewing() {
        return this.D != null;
    }

    public void print() {
        this.C = true;
        PrinterJob job = PrinterJob.getPrinterJob();
        Book bk = new Book();
        bk.append(this, this.getPageFormat());
        job.setPageable(bk);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                TWaverUtil.handleError(null, ex);
            }
        }
        this.C = false;
    }

    protected boolean setup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat newPageFormat = job.pageDialog(this.getPageFormat());
        if (this.getPageFormat() == newPageFormat) {
            return false;
        }
        if (this.isEqual(newPageFormat = job.validatePage(newPageFormat), this.getPageFormat())) {
            return false;
        }
        this.A = newPageFormat;
        return true;
    }

    public boolean isEqual(PageFormat pf1, PageFormat pf2) {
        if (pf1 == pf2) {
            return true;
        }
        if (pf1 == null || pf2 == null) {
            return false;
        }
        if (pf1.getOrientation() != pf2.getOrientation()) {
            return false;
        }
        Paper p1 = pf1.getPaper();
        Paper p2 = pf2.getPaper();
        if (p1.getWidth() != p2.getWidth()) {
            return false;
        }
        if (p1.getHeight() != p2.getHeight()) {
            return false;
        }
        if (p1.getImageableX() != p2.getImageableX()) {
            return false;
        }
        if (p1.getImageableY() != p2.getImageableY()) {
            return false;
        }
        if (p1.getImageableWidth() != p2.getImageableWidth()) {
            return false;
        }
        return p1.getImageableHeight() == p2.getImageableHeight();
    }

    public int print(Graphics g2, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g22 = (Graphics2D)g2;
        double zoom = this.B.getZoomer().getZoom();
        double networkWidth = (double)this.B.getCanvas().getWidth() / zoom;
        double networkHeight = (double)this.B.getCanvas().getHeight() / zoom;
        double imageableWidth = pageFormat.getImageableWidth();
        double imageableHeight = pageFormat.getImageableHeight();
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        zoom = networkHeight / networkWidth > imageableHeight / imageableWidth ? imageableHeight / networkHeight : imageableWidth / networkWidth;
        g22.translate(imageableX, imageableY);
        this.B.setPaintState(3);
        this.B.paintNetworkContent(g2, zoom, zoom, false);
        this.B.setPaintState(0);
        return 0;
    }

    public PageFormat getPageFormat() {
        if (this.A == null) {
            this.A = PrinterJob.getPrinterJob().defaultPage();
        }
        return this.A;
    }

    public TNetwork getNetwork() {
        return this.B;
    }
}

