/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.renderer.list.CellRendererLabel;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class MultiRadioButtonCellRendererPanel
extends JPanel {
    private JRadioButton ignoredRadioButton;
    private JRadioButton containedRadioButton;
    private JRadioButton notContainedRadioButton;
    private CellRendererLabel label;

    public MultiRadioButtonCellRendererPanel() {
        this(SwingLocale.getString("select_ignored"), SwingLocale.getString("select_contained"), SwingLocale.getString("select_not_contained"));
    }

    public MultiRadioButtonCellRendererPanel(String ignoredText, String containedText, String notContainedText) {
        this.ignoredRadioButton = new JRadioButton(ignoredText);
        this.containedRadioButton = new JRadioButton(containedText);
        this.notContainedRadioButton = new JRadioButton(notContainedText);
        this.label = new CellRendererLabel();
        this.ignoredRadioButton.setBackground(UIManager.getColor("Tree.textBackground"));
        this.containedRadioButton.setBackground(UIManager.getColor("Tree.textBackground"));
        this.notContainedRadioButton.setBackground(UIManager.getColor("Tree.textBackground"));
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ignoredRadioButton);
        buttonGroup.add(this.containedRadioButton);
        buttonGroup.add(this.notContainedRadioButton);
        this.add(this.ignoredRadioButton);
        this.add(this.containedRadioButton);
        this.add(this.notContainedRadioButton);
        this.add(this.label);
        this.setBackground(Color.white);
    }

    public JRadioButton getIgnoredRadioButton() {
        return this.ignoredRadioButton;
    }

    public JRadioButton getContainedRadioButton() {
        return this.containedRadioButton;
    }

    public JRadioButton getNotContainedRadioButton() {
        return this.notContainedRadioButton;
    }

    public CellRendererLabel getLabel() {
        return this.label;
    }

    protected int getSelectedRadioIndex(int x) {
        if (x >= this.ignoredRadioButton.getBounds().x && x <= this.ignoredRadioButton.getBounds().x + this.ignoredRadioButton.getBounds().width) {
            return 0;
        }
        if (x >= this.containedRadioButton.getBounds().x && x <= this.containedRadioButton.getBounds().x + this.containedRadioButton.getBounds().width) {
            return 1;
        }
        if (x >= this.notContainedRadioButton.getBounds().x && x <= this.notContainedRadioButton.getBounds().x + this.notContainedRadioButton.getBounds().width) {
            return 2;
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ignoredRadioDimension = this.ignoredRadioButton.getPreferredSize();
        Dimension containedRadioDimension = this.containedRadioButton.getPreferredSize();
        Dimension notContainedRadioDimension = this.notContainedRadioButton.getPreferredSize();
        Dimension labelDimension = this.label.getPreferredSize();
        return new Dimension(ignoredRadioDimension.width + containedRadioDimension.width + notContainedRadioDimension.width + labelDimension.width, ignoredRadioDimension.height < labelDimension.height ? labelDimension.height : ignoredRadioDimension.height);
    }

    @Override
    public void setBackground(Color background) {
        if (background instanceof ColorUIResource) {
            background = null;
        }
        super.setBackground(background);
    }

    @Override
    public void doLayout() {
        Dimension ignoredRadioDimension = this.ignoredRadioButton.getPreferredSize();
        Dimension containedRadioDimension = this.containedRadioButton.getPreferredSize();
        Dimension notContainedRadioDimension = this.notContainedRadioButton.getPreferredSize();
        Dimension labelDimension = this.label.getPreferredSize();
        int radioHeight = 0;
        int labelHeight = 0;
        if (ignoredRadioDimension.height < labelDimension.height) {
            radioHeight = (labelDimension.height - ignoredRadioDimension.height) / 2;
        } else {
            labelHeight = (ignoredRadioDimension.height - labelDimension.height) / 2;
        }
        this.ignoredRadioButton.setBounds(2, radioHeight, ignoredRadioDimension.width, ignoredRadioDimension.height);
        this.containedRadioButton.setBounds(ignoredRadioDimension.width + 2, radioHeight, containedRadioDimension.width, containedRadioDimension.height);
        this.notContainedRadioButton.setBounds(ignoredRadioDimension.width + containedRadioDimension.width + 2, radioHeight, notContainedRadioDimension.width, notContainedRadioDimension.height);
        this.label.setBounds(ignoredRadioDimension.width + containedRadioDimension.width + notContainedRadioDimension.width + 12, labelHeight, labelDimension.width, labelDimension.height);
    }
}

