/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree.xml;

import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.tree.xml.Dom4JBasicTreeParser;
import com.nepxion.util.xml.dom4j.Dom4JReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class Dom4JTreeParser
extends Dom4JBasicTreeParser {
    public Dom4JTreeParser() {
    }

    public Dom4JTreeParser(String iconExtensionName) {
        super(iconExtensionName);
    }

    public Dom4JTreeParser(int iconFolderMode) {
        super(iconFolderMode);
    }

    public Dom4JTreeParser(int iconFolderMode, String iconExtensionName) {
        super(iconFolderMode, iconExtensionName);
    }

    public Dom4JTreeParser(String indexTag, String nameTag, String textTag, String iconTag, String toolTipTextTag, String classTag, int iconFolderMode, String iconExtensionName) {
        super(indexTag, nameTag, textTag, iconTag, toolTipTextTag, classTag, iconFolderMode, iconExtensionName);
    }

    public ElementNode parse(String text) throws DocumentException {
        Document document = Dom4JReader.getDocument((String)text);
        return this.parse(document);
    }

    public ElementNode parseFormat(String text) throws DocumentException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((String)text);
        return this.parse(document);
    }

    public ElementNode parse(File file) throws DocumentException, IOException {
        Document document = Dom4JReader.getDocument((File)file);
        return this.parse(document);
    }

    public ElementNode parseFormat(File file) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((File)file);
        return this.parse(document);
    }

    public ElementNode parse(InputStream inputStream) throws DocumentException, IOException {
        Document document = Dom4JReader.getDocument((InputStream)inputStream);
        return this.parse(document);
    }

    public ElementNode parseFormat(InputStream inputStream) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((InputStream)inputStream);
        return this.parse(document);
    }

    public ElementNode parse(Document document) {
        Element rootElement = document.getRootElement();
        ElementNode rootTreeNode = new ElementNode();
        this.parseAttribute(rootElement, rootTreeNode);
        this.parseElement(rootElement, rootTreeNode);
        return rootTreeNode;
    }

    public void parseElement(Element element, ElementNode treeNode) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            ElementNode childTreeNode = new ElementNode();
            treeNode.add(childTreeNode);
            this.parseAttribute(childElement, childTreeNode);
            this.parseElement(childElement, childTreeNode);
        }
    }

    public void parseAttribute(Element element, ElementNode treeNode) {
        HashMap<String, String> userObject = null;
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String attributeName = attribute.getName().trim();
            String attributeText = attribute.getText().trim();
            if (attributeName.equals(this.indexTag)) {
                treeNode.setIndex(Integer.parseInt(attributeText));
            } else if (attributeName.equals(this.nameTag)) {
                treeNode.setName(attributeText);
            } else if (attributeName.equals(this.textTag)) {
                treeNode.setText(attributeText);
            } else if (attributeName.equals(this.iconTag)) {
                String iconName = attributeText + (this.iconExtensionName != null ? this.iconExtensionName : "");
                switch (this.iconFolderMode) {
                    case 0: {
                        treeNode.setIcon(IconFactory.getSwingIcon(iconName));
                        break;
                    }
                    case 1: {
                        treeNode.setIcon(IconFactory.getContextIcon(iconName));
                        break;
                    }
                    case 2: {
                        treeNode.setIcon(IconFactory.getIcon(iconName));
                        break;
                    }
                    default: {
                        treeNode.setIcon(IconFactory.getContextIcon(iconName));
                        break;
                    }
                }
            } else if (attributeName.equals(this.toolTipTextTag)) {
                treeNode.setToolTipText(attributeText);
            } else if (attributeName.equals(this.classTag)) {
                if (userObject == null) {
                    userObject = new HashMap<String, String>();
                    treeNode.setUserObject(userObject);
                }
                Object instance = null;
                try {
                    instance = Class.forName(attributeText).newInstance();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                userObject.put(this.classTag, (String)instance);
            } else {
                if (userObject == null) {
                    userObject = new HashMap();
                    treeNode.setUserObject(userObject);
                }
                userObject.put(attributeName, attributeText);
            }
            if (treeNode.getText() == null && treeNode.getName() != null) {
                treeNode.setText(treeNode.getName());
            }
            if (treeNode.getToolTipText() != null || treeNode.getName() == null) continue;
            treeNode.setToolTipText(treeNode.getName());
        }
    }
}

