/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.math.BigInteger;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class BigIntegerEditor
extends AbstractCellEditor {
    public BigIntegerEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public BigIntegerEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        if (value == null || "".equals(value)) {
            return null;
        }
        if (value instanceof BigInteger) {
            return value;
        }
        try {
            return new BigInteger(value.toString());
        }
        catch (Exception ex) {
            return value;
        }
    }

    public boolean validInputValue(Object inputValue) {
        return inputValue instanceof BigInteger;
    }
}

