/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tabbedpane;

import com.jidesoft.swing.JideTabbedPane;
import com.nepxion.swing.style.framework.IStyle;
import com.nepxion.swing.style.framework.StyleManager;
import com.nepxion.swing.tabbedpane.ITabbedPane;
import com.nepxion.swing.tabbedpane.TabbedPanePopupMenuAdapter;
import com.nepxion.swing.tooltip.snap.JSnapToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.border.Border;

public class JEclipseTabbedPane
extends JideTabbedPane
implements ITabbedPane,
MouseListener {
    private JPopupMenu popupMenu;
    private TabbedPanePopupMenuAdapter popupMenuAdapter;
    private Border border;
    private IStyle tabStyle;
    private boolean isSnapToolTip = false;
    private Map snapComponentMap;

    public JEclipseTabbedPane() {
        this.initComponents();
    }

    public JEclipseTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.initComponents();
    }

    public JEclipseTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.initComponents();
    }

    private void initComponents() {
        this.border = this.getBorder();
        this.setShowTabBorder(false);
        this.setUseDefaultShowIconsOnTab(false);
        this.setShowCloseButton(true);
        this.setShowCloseButtonOnTab(true);
        this.setShowCloseButtonOnSelectedTab(true);
        this.setRightClickSelect(true);
        this.setTabShape(7);
        this.addMouseListener(this);
    }

    public void setTabShape(int tabShape) {
        super.setTabShape(tabShape);
        this.setTabStyle(tabShape, this.tabStyle != null ? this.tabStyle : StyleManager.getStyle());
    }

    public void setTabShape(int tabShape, IStyle tabStyle) {
        super.setTabShape(tabShape);
        this.setTabStyle(tabShape, tabStyle);
    }

    public void setTabShape(IStyle tabStyle) {
        int tabShape = this.getTabShape();
        super.setTabShape(tabShape);
        this.setTabStyle(tabShape, tabStyle);
    }

    protected void setTabStyle(int tabShape, IStyle tabStyle) {
        this.tabStyle = tabStyle;
        if (tabShape != 0 && tabShape != 7) {
            this.setBasicTabStyle(tabShape, tabStyle);
        } else {
            this.setEclipseTabStyle(tabShape, tabStyle);
        }
    }

    protected void setBasicTabStyle(int tabShape, IStyle tabStyle) {
        this.setTabColorProvider(tabStyle);
        this.setContentBorderInsets(new Insets(3, 3, 3, 3));
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    protected void setEclipseTabStyle(int tabShape, IStyle tabStyle) {
        this.setTabColorProvider(null);
        this.setEclipseTabGradientColor(tabStyle.getTabbedPaneGradientColor());
        this.setEclipseTabBackground(tabStyle.getTabbedPaneBackground());
        this.setEclipseTabForeground(tabStyle.getTabbedPaneForeground());
        this.setEclipseTabSelectionForeground(tabStyle.getTabbedPaneSelectionForeground());
        this.setContentBorderInsets(new Insets(3, 2, 2, 2));
        this.setBorder(this.border);
    }

    public void setTabColorProvider(final IStyle tabStyle) {
        JideTabbedPane.GradientColorProvider tabColorProvider = null;
        if (tabStyle != null) {
            tabColorProvider = new JideTabbedPane.GradientColorProvider(){

                public Color getTopBackgroundAt(int selectedIndex) {
                    return tabStyle.getTabbedPaneGradientColor();
                }

                public Color getBackgroundAt(int selectedIndex) {
                    return tabStyle.getTabbedPaneBackground();
                }

                public Color getForegroudAt(int selectedIndex) {
                    if (JEclipseTabbedPane.this.getSelectedIndex() == selectedIndex) {
                        return tabStyle.getTabbedPaneSelectionForeground();
                    }
                    return tabStyle.getTabbedPaneForeground();
                }

                public float getGradientRatio(int selectedIndex) {
                    return 0.0f;
                }
            };
        }
        this.setTabColorProvider((JideTabbedPane.ColorProvider)tabColorProvider);
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    @Override
    public void addTab(String title, Component component, String toolTipText) {
        this.addTab(title, null, component, toolTipText);
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, null);
    }

    @Override
    public void addTab(String title, Component component, boolean isClosable) {
        this.addTab(title, null, component, isClosable);
    }

    @Override
    public void addTab(String title, Component component, String toolTipText, boolean isClosable) {
        this.addTab(title, null, component, toolTipText, isClosable);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String toolTipText) {
        this.addTab(title, icon, component, toolTipText, false);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, boolean isClosable) {
        this.addTab(title, icon, component, null, isClosable);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String toolTipText, boolean isClosable) {
        super.addTab(title, icon, component, toolTipText);
        this.setTabClosableAt(this.indexOfComponent(component), isClosable);
    }

    public void insertTab(String title, Icon icon, Component component, String toolTipText, int index) {
        if (this.snapComponentMap != null) {
            toolTipText = "tab" + component.hashCode();
            this.snapComponentMap.put(toolTipText, component);
        }
        super.insertTab(title, icon, component, toolTipText, index);
    }

    public JToolTip createToolTip() {
        if (this.snapComponentMap != null) {
            JSnapToolTip snapTooltip = new JSnapToolTip(this.snapComponentMap);
            snapTooltip.setComponent((JComponent)((Object)this));
            return snapTooltip;
        }
        return super.createToolTip();
    }

    @Override
    public boolean isSnapToolTip() {
        return this.isSnapToolTip;
    }

    @Override
    public void setSnapToolTip(boolean isSnapToolTip) {
        this.isSnapToolTip = isSnapToolTip;
        this.snapComponentMap = isSnapToolTip ? new HashMap() : null;
    }

    @Override
    public String getSelectedTitle() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getTitleAt(index);
    }

    @Override
    public Icon getIcon(int index) {
        return this.getIconAt(index);
    }

    @Override
    public Component getTabAt(String title) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(title)) continue;
            return this.getComponentAt(i);
        }
        return null;
    }

    @Override
    public List getClosableTabs() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.isTabClosableAt(i)) continue;
            Component component = this.getComponentAt(i);
            components.add(component);
        }
        return components;
    }

    @Override
    public void removeTabAt(int index) {
        if (this.snapComponentMap != null) {
            Component component = this.getComponentAt(index);
            this.snapComponentMap.remove("tab" + component.hashCode());
        }
        super.removeTabAt(index);
    }

    public void removeTabAt(String title) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(title)) continue;
            this.removeTabAt(i);
            break;
        }
    }

    @Override
    public void removeTabs(List components) {
        for (int i = 0; i < components.size(); ++i) {
            Component closedComponent = (Component)components.get(i);
            this.removeTabAt(this.indexOfComponent(closedComponent));
        }
    }

    @Override
    public void removeReverseTabsAt(int index) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (i == index || !this.isTabClosableAt(i)) continue;
            Component component = this.getComponentAt(i);
            components.add(component);
        }
        this.removeTabs(components);
    }

    @Override
    public void removeAllTabs() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.isTabClosableAt(i)) continue;
            Component component = this.getComponentAt(i);
            components.add(component);
        }
        this.removeTabs(components);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu, boolean isClosable) {
        this.popupMenu = popupMenu;
        if (isClosable) {
            this.popupMenuAdapter = new TabbedPanePopupMenuAdapter(this, popupMenu);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.popupMenu != null) {
            int index = this.indexAtLocation(e.getX(), e.getY());
            if (index < 0) {
                return;
            }
            if (!e.isPopupTrigger()) {
                return;
            }
            this.setSelectedIndex(index);
            if (this.popupMenuAdapter != null) {
                this.popupMenuAdapter.adaptClosableItem(index);
            }
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

