/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import y.io.BadVersionException;
import y.view.Bend;
import y.view.EdgeRealizer;
import y.view.NodeRealizer;
import y.view.Port;
import y.view.if;

public class ArcEdgeRealizer
extends EdgeRealizer {
    private float ap;
    private float ao;
    private float am;
    private float al;
    private float ah;
    private float an;
    private float ad;
    private float ac;
    private float ak;
    private float aj;
    private float ai;
    private float ab;
    private float ag;
    private float af;
    private byte ae;
    Bend aq;
    public static final byte FIXED_HEIGHT = 0;
    public static final byte FIXED_RATIO = 1;

    public ArcEdgeRealizer() {
        this(1);
    }

    public ArcEdgeRealizer(byte by) {
        this.d();
        this.ae = by;
    }

    public ArcEdgeRealizer(EdgeRealizer edgeRealizer) {
        super(edgeRealizer);
        if (edgeRealizer instanceof ArcEdgeRealizer) {
            ArcEdgeRealizer arcEdgeRealizer = (ArcEdgeRealizer)edgeRealizer;
            this.ae = arcEdgeRealizer.getArcType();
            this.ah = arcEdgeRealizer.getRatio();
            this.an = arcEdgeRealizer.getHeight();
            if (arcEdgeRealizer.bendCount() != 1) {
                this.aq = new Bend(this, 0.0, 0.0);
            } else {
                this.aq = new Bend(this, arcEdgeRealizer.aq.getX(), arcEdgeRealizer.aq.getY());
                this.ap = arcEdgeRealizer.ap;
                this.am = arcEdgeRealizer.am;
                this.ao = arcEdgeRealizer.ao;
                this.al = arcEdgeRealizer.al;
                this.ad = arcEdgeRealizer.ad;
                this.ac = arcEdgeRealizer.ac;
                this.ak = arcEdgeRealizer.ak;
                this.aj = arcEdgeRealizer.aj;
                this.ab = arcEdgeRealizer.ab;
                this.ai = arcEdgeRealizer.ai;
                this.ag = arcEdgeRealizer.ag;
                this.af = arcEdgeRealizer.af;
            }
            this.bends.clear();
            this.bends.addLast(this.aq);
        } else {
            this.d();
        }
    }

    public EdgeRealizer createCopy(EdgeRealizer edgeRealizer) {
        return new ArcEdgeRealizer(edgeRealizer);
    }

    private void d() {
        this.ah = 1.0f;
        this.an = 30.0f;
        this.aq = new Bend(this, 0.0, 0.0);
        this.bends.clear();
        this.bends.addLast(this.aq);
        this.ae = 1;
    }

    public void setArcType(byte by) {
        this.ae = by;
    }

    public byte getArcType() {
        return this.ae;
    }

    public float getRatio() {
        return this.ah;
    }

    public void setRatio(float f2) {
        this.ah = f2;
        this.setDirty();
    }

    public void setHeight(float f2) {
        this.an = f2;
        this.setDirty();
    }

    public float getHeight() {
        return this.an;
    }

    public Bend createBend(double d2, double d3, Bend bend, int n) {
        return null;
    }

    public void reInsertBend(Bend bend, Bend bend2, int n) {
    }

    public Bend insertBend(double d2, double d3) {
        return null;
    }

    public Bend removeBend(Bend bend) {
        return null;
    }

    public int getMinBendCount() {
        return 1;
    }

    public void bendChanged(Bend bend, double d2, double d3) {
        if (this.getTargetRealizer().isSelected() || this.getSourceRealizer().isSelected()) {
            return;
        }
        if (!bend.isSelected()) {
            return;
        }
        double d4 = Line2D.ptLineDist(this.ap, this.ao, this.am, this.al, this.aq.getX(), this.aq.getY());
        int n = Line2D.relativeCCW(this.ap, this.ao, this.am, this.al, this.aq.getX(), this.aq.getY());
        double d5 = (float)Math.sqrt(this.ak * this.ak + this.aj * this.aj);
        switch (this.ae) {
            case 0: {
                this.an = (float)n * (float)d4;
                break;
            }
            case 1: {
                this.ah = (float)n * (float)(4.0 * d4 / d5);
            }
        }
        this.c();
    }

    private void c() {
        NodeRealizer nodeRealizer = this.getSourceRealizer();
        NodeRealizer nodeRealizer2 = this.getTargetRealizer();
        Port port = this.getSourcePort();
        Port port2 = this.getTargetPort();
        this.ap = (float)port.getX(nodeRealizer);
        this.ao = (float)port.getY(nodeRealizer);
        this.am = (float)port2.getX(nodeRealizer2);
        this.al = (float)port2.getY(nodeRealizer2);
        this.ak = this.am - this.ap;
        this.aj = this.al - this.ao;
        this.ad = this.ap + this.ak / 2.0f;
        this.ac = this.ao + this.aj / 2.0f;
        switch (this.ae) {
            case 1: {
                this.ab = this.aj * this.ah / 4.0f;
                this.ai = -this.ak * this.ah / 4.0f;
                break;
            }
            case 0: {
                this.ah = (float)((double)this.an / Math.sqrt(this.ak * this.ak + this.aj * this.aj));
                this.ab = this.aj * this.ah;
                this.ai = -this.ak * this.ah;
            }
        }
        this.aq.a = this.ad + this.ab;
        this.aq.e = this.ac + this.ai;
        this.ag = (float)(this.aq.getX() + (double)this.ab);
        this.af = (float)(this.aq.getY() + (double)this.ai);
    }

    protected void calculatePath() {
        this.c();
        GeneralPath generalPath = new GeneralPath(1, 5);
        generalPath.moveTo(this.ap, this.ao);
        generalPath.quadTo(this.ag, this.af, this.am, this.al);
        PathIterator pathIterator = generalPath.getPathIterator(null, 1.0);
        float[] fArray = new float[2];
        pathIterator.currentSegment(fArray);
        pathIterator.next();
        this.path.reset();
        this.path.moveTo(fArray[0], fArray[1]);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            pathIterator.next();
            this.path.lineTo(fArray[0], fArray[1]);
        }
        this.path = if.d(this, this.path);
    }

    public static Map arcTypeToStringMap() {
        HashMap<Byte, String> hashMap = new HashMap<Byte, String>(5);
        hashMap.put(new Byte(1), "Fixed Ratio");
        hashMap.put(new Byte(0), "Fixed Height");
        return hashMap;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        super.write(objectOutputStream);
        objectOutputStream.writeByte(this.ae);
        objectOutputStream.writeFloat(this.ah);
        objectOutputStream.writeFloat(this.an);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                objectInputStream.readByte();
                super.read(objectInputStream);
                this.setArcType(objectInputStream.readByte());
                this.ah = objectInputStream.readFloat();
                this.an = objectInputStream.readFloat();
                break;
            }
            case 1: {
                super.read(objectInputStream);
                this.setArcType(objectInputStream.readByte());
                this.ah = objectInputStream.readFloat();
                this.an = objectInputStream.readFloat();
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }
}

