/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeCursor;
import y.base.YCursor;
import y.base.YList;
import y.geom.AffineLine;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.geom.YVector;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLayout;

public class LayoutTool {
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int JUSTIFIED = 3;
    public static final int CENTER = 4;
    private static final double b = 0.5;
    private static final YPointPath c = new YPointPath();
    private static final YPoint a = new YPoint(0.0, 0.0);

    public static double getNodeDistance(LayoutGraph layoutGraph, Node node, Node node2) {
        double d2 = layoutGraph.getCenterX(node);
        double d3 = layoutGraph.getCenterY(node);
        double d4 = layoutGraph.getCenterX(node2);
        double d5 = layoutGraph.getCenterY(node2);
        return YPoint.distance(d2, d3, d4, d5);
    }

    public static double getPathLength(LayoutGraph layoutGraph, Edge edge) {
        double d2;
        double d3;
        YPoint yPoint;
        YPoint yPoint2 = layoutGraph.getSourcePointAbs(edge);
        double d4 = yPoint2.x;
        double d5 = yPoint2.y;
        EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
        double d6 = 0.0;
        int n = 0;
        while (n < edgeLayout.pointCount()) {
            yPoint = edgeLayout.getPoint(n);
            d3 = yPoint.x;
            d2 = yPoint.y;
            d6 += YPoint.distance(d4, d5, d3, d2);
            d4 = d3;
            d5 = d2;
            ++n;
        }
        yPoint = layoutGraph.getTargetPointAbs(edge);
        d3 = yPoint.x;
        d2 = yPoint.y;
        return d6 += YPoint.distance(d4, d5, d3, d2);
    }

    public static void reverseEdgeLayout(EdgeLayout edgeLayout) {
        Object object;
        if (edgeLayout.pointCount() > 0) {
            object = new Vector(edgeLayout.pointCount());
            int n = edgeLayout.pointCount() - 1;
            while (n >= 0) {
                ((Vector)object).add(edgeLayout.getPoint(n));
                --n;
            }
            edgeLayout.clearPoints();
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                YPoint yPoint = (YPoint)((Vector)object).get(n2);
                edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
                ++n2;
            }
        }
        object = edgeLayout.getSourcePoint();
        edgeLayout.setSourcePoint(edgeLayout.getTargetPoint());
        edgeLayout.setTargetPoint((YPoint)object);
    }

    public static void resetPaths(LayoutGraph layoutGraph) {
        LayoutTool.resetPaths(layoutGraph, true);
    }

    public static void resetPaths(LayoutGraph layoutGraph, boolean bl) {
        if (bl) {
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                layoutGraph.setSourcePointRel(edge, a);
                layoutGraph.setTargetPointRel(edge, a);
                layoutGraph.setPoints(edge, c);
                edgeCursor.next();
            }
        } else {
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                layoutGraph.setPoints(edgeCursor.edge(), c);
                edgeCursor.next();
            }
        }
    }

    public static void resetPath(LayoutGraph layoutGraph, Edge edge) {
        layoutGraph.setSourcePointRel(edge, a);
        layoutGraph.setTargetPointRel(edge, a);
        layoutGraph.setPoints(edge, c);
    }

    public static void moveEdge(LayoutGraph layoutGraph, Edge edge, double d2, double d3) {
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        int n = edgeLayout.pointCount() - 1;
        while (n >= 0) {
            YPoint yPoint = edgeLayout.getPoint(n);
            edgeLayout.setPoint(n, yPoint.x + d2, yPoint.y + d3);
            --n;
        }
    }

    public static void moveNodes(LayoutGraph layoutGraph, NodeCursor nodeCursor, double d2, double d3) {
        while (nodeCursor.ok()) {
            NodeLayout nodeLayout = layoutGraph.getNodeLayout(nodeCursor.node());
            nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
            nodeCursor.next();
        }
    }

    public static void moveEdges(LayoutGraph layoutGraph, EdgeCursor edgeCursor, double d2, double d3) {
        while (edgeCursor.ok()) {
            EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
            int n = edgeLayout.pointCount() - 1;
            while (n >= 0) {
                YPoint yPoint = edgeLayout.getPoint(n);
                edgeLayout.setPoint(n, yPoint.x + d2, yPoint.y + d3);
                --n;
            }
            edgeCursor.next();
        }
    }

    public static void moveNode(LayoutGraph layoutGraph, Node node, double d2, double d3) {
        NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
        nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
    }

    public static void moveSubgraph(LayoutGraph layoutGraph, EdgeCursor edgeCursor, double d2, double d3) {
        Object object;
        HashSet<Node> hashSet = new HashSet<Node>();
        while (edgeCursor.ok()) {
            object = edgeCursor.edge();
            hashSet.add(((Edge)object).source());
            hashSet.add(((Edge)object).target());
            LayoutTool.moveEdge(layoutGraph, (Edge)object, d2, d3);
            edgeCursor.next();
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            LayoutTool.moveNode(layoutGraph, node, d2, d3);
        }
    }

    public static void moveSubgraph(LayoutGraph layoutGraph, NodeCursor nodeCursor, double d2, double d3) {
        HashSet<Node> hashSet = new HashSet<Node>();
        while (nodeCursor.ok()) {
            LayoutTool.moveNode(layoutGraph, nodeCursor.node(), d2, d3);
            hashSet.add(nodeCursor.node());
            nodeCursor.next();
        }
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (hashSet.contains(edge.source()) && hashSet.contains(edge.target())) {
                LayoutTool.moveEdge(layoutGraph, edge, d2, d3);
            }
            edgeCursor.next();
        }
    }

    public static void resetPorts(LayoutGraph layoutGraph) {
        YPoint yPoint = new YPoint(0.0, 0.0);
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            layoutGraph.setSourcePointRel(edge, yPoint);
            layoutGraph.setTargetPointRel(edge, yPoint);
            edgeCursor.next();
        }
    }

    public static YPointPath getEdgeClippedOnBB(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        return LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 0.0);
    }

    public static YPointPath getEdgeClippedOnBB(LayoutGraph layoutGraph, Edge edge) {
        return LayoutTool.getEdgeClippedOnBB(layoutGraph.getLayout(edge), layoutGraph.getLayout(edge.source()), layoutGraph.getLayout(edge.target()));
    }

    public static YPointPath getEdgeClippedOnBB(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, double d2) {
        YPoint yPoint = new YPoint(nodeLayout.getX() - d2, nodeLayout.getY() - d2);
        YDimension yDimension = new YDimension(nodeLayout.getWidth() + 2.0 * d2, nodeLayout.getHeight() + 2.0 * d2);
        YPoint yPoint2 = new YPoint(nodeLayout2.getX() - d2, nodeLayout2.getY() - d2);
        YDimension yDimension2 = new YDimension(nodeLayout2.getWidth() + 2.0 * d2, nodeLayout2.getHeight() + 2.0 * d2);
        Vector<YPoint> vector = new Vector<YPoint>(edgeLayout.pointCount() + 2);
        YPoint yPoint3 = new YPoint(edgeLayout.getSourcePoint().getX() + yPoint.getX() + yDimension.getWidth() / 2.0, edgeLayout.getSourcePoint().getY() + yPoint.getY() + yDimension.getHeight() / 2.0);
        vector.addElement(yPoint3);
        int n = 0;
        while (n < edgeLayout.pointCount()) {
            vector.addElement(edgeLayout.getPoint(n));
            ++n;
        }
        YPoint yPoint4 = new YPoint(edgeLayout.getTargetPoint().getX() + yPoint2.getX() + yDimension2.getWidth() / 2.0, edgeLayout.getTargetPoint().getY() + yPoint2.getY() + yDimension2.getHeight() / 2.0);
        vector.addElement(yPoint4);
        YPoint yPoint5 = (YPoint)vector.firstElement();
        YPoint yPoint6 = (YPoint)vector.lastElement();
        if (!LayoutTool.a(yPoint, yDimension, yPoint5)) {
            vector.insertElementAt(new YPoint(yPoint.getX() + yDimension.getWidth() / 2.0, yPoint.getY() + yDimension.getHeight() / 2.0), 0);
        }
        if (!LayoutTool.a(yPoint2, yDimension2, yPoint6)) {
            vector.addElement(new YPoint(yPoint2.getX() + yDimension2.getWidth() / 2.0, yPoint2.getY() + yDimension2.getHeight() / 2.0));
        }
        Vector<YPoint> vector2 = new Vector<YPoint>();
        int n2 = 0;
        while (LayoutTool.a(yPoint, yDimension, (YPoint)vector.elementAt(n2))) {
            if (++n2 != vector.size()) continue;
            return new YPointPath();
        }
        if (n2 > 0) {
            vector2.addElement(LayoutTool.a(yPoint, yDimension, (YPoint)vector.elementAt(n2 - 1), (YPoint)vector.elementAt(n2)));
        }
        while (!LayoutTool.a(yPoint2, yDimension2, (YPoint)vector.elementAt(n2))) {
            vector2.addElement((YPoint)vector.elementAt(n2));
            if (++n2 != vector.size()) continue;
            return new YPointPath(vector2);
        }
        vector2.addElement(LayoutTool.a(yPoint2, yDimension2, (YPoint)vector.elementAt(n2), (YPoint)vector2.lastElement()));
        return new YPointPath(vector2);
    }

    public static boolean isEdgeOutsideNodes(LayoutGraph layoutGraph, Edge edge) {
        return LayoutTool.isEdgeOutsideNodes(layoutGraph.getLayout(edge), layoutGraph.getLayout(edge.source()), layoutGraph.getLayout(edge.target()), 0.0);
    }

    public static boolean isEdgeOutsideNodes(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, double d2) {
        YPoint yPoint = new YPoint(nodeLayout.getX() - d2, nodeLayout.getY() - d2);
        YDimension yDimension = new YDimension(nodeLayout.getWidth() + 2.0 * d2, nodeLayout.getHeight() + 2.0 * d2);
        YPoint yPoint2 = new YPoint(nodeLayout2.getX() - d2, nodeLayout2.getY() - d2);
        YDimension yDimension2 = new YDimension(nodeLayout2.getWidth() + 2.0 * d2, nodeLayout2.getHeight() + 2.0 * d2);
        Vector<YPoint> vector = new Vector<YPoint>(edgeLayout.pointCount() + 2);
        YPoint yPoint3 = new YPoint(edgeLayout.getSourcePoint().getX() + yPoint.getX() + yDimension.getWidth() / 2.0, edgeLayout.getSourcePoint().getY() + yPoint.getY() + yDimension.getHeight() / 2.0);
        vector.addElement(yPoint3);
        int n = 0;
        while (n < edgeLayout.pointCount()) {
            vector.addElement(edgeLayout.getPoint(n));
            ++n;
        }
        YPoint yPoint4 = new YPoint(edgeLayout.getTargetPoint().getX() + yPoint2.getX() + yDimension2.getWidth() / 2.0, edgeLayout.getTargetPoint().getY() + yPoint2.getY() + yDimension2.getHeight() / 2.0);
        vector.addElement(yPoint4);
        YPoint yPoint5 = (YPoint)vector.firstElement();
        YPoint yPoint6 = (YPoint)vector.lastElement();
        if (!LayoutTool.a(yPoint, yDimension, yPoint5)) {
            vector.insertElementAt(new YPoint(yPoint.getX() + yDimension.getWidth() / 2.0, yPoint.getY() + yDimension.getHeight() / 2.0), 0);
        }
        if (!LayoutTool.a(yPoint2, yDimension2, yPoint6)) {
            vector.addElement(new YPoint(yPoint2.getX() + yDimension2.getWidth() / 2.0, yPoint2.getY() + yDimension2.getHeight() / 2.0));
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            YPoint yPoint7 = (YPoint)vector.elementAt(n2);
            if (!LayoutTool.a(yPoint, yDimension, yPoint7)) {
                bl = true;
            }
            if (!LayoutTool.a(yPoint2, yDimension2, yPoint7)) {
                bl2 = true;
            }
            ++n2;
        }
        return bl2 && bl;
    }

    public static void clipEdgesOnBB(LayoutGraph layoutGraph) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(layoutGraph, edge);
            Vector vector = yPointPath.toVector();
            layoutGraph.setSourcePointAbs(edge, (YPoint)vector.elementAt(0));
            layoutGraph.setTargetPointAbs(edge, (YPoint)vector.elementAt(vector.size() - 1));
            vector.removeElementAt(vector.size() - 1);
            vector.removeElementAt(0);
            layoutGraph.setPoints(edge, new YPointPath(vector));
            edgeCursor.next();
        }
    }

    public static String edgeLayoutString(LayoutGraph layoutGraph, Edge edge) {
        StringBuffer stringBuffer = new StringBuffer();
        YCursor yCursor = layoutGraph.getPoints(edge).cursor();
        while (yCursor.ok()) {
            YPoint yPoint = (YPoint)yCursor.current();
            stringBuffer.append("X: " + yPoint.getX() + " Y: " + yPoint.getY() + "\n");
            yCursor.next();
        }
        return stringBuffer.toString();
    }

    public static void roundNodeLayout(LayoutGraph layoutGraph, Node node) {
        YDimension yDimension = layoutGraph.getSize(node);
        layoutGraph.setSize(node, LayoutTool.a(yDimension));
        YPoint yPoint = layoutGraph.getLocation(node);
        layoutGraph.setLocation(node, LayoutTool.a(yPoint));
    }

    public static void roundEdgeLayout(LayoutGraph layoutGraph, Edge edge) {
        Vector vector = layoutGraph.getPoints(edge).toVector();
        Vector<YPoint> vector2 = new Vector<YPoint>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(LayoutTool.a((YPoint)vector.elementAt(n)));
            ++n;
        }
        layoutGraph.setPoints(edge, new YPointPath(vector2));
        layoutGraph.setSourcePointRel(edge, LayoutTool.a(layoutGraph.getSourcePointRel(edge)));
        layoutGraph.setTargetPointRel(edge, LayoutTool.a(layoutGraph.getTargetPointRel(edge)));
    }

    public static void roundLayout(LayoutGraph layoutGraph) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            LayoutTool.roundEdgeLayout(layoutGraph, edgeCursor.edge());
            edgeCursor.next();
        }
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            LayoutTool.roundNodeLayout(layoutGraph, nodeCursor.node());
            nodeCursor.next();
        }
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, Edge edge2, double d2) {
        Object object;
        Object object2;
        Object object3;
        int n = layoutGraph.getPath(edge).length();
        YPoint[] yPointArray = new YPoint[n];
        int n2 = 0;
        YCursor yCursor = layoutGraph.getPath(edge).cursor();
        while (yCursor.ok()) {
            object3 = (YPoint)yCursor.current();
            if (n2 <= 0 || !((YPoint)object3).equals(yPointArray[n2 - 1])) {
                yPointArray[n2] = new YPoint(((YPoint)object3).getX(), ((YPoint)object3).getY());
                ++n2;
            }
            yCursor.next();
        }
        n = n2;
        if (n < 2) {
            return;
        }
        object3 = new Vector(n);
        YVector yVector = new YVector(yPointArray[1], yPointArray[0]);
        YVector yVector2 = YVector.orthoNormal(yVector);
        yVector2.scale(d2);
        YPoint yPoint = YVector.add(yPointArray[0], yVector2);
        YPoint yPoint2 = YVector.add(yPointArray[1], yVector2);
        AffineLine affineLine = new AffineLine(yPoint, yPoint2);
        int n3 = 1;
        while (n3 < n - 1) {
            object2 = affineLine;
            object = YVector.orthoNormal(new YVector(yPointArray[n3 + 1], yPointArray[n3]));
            ((YVector)object).scale(d2);
            YPoint yPoint3 = YVector.add(yPointArray[n3], (YVector)object);
            YPoint yPoint4 = YVector.add(yPointArray[n3 + 1], (YVector)object);
            affineLine = new AffineLine(yPoint3, yPoint4);
            YPoint yPoint5 = AffineLine.getCrossing((AffineLine)object2, affineLine);
            if (yPoint5 != null) {
                ((Vector)object3).addElement(new YPoint(yPoint5.getX(), yPoint5.getY()));
            }
            ++n3;
        }
        object2 = new YVector(yPointArray[n - 1], yPointArray[n - 2]);
        object2 = YVector.orthoNormal((YVector)object2);
        ((YVector)object2).scale(d2);
        YPoint yPoint6 = YVector.add(yPointArray[n - 1], (YVector)object2);
        object = new YPointPath((Vector)object3);
        if (edge.source().equals(edge2.source())) {
            layoutGraph.setPoints(edge2, (YPointPath)object);
            layoutGraph.setEndPointsAbs(edge2, yPoint, yPoint6);
        } else {
            layoutGraph.setPoints(edge2, ((YPointPath)object).createReverse());
            layoutGraph.setEndPointsAbs(edge2, yPoint6, yPoint);
        }
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, EdgeList edgeList, double d2) {
        double d3 = d2;
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            Edge edge2 = edgeCursor.edge();
            LayoutTool.routeEdgesParallel(layoutGraph, edge, edge2, d3);
            if (d3 < 0.0) {
                d3 -= d2;
            }
            d3 = -d3;
            edgeCursor.next();
        }
    }

    public static void routeSelfLoop(LayoutGraph layoutGraph, Edge edge) {
        Vector<YPoint> vector = new Vector<YPoint>();
        YPoint yPoint = layoutGraph.getLocation(edge.source());
        YDimension yDimension = layoutGraph.getSize(edge.source());
        YPoint yPoint2 = new YPoint(yPoint.getX() + yDimension.getWidth() / 4.0, yPoint.getY() + yDimension.getHeight() / 4.0);
        vector.addElement(new YPoint(yPoint.getX() + yDimension.getWidth() / 4.0, yPoint.getY() - 20.0));
        vector.addElement(new YPoint(yPoint.getX() - 20.0, yPoint.getY() - 20.0));
        vector.addElement(new YPoint(yPoint.getX() - 20.0, yPoint.getY() + yDimension.getHeight() / 4.0));
        layoutGraph.setPoints(edge, new YPointPath(vector));
        layoutGraph.setSourcePointAbs(edge, yPoint2);
        layoutGraph.setTargetPointAbs(edge, yPoint2);
    }

    public static void assignReverseLayout(LayoutGraph layoutGraph, Edge edge, Edge edge2) {
        layoutGraph.setSourcePointAbs(edge, layoutGraph.getTargetPointAbs(edge2));
        layoutGraph.setTargetPointAbs(edge, layoutGraph.getSourcePointAbs(edge2));
        layoutGraph.setPoints(edge, layoutGraph.getPoints(edge2).createReverse());
    }

    public static String getNodePositions(LayoutGraph layoutGraph) {
        StringBuffer stringBuffer = new StringBuffer("Node Positions:\n");
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            stringBuffer.append(nodeCursor.node() + " " + layoutGraph.getLocation(nodeCursor.node()) + "\n");
            nodeCursor.next();
        }
        return stringBuffer.toString();
    }

    public static void initDiagram(LayoutGraph layoutGraph) {
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            layoutGraph.setLocation(nodeCursor.node(), new YPoint(0.0, 0.0));
            nodeCursor.next();
        }
        LayoutTool.resetPaths(layoutGraph);
    }

    private static boolean a(YPoint yPoint, YDimension yDimension, YPoint yPoint2) {
        return yPoint2.x >= yPoint.x && yPoint2.y >= yPoint.y && yPoint2.x <= yPoint.x + yDimension.getWidth() && yPoint2.y <= yPoint.y + yDimension.getHeight();
    }

    private static YPoint a(YPoint yPoint, YDimension yDimension, YPoint yPoint2, YPoint yPoint3) {
        Point2D.Double double_ = LayoutTool.a(yPoint.x, yPoint.y, yDimension.getWidth(), yDimension.getHeight(), yPoint2.x, yPoint2.y, yPoint3.x, yPoint3.y, null);
        return new YPoint(double_.x, double_.y);
    }

    private static Point2D.Double a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Point2D.Double double_) {
        if (double_ == null) {
            double_ = new Point2D.Double();
        }
        if (d6 >= d2 && d7 >= d3 && d6 <= d2 + d4 && d7 <= d3 + d5) {
            double d10 = d8 - d6;
            double d11 = d9 - d7;
            if (d10 == 0.0) {
                if (d11 < 0.0) {
                    double_.x = d6;
                    double_.y = d3;
                    return double_;
                }
                double_.x = d6;
                double_.y = d3 + d5;
                return double_;
            }
            if (d11 == 0.0) {
                if (d10 < 0.0) {
                    double_.x = d2;
                    double_.y = d7;
                    return double_;
                }
                double_.x = d2 + d4;
                double_.y = d7;
                return double_;
            }
            double d12 = d11 / d10;
            if (d10 > 0.0) {
                double d13 = d7 + d12 * (d2 + d4 - d6);
                if (d13 < d3) {
                    double_.x = d6 + (d3 - d7) / d12;
                    double_.y = d3;
                    return double_;
                }
                if (d13 <= d3 + d5) {
                    double_.x = d2 + d4;
                    double_.y = d13;
                    return double_;
                }
                double_.x = d6 + (d3 + d5 - d7) / d12;
                double_.y = d3 + d5;
                return double_;
            }
            double d14 = d7 + d12 * (d2 - d6);
            if (d14 < d3) {
                double_.x = d6 + (d3 - d7) / d12;
                double_.y = d3;
                return double_;
            }
            if (d14 <= d3 + d5) {
                double_.x = d2;
                double_.y = d14;
                return double_;
            }
            double_.x = d6 + (d3 + d5 - d7) / d12;
            double_.y = d3 + d5;
            return double_;
        }
        double_.x = d6;
        double_.y = d7;
        return double_;
    }

    private static YPoint a(YPoint yPoint) {
        return new YPoint(LayoutTool.a(yPoint.getX()), LayoutTool.a(yPoint.getY()));
    }

    private static YDimension a(YDimension yDimension) {
        return new YDimension(LayoutTool.a(yDimension.getWidth()), LayoutTool.a(yDimension.getHeight()));
    }

    private static double a(double d2) {
        return Math.floor(d2 + 0.5);
    }

    public static final int arrangeRectangleRows(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2) {
        return LayoutTool.arrangeRectangleRows(rectangle2DArray, rectangle2D, d2, 1);
    }

    public static final Dimension arrangeRectangleGrid(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2) {
        int n;
        int n2;
        int n3;
        if (rectangle2DArray == null || rectangle2DArray.length < 1) {
            if (rectangle2D != null) {
                rectangle2D.setFrame(0.0, 0.0, 0.0, 0.0);
            }
            return new Dimension(0, 0);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 < rectangle2DArray.length) {
            Rectangle2D rectangle2D2 = rectangle2DArray[n4];
            d3 = Math.max(d3, rectangle2D2.getWidth());
            d4 = Math.max(d4, rectangle2D2.getHeight());
            ++n4;
        }
        double d5 = d3 * d4 * (double)rectangle2DArray.length;
        double d6 = Math.sqrt(d5 / d2);
        double d7 = d5 / d6;
        int n5 = (int)Math.floor(d7 / d3);
        int n6 = (int)Math.ceil(d7 / d3);
        int n7 = (int)Math.ceil((double)rectangle2DArray.length / (double)n5);
        if (n5 * n7 < n6 * (n3 = (int)Math.ceil((double)rectangle2DArray.length / (double)n6))) {
            n2 = n5;
            n = n7;
        } else {
            n2 = n6;
            n = n3;
        }
        int n8 = 0;
        int n9 = 0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d3 > d4) {
            int n10 = 0;
            while (n10 < rectangle2DArray.length) {
                rectangle2DArray[n10].setFrame((double)n9 * d3, (double)n8 * d4, rectangle2DArray[n10].getWidth(), rectangle2DArray[n10].getHeight());
                d8 = Math.max(d8, rectangle2DArray[n10].getMaxX());
                d9 = Math.max(d9, rectangle2DArray[n10].getMaxY());
                if (++n9 >= n2) {
                    ++n8;
                    n9 = 0;
                }
                ++n10;
            }
        } else {
            int n11 = 0;
            while (n11 < rectangle2DArray.length) {
                rectangle2DArray[n11].setFrame((double)n9 * d3, (double)n8 * d4, rectangle2DArray[n11].getWidth(), rectangle2DArray[n11].getHeight());
                d8 = Math.max(d8, rectangle2DArray[n11].getMaxX());
                d9 = Math.max(d9, rectangle2DArray[n11].getMaxY());
                if (++n8 >= n) {
                    ++n9;
                    n8 = 0;
                }
                ++n11;
            }
        }
        if (rectangle2D != null) {
            rectangle2D.setFrame(0.0, 0.0, d8, d9);
        }
        return new Dimension(n, n2);
    }

    public static final int arrangeRectangleRows(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2, int n) {
        Object object;
        Object object2;
        Object object3;
        double d3;
        double d4;
        if (rectangle2DArray == null || rectangle2DArray.length < 1) {
            if (rectangle2D != null) {
                rectangle2D.setFrame(0.0, 0.0, 0.0, 0.0);
            }
            return 0;
        }
        double d5 = d4 = rectangle2DArray[0].getWidth();
        double d6 = d3 = rectangle2DArray[0].getHeight();
        int n2 = 1;
        while (n2 < rectangle2DArray.length) {
            double d7 = rectangle2DArray[n2].getWidth();
            d5 = Math.min(d5, d7);
            d4 = Math.max(d4, d7);
            double d8 = rectangle2DArray[n2].getHeight();
            d6 = Math.min(d6, d8);
            d3 = Math.max(d3, d8);
            ++n2;
        }
        if (d6 / d3 > 0.95 && d5 / d4 > 0.95) {
            return LayoutTool.arrangeRectangleGrid((Rectangle2D[])rectangle2DArray, (Rectangle2D)rectangle2D, (double)d2).width;
        }
        YList yList = new YList();
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (n4 < rectangle2DArray.length) {
            Rectangle2D rectangle2D2 = rectangle2DArray[n4];
            yList.add(rectangle2DArray[n4]);
            n3 = (int)((double)n3 + rectangle2D2.getWidth() * rectangle2D2.getHeight());
            ++n4;
        }
        yList.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                Rectangle2D rectangle2D = (Rectangle2D)object;
                Rectangle2D rectangle2D2 = (Rectangle2D)object2;
                int n = (int)rectangle2D2.getHeight() - (int)rectangle2D.getHeight();
                if (n == 0) {
                    return (int)rectangle2D2.getWidth() - (int)rectangle2D.getWidth();
                }
                return n;
            }
        });
        double d9 = 0.0;
        double d10 = 0.0;
        int n5 = (int)(d2 * Math.sqrt((double)n3 / d2));
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = n5;
        int n10 = 0;
        YList yList2 = new YList();
        do {
            YList yList3 = new YList();
            yList2.add(yList3);
            n7 = 0;
            n6 = 0;
            n8 = 0;
            YCursor yCursor = yList.cursor();
            while (yCursor.ok()) {
                object3 = (Rectangle2D)yCursor.current();
                if ((double)n8 + ((RectangularShape)object3).getWidth() > (double)n9 && yList3.size() > 0) {
                    n7 = Math.max(n7, n8);
                    yList3 = new YList();
                    yList3.add(object3);
                    yList2.add(yList3);
                    n8 = (int)((RectangularShape)object3).getWidth();
                } else {
                    yList3.add(object3);
                    n8 = (int)((double)n8 + ((RectangularShape)object3).getWidth());
                }
                if (yList3.size() == 1) {
                    n6 = (int)((double)n6 + ((Rectangle2D)yList3.first()).getHeight());
                }
                yCursor.next();
            }
            if (!(d2 * (double)n6 > (double)(n7 = Math.max(n7, n8))) || n10 == n7) continue;
            yList2.clear();
            n9 = (int)((double)n9 * 1.1);
            n10 = n7;
        } while (yList2.isEmpty());
        double d11 = 0.0;
        object3 = yList2.cursor();
        while (object3.ok()) {
            double d12 = 0.0;
            object2 = (YList)object3.current();
            YCursor yCursor = ((YList)object2).cursor();
            while (yCursor.ok()) {
                object = (Rectangle2D)yCursor.current();
                ((Rectangle2D)object).setFrame(d12, d11, ((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight());
                d12 += ((RectangularShape)object).getWidth();
                yCursor.next();
            }
            d9 = Math.max(d9, d12);
            d10 = Math.max(d10, d11 += LayoutTool.a((YList)object2));
            object3.next();
        }
        switch (n) {
            case 4: {
                YCursor yCursor = yList2.cursor();
                while (yCursor.ok()) {
                    YList yList4 = (YList)yCursor.current();
                    double d13 = (d9 - LayoutTool.b(yList4)) / 2.0;
                    object = yList4.cursor();
                    while (object.ok()) {
                        Rectangle2D rectangle2D3 = (Rectangle2D)object.current();
                        rectangle2D3.setFrame(rectangle2D3.getX() + d13, rectangle2D3.getY(), rectangle2D3.getWidth(), rectangle2D3.getHeight());
                        object.next();
                    }
                    yCursor.next();
                }
                break;
            }
            case 2: {
                YCursor yCursor = yList2.cursor();
                while (yCursor.ok()) {
                    object2 = (YList)yCursor.current();
                    double d14 = d9 - LayoutTool.b((YList)object2);
                    YCursor yCursor2 = ((YList)object2).cursor();
                    while (yCursor2.ok()) {
                        Rectangle2D rectangle2D4 = (Rectangle2D)yCursor2.current();
                        rectangle2D4.setFrame(rectangle2D4.getX() + d14, rectangle2D4.getY(), rectangle2D4.getWidth(), rectangle2D4.getHeight());
                        yCursor2.next();
                    }
                    yCursor.next();
                }
                break;
            }
            case 3: {
                object2 = yList2.cursor();
                while (object2.ok()) {
                    double d15 = 0.0;
                    YList yList5 = (YList)object2.current();
                    if (yList5.size() > 1) {
                        double d16 = (d9 - LayoutTool.b(yList5)) / (double)(yList5.size() - 1);
                        YCursor yCursor = yList5.cursor();
                        while (yCursor.ok()) {
                            Rectangle2D rectangle2D5 = (Rectangle2D)yCursor.current();
                            rectangle2D5.setFrame(d15, rectangle2D5.getY(), rectangle2D5.getWidth(), rectangle2D5.getHeight());
                            d15 += rectangle2D5.getWidth() + d16;
                            yCursor.next();
                        }
                    }
                    object2.next();
                }
                break;
            }
        }
        if (rectangle2D != null) {
            rectangle2D.setFrame(0.0, 0.0, d9, d10);
        }
        return yList2.size();
    }

    private static double a(YList yList) {
        double d2 = 0.0;
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            d2 = Math.max(((Rectangle2D)yCursor.current()).getHeight(), d2);
            yCursor.next();
        }
        return d2;
    }

    private static double b(YList yList) {
        double d2 = 0.0;
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            d2 += ((Rectangle2D)yCursor.current()).getWidth();
            yCursor.next();
        }
        return d2;
    }
}

