/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.textcomponent;

import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;

public class TextPopupMenuAdapter
implements MouseListener {
    private JTextComponent textComponent;
    private JBasicMenuItem copyMenuItem;
    private JBasicMenuItem pasteMenuItem;
    private JBasicMenuItem cutMenuItem;
    private JBasicMenuItem clearMenuItem;
    private JBasicMenuItem selectAllMenuItem;
    private JBasicPopupMenu popupMenu;

    public TextPopupMenuAdapter(final JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.textComponent.addMouseListener(this);
        this.popupMenu = new JBasicPopupMenu();
        this.copyMenuItem = new JBasicMenuItem(SwingLocale.getString("copy"), (Icon)IconFactory.getSwingIcon("copy.png"), SwingLocale.getString("copy"));
        KeyStrokeManager.registerButton((AbstractButton)this.copyMenuItem, 67, 2, 'C');
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                textComponent.copy();
            }
        });
        this.popupMenu.add(this.copyMenuItem);
        this.pasteMenuItem = new JBasicMenuItem(SwingLocale.getString("paste"), (Icon)IconFactory.getSwingIcon("paste.png"), SwingLocale.getString("paste"));
        KeyStrokeManager.registerButton((AbstractButton)this.pasteMenuItem, 86, 2, 'V');
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                textComponent.paste();
            }
        });
        this.popupMenu.add(this.pasteMenuItem);
        this.cutMenuItem = new JBasicMenuItem(SwingLocale.getString("cut"), (Icon)IconFactory.getSwingIcon("cut.png"), SwingLocale.getString("cut"));
        KeyStrokeManager.registerButton((AbstractButton)this.cutMenuItem, 88, 2, 'X');
        this.cutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                textComponent.cut();
            }
        });
        this.popupMenu.add(this.cutMenuItem);
        this.clearMenuItem = new JBasicMenuItem(SwingLocale.getString("clean"), (Icon)IconFactory.getSwingIcon("clear.png"), SwingLocale.getString("clear"));
        ActionListener clearActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textComponent.setText("");
            }
        };
        this.clearMenuItem.addActionListener(clearActionListener);
        KeyStrokeManager.registerComponent(textComponent, clearActionListener, 82, 2);
        KeyStrokeManager.registerButton((AbstractButton)this.clearMenuItem, 82, 2, 'R');
        this.popupMenu.add(this.clearMenuItem);
        this.selectAllMenuItem = new JBasicMenuItem(SwingLocale.getString("select_all"), (Icon)IconFactory.getSwingIcon("select_all.png"), SwingLocale.getString("select_all"));
        KeyStrokeManager.registerButton((AbstractButton)this.selectAllMenuItem, 65, 2, 'A');
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                textComponent.requestFocusInWindow();
                textComponent.selectAll();
            }
        });
        this.popupMenu.add(this.selectAllMenuItem);
    }

    private boolean hasContent() {
        boolean hasContent = false;
        Clipboard clipboard = this.textComponent.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this.textComponent);
        try {
            hasContent = content.getTransferData(DataFlavor.stringFlavor) instanceof String;
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return hasContent;
    }

    private boolean canCopy() {
        return this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd();
    }

    private boolean canDelete() {
        return !this.textComponent.getText().equals("");
    }

    public JBasicPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public JBasicMenuItem getCopyMenuItem() {
        return this.copyMenuItem;
    }

    public JBasicMenuItem getPasteMenuItem() {
        return this.pasteMenuItem;
    }

    public JBasicMenuItem getCutMenuItem() {
        return this.cutMenuItem;
    }

    public JBasicMenuItem getClearMenuItem() {
        return this.clearMenuItem;
    }

    public JBasicMenuItem getSelectAllMenuItem() {
        return this.selectAllMenuItem;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        if (!this.textComponent.isEnabled()) {
            return;
        }
        if (this.textComponent.isEditable()) {
            this.copyMenuItem.setEnabled(this.canCopy());
            this.pasteMenuItem.setEnabled(this.hasContent());
            this.cutMenuItem.setEnabled(this.canCopy());
            this.clearMenuItem.setEnabled(this.canDelete());
        } else {
            this.copyMenuItem.setEnabled(this.canCopy());
            this.pasteMenuItem.setEnabled(false);
            this.cutMenuItem.setEnabled(false);
            this.clearMenuItem.setEnabled(false);
        }
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

