/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.gis.google.loc;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.combobox.JBasicComboBox;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.layout.toolbar.ToolBarLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.searcher.gis.google.loc.JLocTable;
import com.nepxion.swing.searcher.gis.google.loc.LocController;
import com.nepxion.swing.textfield.number.JNumberTextField;
import com.nepxion.util.locale.LocaleConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JCoordinatePanel
extends JPanel {
    private JNumberTextField latitudeTextField;
    private JNumberTextField longitudeTextField;
    private JBasicComboBox languageComboBox;
    private JLocTable table = new JLocTable();

    public JCoordinatePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new ToolBar(), "North");
        this.add((Component)new JBasicScrollPane(this.table), "Center");
    }

    public JLocTable getLocTable() {
        return this.table;
    }

    public double getLatitude() {
        return Double.parseDouble(this.latitudeTextField.getText());
    }

    public void setLatitude(double latitude) {
        this.latitudeTextField.setText(latitude + "");
    }

    public double getLongitude() {
        return Double.parseDouble(this.longitudeTextField.getText());
    }

    public void setLongitude(double longitude) {
        this.longitudeTextField.setText(longitude + "");
    }

    public String getLanguage() {
        ElementNode selectedElementNode = (ElementNode)this.languageComboBox.getSelectedItem();
        Locale locale = (Locale)selectedElementNode.getUserObject();
        return locale.toString();
    }

    public void setLanguage(String language) {
        for (int i = 0; i < this.languageComboBox.getItemCount(); ++i) {
            ElementNode selectedElementNode = (ElementNode)this.languageComboBox.getItemAt(i);
            Locale locale = (Locale)selectedElementNode.getUserObject();
            if (!locale.toString().equals(language)) continue;
            this.languageComboBox.setSelectedIndex(i);
            return;
        }
    }

    public class ToolBar
    extends JPanel {
        public ToolBar() {
            this.setLayout(new ToolBarLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JCoordinatePanel.this.latitudeTextField = new JNumberTextField(11, 7, -215.0, 215.0);
            DimensionManager.setDimension(JCoordinatePanel.this.latitudeTextField, new Dimension(100, 23));
            JCoordinatePanel.this.longitudeTextField = new JNumberTextField(11, 7, -215.0, 215.0);
            DimensionManager.setDimension(JCoordinatePanel.this.longitudeTextField, new Dimension(100, 23));
            Locale[] locales = LocaleConstants.LOCALE_LIST;
            Object[] elementNodes = new ElementNode[locales.length];
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                String text = SwingLocale.getString(locale.toString().toLowerCase());
                elementNodes[i] = new ElementNode(text, null, text, locale);
            }
            JCoordinatePanel.this.languageComboBox = new JBasicComboBox(elementNodes);
            DimensionManager.setDimension(JCoordinatePanel.this.languageComboBox, new Dimension(90, 23));
            JBasicButton searchButton = new JBasicButton(LocController.getSearchAction(JCoordinatePanel.this));
            JBasicButton clearButton = new JBasicButton(LocController.getClearAction(JCoordinatePanel.this.table));
            this.add(new JLabel(SwingLocale.getString("latitude")));
            this.add(JCoordinatePanel.this.latitudeTextField);
            this.add(Box.createHorizontalStrut(5));
            this.add(new JLabel(SwingLocale.getString("longitude")));
            this.add(JCoordinatePanel.this.longitudeTextField);
            this.add(Box.createHorizontalStrut(5));
            this.add(new JLabel(SwingLocale.getString("language")));
            this.add(JCoordinatePanel.this.languageComboBox);
            this.add(searchButton);
            this.add(clearButton);
            this.add(Box.createHorizontalGlue());
            ButtonManager.updateUI(this);
        }
    }
}

