/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.List;
import twaver.BaseElement;
import twaver.TWaverConst;
import twaver.base.A.E.o;

public class Item
extends BaseElement {
    public static final NumberFormat DEFAULT_INT_FORMATER = TWaverConst.DEFAULT_INT_FORMATER;
    public static final NumberFormat DEFAULT_DOUBLE_FORMATER = TWaverConst.DEFAULT_DOUBLE_FORMATER;

    public Item() {
        this(null);
    }

    public Item(String name) {
        this(name, 0.0, o.E(), name, null);
    }

    public Item(String name, Color color) {
        this(name, 0.0, color, name, null);
    }

    public Item(String name, double value, Color color) {
        this(name, value, color, name, null);
    }

    public Item(String name, double value, Color color, String toolTipText) {
        this(name, value, color, toolTipText, null);
    }

    public Item(String name, double value, Color color, String toolTipText, NumberFormat format) {
        this.setName(name);
        this.setValue(value);
        this.setColor(color);
        this.setToolTipText(toolTipText);
        this.setFormat(format);
    }

    public Color getColor() {
        return this.getChartColor();
    }

    public void setColor(Color color) {
        this.putChartColor(color);
    }

    public NumberFormat getFormat() {
        return this.getChartFormat();
    }

    public void setFormat(NumberFormat format) {
        this.putChartFormat(format);
    }

    public double getValue() {
        return this.getChartValue();
    }

    public void setValue(double value) {
        this.putChartValue(value);
    }

    public void addValue(double value) {
        List values = this.getChartValues();
        values.add(new Double(value));
        this.firePropertyChange("chart.values", null, values);
    }

    public List getValueList() {
        return this.getChartValues();
    }

    public void setValueList(List valueList) {
        this.putChartValues(valueList);
    }
}

