/*
 * Decompiled with CFR 0.152.
 */
package twaver.network;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Timer;
import twaver.DataBoxAdapter;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxSelectionEvent;
import twaver.DataBoxSelectionListener;
import twaver.Element;
import twaver.Node;
import twaver.TDataBox;
import twaver.ZoomListener;
import twaver.network.TNetwork;

public class CloudLayouter {
    protected TDataBox box;
    protected TNetwork network;
    private double D;
    private double B;
    private double g = 1.0;
    private Rectangle Y;
    private Point2D h;
    private double U = -1.0;
    private double W = -1.0;
    private List e = new ArrayList();
    private double T;
    private double c;
    private double S;
    private double b;
    private double R;
    private double a;
    private double H = 1.0;
    private double V = 0.9;
    private double f = 0.01;
    private double E;
    private double C;
    private boolean i;
    private double M = 1.0;
    private double J = 1.0;
    private boolean _ = true;
    private Timer X = new Timer(50, null);
    private boolean k = true;
    private boolean F = true;
    private DataBoxListener j = new DataBoxAdapter(){

        public void elementAdded(DataBoxEvent e2) {
            CloudLayouter.this.handleDataBoxChange(e2);
        }

        public void elementRemoved(DataBoxEvent e2) {
            CloudLayouter.this.handleDataBoxChange(e2);
        }

        public void elementsCleared(DataBoxEvent e2) {
            CloudLayouter.this.handleDataBoxChange(e2);
        }
    };
    private DataBoxSelectionListener A = new DataBoxSelectionListener(){

        public void selectionChanged(DataBoxSelectionEvent e2) {
            if (CloudLayouter.this.box.getLastSelectedElement() instanceof Node) {
                CloudLayouter.this.centerElement((Node)CloudLayouter.this.box.getLastSelectedElement());
            } else {
                CloudLayouter.this.centerElement(null);
            }
        }
    };
    private ComponentListener I = new ComponentAdapter(){

        public void componentResized(ComponentEvent e2) {
            CloudLayouter.this.handleResize(e2);
        }
    };
    private MouseListener Z = new MouseAdapter(){

        public void mouseEntered(MouseEvent e2) {
            CloudLayouter.this.handleMouseOver(e2);
        }

        public void mouseExited(MouseEvent e2) {
            CloudLayouter.this.handleRollOut(e2);
        }
    };
    private MouseMotionListener d = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent e2) {
            CloudLayouter.this.handleMouseMove(e2);
        }
    };
    private PropertyChangeListener G = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            CloudLayouter.this.handleNetworkPropertyChange(evt);
        }
    };
    private ActionListener Q = new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            CloudLayouter.this.A(e2);
        }
    };
    private ZoomListener P = new ZoomListener(){

        public void zoomChanged(double oldZoom, double newZoom) {
            CloudLayouter.this.handleNetworkZoomChange(oldZoom, newZoom);
        }
    };
    private Comparator L = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((_A)o1).D < ((_A)o2).D ? -1 : 1;
        }
    };
    private boolean N = false;
    private _A K = null;
    private boolean O = false;

    public CloudLayouter(TNetwork network) {
        if (network == null) {
            throw new IllegalArgumentException("network can not be null");
        }
        this.network = network;
    }

    private void A(ActionEvent event) {
        this.D();
    }

    public TNetwork getNetwork() {
        return this.network;
    }

    public boolean isLayoutable(Node node) {
        return this.network.isVisible(node) && this.network.isMovable(node);
    }

    public Timer getTimer() {
        return this.X;
    }

    private void A() {
        this.box = this.network.getDataBox();
        this.box.getSelectionModel().addDataBoxSelectionListener(this.A);
        this.box.addDataBoxListener(this.j);
        this.network.getCanvas().addComponentListener(this.I);
        this.network.getCanvas().addMouseListener(this.Z);
        this.network.getCanvas().addMouseMotionListener(this.d);
        this.network.addPropertyChangeListener(this.G);
        this.network.getZoomer().addZoomListener(this.P);
        this.X.addActionListener(this.Q);
    }

    private void B() {
        this.box.removeDataBoxListener(this.j);
        this.box.getSelectionModel().removeDataBoxSelectionListener(this.A);
        this.network.getCanvas().removeComponentListener(this.I);
        this.network.getCanvas().removeMouseListener(this.Z);
        this.network.getCanvas().removeMouseMotionListener(this.d);
        this.network.removePropertyChangeListener(this.G);
        this.network.getZoomer().removeZoomListener(this.P);
        this.X.removeActionListener(this.Q);
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean needToReset) {
        if (this.X.isRunning()) {
            return;
        }
        this.A();
        if (needToReset) {
            this.updateLayoutRect(true);
        }
        this.X.start();
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean removeListeners) {
        if (this.X.isRunning()) {
            this.X.stop();
            if (removeListeners) {
                this.B();
            }
        }
    }

    public boolean isRunning() {
        return this.X.isRunning();
    }

    public int getTimerDelay() {
        return this.X.getDelay();
    }

    public void setTimerDelay(int delay) {
        this.X.setDelay(delay);
    }

    public double getMoveSpeed() {
        return this.H;
    }

    public void setMoveSpeed(double value) {
        this.H = value;
    }

    public double getCeaseRate() {
        return this.V;
    }

    public void setCeaseRate(double value) {
        this.V = value;
    }

    public double getCeaseLimit() {
        return this.f;
    }

    public void setCeaseLimit(double value) {
        this.f = value;
    }

    public boolean isElliptical() {
        return this._;
    }

    public void setElliptical(boolean value) {
        this._ = value;
    }

    public boolean getActive() {
        return this.i;
    }

    public void setActive(boolean value) {
        this.i = value;
    }

    public boolean getUpdateLayoutRectOnResized() {
        return this.F;
    }

    public void setUpdateLayoutRectOnResized(boolean value) {
        this.F = value;
    }

    public boolean getReloadOnDataBoxChanged() {
        return this.k;
    }

    public void setReloadOnDataBoxChanged(boolean value) {
        this.k = value;
    }

    public Rectangle getLayoutRect() {
        double w = (double)this.network.getCanvas().getWidth() / this.network.getZoom();
        double h2 = (double)this.network.getCanvas().getHeight() / this.network.getZoom();
        return new Rectangle((int)(w / 4.0), (int)(h2 / 4.0), (int)(w / 2.0), (int)(h2 / 2.0));
    }

    public void updateLayoutRect() {
        this.updateLayoutRect(false);
    }

    public void updateLayoutRect(boolean needToReload) {
        double last = this.g;
        this.Y = this.getLayoutRect();
        if (this.Y.width <= 1) {
            this.Y.width = 1;
        }
        if (this.Y.height <= 1) {
            this.Y.height = 1;
        }
        this.g = Math.min(this.Y.getWidth() / 2.0, this.Y.getHeight() / 2.0);
        if (this.isElliptical()) {
            this.M = this.Y.getWidth() / 2.0 / this.g;
            this.J = this.Y.getHeight() / 2.0 / this.g;
        } else {
            this.M = 1.0;
            this.J = 1.0;
        }
        this.D = this.Y.getX() + this.Y.getWidth() / 2.0;
        this.B = this.Y.getY() + this.Y.getHeight() / 2.0;
        if (needToReload) {
            this.reload();
        } else {
            this.E = 1.0;
            this.C = 1.0;
            int max = this.e.size();
            for (int i2 = 1; i2 < max + 1; ++i2) {
                _A nodeStruct = (_A)this.e.get(i2 - 1);
                nodeStruct.A *= this.g / last;
                nodeStruct.E *= this.g / last;
                nodeStruct.D *= this.g / last;
            }
            if (this.O) {
                this.A(0.0, 0.0, 0.0);
            } else {
                this.D();
            }
        }
        this.U = this.network.getCanvas().getWidth();
        this.W = this.network.getCanvas().getHeight();
    }

    private void A(double a2, double b2, double c2) {
        this.B(a2, b2, c2);
        for (int j2 = 0; j2 < this.e.size(); ++j2) {
            _A nodeStruct = (_A)this.e.get(j2);
            double rx1 = nodeStruct.A;
            double ry1 = nodeStruct.E * this.c + nodeStruct.D * -this.T;
            double rz1 = nodeStruct.E * this.T + nodeStruct.D * this.c;
            double rx2 = rx1 * this.b + rz1 * this.S;
            double ry2 = ry1;
            double rz2 = rx1 * -this.S + rz1 * this.b;
            double rx3 = rx2 * this.a + ry2 * -this.R;
            double ry3 = rx2 * this.R + ry2 * this.a;
            double rz3 = rz2;
            nodeStruct.A = rx3;
            nodeStruct.E = ry3;
            nodeStruct.D = rz3;
            double perspective = this.g * 2.0;
            perspective /= perspective + rz3;
            nodeStruct.C = perspective;
            double x = this.M * rx3 * perspective - this.M * 2.0 + this.D;
            double y = ry3 * perspective * this.J + this.B;
            nodeStruct.B.setCenterLocation(x, y);
        }
        this.C();
    }

    public void reload() {
        this.O = false;
        this.K = null;
        this.N = false;
        this.h = null;
        this.e = new ArrayList();
        List datas = this.network.getDataBox().getAllElements();
        int count = datas.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Object o2 = datas.get(i2);
            if (!(o2 instanceof Node) || !this.isLayoutable((Node)o2)) continue;
            _A nodeStruct = new _A();
            nodeStruct.B = (Node)o2;
            this.e.add(nodeStruct);
        }
        this.B(0.0, 0.0, 0.0);
        this.i = false;
        this.E = 1.0;
        this.C = 1.0;
        double phi = 0.0;
        double theta = 0.0;
        int max = this.e.size();
        for (int i3 = 1; i3 < max + 1; ++i3) {
            phi = Math.acos(-1.0 + (2.0 * (double)i3 - 1.0) / (double)max);
            theta = Math.sqrt((double)max * Math.PI) * phi;
            _A nodeStruct = (_A)this.e.get(i3 - 1);
            nodeStruct.A = this.g * Math.cos(theta) * Math.sin(phi);
            nodeStruct.E = this.g * Math.sin(theta) * Math.sin(phi);
            nodeStruct.D = this.g * Math.cos(phi);
        }
    }

    private void B(double a2, double b2, double c2) {
        double sineCosineDtr = Math.PI / 180;
        this.T = Math.sin(a2 * sineCosineDtr);
        this.c = Math.cos(a2 * sineCosineDtr);
        this.S = Math.sin(b2 * sineCosineDtr);
        this.b = Math.cos(b2 * sineCosineDtr);
        this.R = Math.sin(c2 * sineCosineDtr);
        this.a = Math.cos(c2 * sineCosineDtr);
    }

    protected void handleDataBoxChange(DataBoxEvent e2) {
        if (this.k || e2.getType() == 3) {
            this.reload();
        }
    }

    protected boolean mouseMove(MouseEvent e2) {
        return true;
    }

    protected boolean mouseOver(MouseEvent e2) {
        return true;
    }

    protected void handleMouseMove(MouseEvent e2) {
        if (!this.N) {
            this.A(e2);
        }
        this.i = this.mouseMove(e2);
    }

    protected void handleMouseOver(MouseEvent e2) {
        if (!this.N) {
            this.A(e2);
        }
        this.i = this.mouseOver(e2);
    }

    private void A(MouseEvent e2) {
        this.h = this.getNetwork().getLogicalPoint(e2.getPoint());
    }

    protected void handleRollOut(MouseEvent e2) {
        this.i = false;
    }

    protected void handleResize(ComponentEvent e2) {
        if (!this.F) {
            return;
        }
        if (Math.abs((double)this.network.getCanvas().getWidth() - this.U) <= 2.0 && Math.abs((double)this.network.getCanvas().getHeight() - this.W) <= 2.0) {
            return;
        }
        this.updateLayoutRect();
    }

    protected void handleNetworkPropertyChange(PropertyChangeEvent e2) {
        if ("databox".equals(e2.getPropertyName())) {
            this.box.removeDataBoxListener(this.j);
            this.box.getSelectionModel().removeDataBoxSelectionListener(this.A);
            this.box = this.network.getDataBox();
            this.box.addDataBoxListener(this.j);
            this.box.getSelectionModel().addDataBoxSelectionListener(this.A);
            this.reload();
        }
    }

    protected void handleNetworkZoomChange(double oldZoom, double newZoom) {
        this.h = null;
        this.updateLayoutRect();
    }

    private void C() {
        Collections.sort(this.e, this.L);
        int count = this.e.size();
        for (int i2 = 0; i2 < count; ++i2) {
            _A nodeStruct = (_A)this.e.get(i2);
            Element node = nodeStruct.B;
            this.box.getLayers().remove(node);
            this.box.getLayers().add(i2, node);
            this.box.fireIndexChanged(node);
            this.updateNode(node, i2, count, nodeStruct.C);
        }
    }

    protected void updateNode(Element node, int zIndex, int count, double perspective) {
    }

    private void D() {
        double b2;
        double a2;
        boolean atCenter;
        if (this.O || !this.network.getCanvas().isShowing()) {
            return;
        }
        if (this.N && this.K != null && (atCenter = this.isAtCenter(this.K.B, this.K.C, this.K.A, this.K.E, this.K.D))) {
            this.O = true;
            this.N = false;
            this.K = null;
            return;
        }
        if (!this.O && (this.i || this.N) && this.h != null) {
            if (!this.isElliptical()) {
                a2 = (this.B - this.h.getY()) / this.g * this.H;
                b2 = (this.h.getX() - this.D) / this.g * this.H;
            } else {
                a2 = (this.B - this.h.getY()) / (this.Y.getHeight() / 2.0) * this.H;
                b2 = (this.h.getX() - this.D) / (this.Y.getHeight() / 2.0) * this.H;
            }
        } else {
            a2 = this.E * this.V;
            b2 = this.C * this.V;
        }
        this.E = a2;
        this.C = b2;
        if (Math.abs(a2) > this.f || Math.abs(b2) > this.f) {
            double c2 = 0.0;
            this.A(a2, b2, c2);
        }
    }

    protected boolean isAtCenter(Element node, double perspective, double cx, double cy, double cz) {
        double moveSpeed = this.getMoveSpeed();
        if (moveSpeed <= 0.0) {
            return true;
        }
        double z2r = 10.0 / moveSpeed;
        if (z2r > 20.0) {
            z2r = 20.0;
        } else if (z2r < 2.0) {
            z2r = 2.0;
        }
        return -cz / Math.sqrt(cx * cx + cy * cy) > z2r;
    }

    public int size() {
        return this.e.size();
    }

    public void centerElement(Node node) {
        if (node != null && this.isLayoutable(node)) {
            if (this.K != null && node.equals(this.K.B) && this.O) {
                return;
            }
            for (int i2 = 0; i2 < this.e.size(); ++i2) {
                _A nodeStruct = (_A)this.e.get(i2);
                if (!node.equals(nodeStruct.B)) continue;
                this.N = true;
                this.i = true;
                this.K = nodeStruct;
                this.h = this.createControlPoint(this.K.B);
            }
        } else {
            this.N = false;
            this.O = false;
            this.i = false;
            this.h = null;
        }
    }

    protected Point2D createControlPoint(Element node) {
        Point nodePoint = node.getCenterLocation();
        Rectangle layoutRect = this.getLayoutRect();
        double layoutCenterX = layoutRect.getCenterX();
        double layoutCenterY = layoutRect.getCenterY();
        double angle = Math.atan2(nodePoint.getY() - layoutCenterY, nodePoint.getX() - layoutCenterX);
        double distance = layoutRect.getWidth() + layoutRect.getHeight();
        return new Point2D.Double(layoutCenterX + distance * Math.cos(angle), layoutCenterY + distance * Math.sin(angle));
    }

    class _A {
        double A;
        double E;
        double D;
        double C;
        Element B;

        _A() {
        }
    }
}

