/*
 * Decompiled with CFR 0.152.
 */
package y.util.pq;

import y.base.DataProvider;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.util.pq.IntNodePQ;

public class ArrayIntNodePQ
implements IntNodePQ {
    private NodeMap t = null;
    private boolean s = false;
    private YList[] n = null;
    private YList r = null;
    private _a[] m = null;
    private Node q = null;
    private int p = 0;
    private Graph o;

    public ArrayIntNodePQ(Graph graph, int n) {
        NodeMap nodeMap = graph.createNodeMap();
        this.a(graph, nodeMap, n);
        this.s = true;
    }

    public ArrayIntNodePQ(Graph graph, DataProvider dataProvider) {
        this.t = graph.createNodeMap();
        int n = 0;
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            int n2 = dataProvider.getInt(nodeCursor.node());
            n = Math.max(n2, n);
            nodeCursor.next();
        }
        this.a(graph, this.t, n);
        NodeCursor nodeCursor2 = this.o.nodes();
        while (nodeCursor2.ok()) {
            this.add(nodeCursor2.node(), dataProvider.getInt(nodeCursor2.node()));
            nodeCursor2.next();
        }
        this.s = true;
    }

    public ArrayIntNodePQ(Graph graph, NodeMap nodeMap, int n) {
        this.a(graph, nodeMap, n);
        this.s = false;
    }

    private void a(Graph graph, NodeMap nodeMap, int n) {
        this.o = graph;
        this.t = nodeMap;
        this.n = new YList[n + 1];
        this.q = null;
        this.r = new YList();
        this.m = new _a[this.o.nodeCount()];
        int n2 = 0;
        NodeCursor nodeCursor = this.o.nodes();
        while (nodeCursor.ok()) {
            this.m[n2] = new _a(nodeCursor.node());
            ++n2;
            nodeCursor.next();
        }
    }

    public void clear() {
        YCursor yCursor = this.r.cursor();
        while (yCursor.ok()) {
            Node node = (Node)yCursor.current();
            this.n[this.t.getInt(node)].clear();
            this.m[node.index()].c = false;
            yCursor.next();
        }
        this.r.clear();
        this.q = null;
    }

    public boolean isEmpty() {
        return this.r.size() == 0;
    }

    public boolean contains(Node node) {
        return this.m[node.index()].c;
    }

    public void add(Node node, int n) {
        int n2 = node.index();
        this.t.setInt(node, n);
        this.m[n2].c = true;
        YList yList = this.getList(n);
        yList.addLastCell(this.m[n2].a);
        this.r.addLastCell(this.m[n2].d);
        if (this.q == null || n < this.p) {
            this.q = node;
            this.p = n;
        }
    }

    public void remove(Node node) {
        int n = node.index();
        this.m[n].c = false;
        YList yList = this.n[this.t.getInt(node)];
        yList.removeCell(this.m[n].a);
        this.r.removeCell(this.m[n].d);
        if (this.r.size() > 0) {
            while (this.p < this.n.length) {
                if (this.n[this.p] != null && this.n[this.p].size() > 0) break;
                ++this.p;
            }
            this.q = (Node)this.n[this.p].first();
            if (!this.m[this.q.index()].c) {
                throw new RuntimeException("Consistency check failed: Tried to make " + this.q + " with " + this.p + " to new minimal node which is not part of the actual list !");
            }
        } else {
            this.q = null;
        }
    }

    public Node getMin() {
        return this.q;
    }

    public void decreasePriority(Node node, int n) {
        YList yList = this.n[this.t.getInt(node)];
        ListCell listCell = this.m[node.index()].a;
        yList.removeCell(listCell);
        this.getList(n).addLastCell(listCell);
        this.t.setInt(node, n);
        if (n < this.p) {
            this.q = node;
            this.p = n;
        }
    }

    public void increasePriority(Node node, int n) {
        int n2 = this.t.getInt(node);
        YList yList = this.n[n2];
        ListCell listCell = this.m[node.index()].a;
        yList.removeCell(listCell);
        this.getList(n).addLastCell(listCell);
        this.t.setInt(node, n);
        if (node == this.q) {
            while (yList.isEmpty()) {
                yList = this.n[++n2];
            }
            this.q = (Node)yList.first();
            this.p = n2;
        }
    }

    public void changePriority(Node node, int n) {
        int n2 = this.getPriority(node);
        if (n < n2) {
            this.decreasePriority(node, n);
        } else if (n2 > n) {
            this.increasePriority(node, n);
        }
    }

    public Node removeMin() {
        Node node = this.q;
        this.remove(node);
        return node;
    }

    public int getPriority(Node node) {
        return this.t.getInt(node);
    }

    public void dispose() {
        if (this.s) {
            this.o.disposeNodeMap(this.t);
        }
    }

    protected YList getList(int n) {
        if (this.n[n] == null) {
            this.n[n] = new YList();
        }
        return this.n[n];
    }

    private static class _a {
        private static YList b = new YList();
        public ListCell a = null;
        public ListCell d = null;
        public boolean c;

        public _a(Node node) {
            this.d = b.addLast(node);
            this.a = b.addLast(node);
        }
    }
}

