/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.utils;

import twaver.gis.GeographyMap;
import twaver.gis.GisManager;
import twaver.gis.gadget.inputhandler.CustomSelectionInteraction;
import twaver.gis.gadget.inputhandler.DefaultGisInterHandler;
import twaver.gis.gadget.inputhandler.DistanceInputHandler;
import twaver.gis.gadget.inputhandler.GisPanInterHandler;
import twaver.gis.gadget.inputhandler.SelectInputHandler;
import twaver.gis.gadget.inputhandler.ZoomInputHandler;
import twaver.network.InteractionMode;
import twaver.network.TNetwork;
import twaver.network.inputhandler.DefaultInputHandler;
import twaver.network.inputhandler.EagerMoveInputHandler;
import twaver.network.inputhandler.InputHandler;
import twaver.network.inputhandler.InteractionInputHandler;
import twaver.network.inputhandler.PopupMenuInputHandler;
import twaver.network.inputhandler.SelectionInputHandler;

public class GisInputHandlerFactory {
    public static InteractionMode createZoomMode(TNetwork network, GeographyMap map) {
        InputHandler[] listeners = new InputHandler[]{new ZoomInputHandler(network, map)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode createZoomMode(TNetwork network, GeographyMap map, int mode) {
        InputHandler[] listeners = new InputHandler[]{new ZoomInputHandler(network, map, mode)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode createDefaultMode(TNetwork network, GeographyMap map) {
        map.setMapMode(-1);
        boolean seperated = GisManager.getBoolean("use.seperate.default.mode");
        boolean showSelectionArea = GisManager.getBoolean("show.selection.area");
        InputHandler[] listeners = null;
        listeners = seperated ? new InputHandler[]{new DefaultInputHandler(network), showSelectionArea ? new SelectionInputHandler(network) : new CustomSelectionInteraction(network), new EagerMoveInputHandler(network), new InteractionInputHandler(network), new PopupMenuInputHandler(network)} : new InputHandler[]{new DefaultGisInterHandler(network, map), new DefaultInputHandler(network), new CustomSelectionInteraction(network), new EagerMoveInputHandler(network), new InteractionInputHandler(network), new PopupMenuInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode createResetMode(TNetwork network, GeographyMap map) {
        map.addBackAndForwardTask();
        map.reset();
        return network.getInteractionMode();
    }

    public static InteractionMode createSelectMode(TNetwork network, GeographyMap map) {
        InputHandler[] listeners = new InputHandler[]{new SelectInputHandler(network, map)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode createPanMode(GeographyMap map) {
        InputHandler[] listeners = new InputHandler[]{new GisPanInterHandler(map)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode createPanMode(TNetwork network, GeographyMap map) {
        InputHandler[] listeners = new InputHandler[]{new GisPanInterHandler(network, map)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode createDistanceMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DistanceInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode createDistanceMode(TNetwork network, GeographyMap map) {
        InputHandler[] listeners = new InputHandler[]{new DistanceInputHandler(network, map)};
        return new InteractionMode(listeners);
    }
}

