/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TLabelConfigData;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.border.BorderManager;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.renderer.list.RadioButtonListCellRenderer;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;

public class TLabelConfig
extends JPanel {
    private JList nodeLabelList;
    private JList groupLabelList;
    private JList linkLabelList;

    public TLabelConfig() {
        double[][] size = new double[][]{{-1.0}, {100.0}};
        this.nodeLabelList = new JList();
        JPanel nodeLabelPanel = new JPanel();
        nodeLabelPanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("label_node")));
        nodeLabelPanel.setLayout((LayoutManager)new TableLayout((double[][])size));
        nodeLabelPanel.add((Component)new JBasicScrollPane((Component)this.nodeLabelList), "0, 0");
        this.groupLabelList = new JList();
        JPanel groupLabelPanel = new JPanel();
        groupLabelPanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("label_group")));
        groupLabelPanel.setLayout((LayoutManager)new TableLayout((double[][])size));
        groupLabelPanel.add((Component)new JBasicScrollPane((Component)this.groupLabelList), "0, 0");
        this.linkLabelList = new JList();
        JPanel linkLabelPanel = new JPanel();
        linkLabelPanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("label_link")));
        linkLabelPanel.setLayout((LayoutManager)new TableLayout((double[][])size));
        linkLabelPanel.add((Component)new JBasicScrollPane((Component)this.linkLabelList), "0, 0");
        this.setLayout(new BoxLayout(this, 1));
        this.add(nodeLabelPanel);
        this.add(groupLabelPanel);
        this.add(linkLabelPanel);
        this.setPreferredSize(new Dimension(250, this.getPreferredSize().height));
    }

    public void setNodeLabelList(TLabelConfigData[] labelConfigDatas, int selectedIndex) {
        this.setLabelList(this.nodeLabelList, labelConfigDatas, selectedIndex);
    }

    public void setGroupLabelList(TLabelConfigData[] labelConfigDatas, int selectedIndex) {
        this.setLabelList(this.groupLabelList, labelConfigDatas, selectedIndex);
    }

    public void setLinkLabelList(TLabelConfigData[] labelConfigDatas, int selectedIndex) {
        this.setLabelList(this.linkLabelList, labelConfigDatas, selectedIndex);
    }

    private void setLabelList(JList list, TLabelConfigData[] labelConfigDatas, int selectedIndex) {
        DefaultListModel<ElementNode> listModel = new DefaultListModel<ElementNode>();
        for (int i = 0; i < labelConfigDatas.length; ++i) {
            TLabelConfigData labelConfigData = labelConfigDatas[i];
            boolean isSelected = false;
            if (i == selectedIndex) {
                isSelected = true;
            }
            ElementNode labelData = new ElementNode(labelConfigData.getName(), null, labelConfigData.getName(), (Object)labelConfigData, isSelected);
            listModel.addElement(labelData);
        }
        list.setModel(listModel);
        list.setCellRenderer(new RadioButtonListCellRenderer(list));
    }

    public TLabelConfigData getNodeLabelData() {
        return this.getLabelData(this.nodeLabelList);
    }

    public TLabelConfigData getGroupLabelData() {
        return this.getLabelData(this.groupLabelList);
    }

    public TLabelConfigData getLinkLabelData() {
        return this.getLabelData(this.linkLabelList);
    }

    private TLabelConfigData getLabelData(JList list) {
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            ElementNode nodeElementNode = (ElementNode)list.getModel().getElementAt(i);
            if (!nodeElementNode.isSelected()) continue;
            TLabelConfigData selecetdLabelConfigData = (TLabelConfigData)nodeElementNode.getUserObject();
            return selecetdLabelConfigData;
        }
        return null;
    }
}

