/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.ui.explorer;

import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.ui.explorer.UIExplorerConstants;
import com.nepxion.swing.ui.explorer.UIExplorerTreeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class UIExplorerTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        UIExplorerTreeNode treeNode = (UIExplorerTreeNode)value;
        String treeNodeName = treeNode.getKey().toString();
        String iconName = null;
        if (treeNodeName.equals(UIExplorerConstants.ROOT_NAME)) {
            iconName = "theme/ui/explorer/tree_root.png";
        } else if (treeNodeName.equals(UIExplorerConstants.ALL_NAME)) {
            iconName = expanded ? "theme/ui/explorer/catalog_all_tree_open.png" : "theme/ui/explorer/catalog_all_tree_closed.png";
        } else if (treeNodeName.equals(UIExplorerConstants.COMPONENT_NAME)) {
            iconName = expanded ? "theme/ui/explorer/catalog_component_tree_open.png" : "theme/ui/explorer/catalog_component_tree_closed.png";
        } else if (treeNodeName.equals(UIExplorerConstants.TYPE_NAME)) {
            iconName = expanded ? "theme/ui/explorer/catalog_type_tree_open.png" : "theme/ui/explorer/catalog_type_tree_closed.png";
        } else {
            String parentTreeNodeName = treeNode.getParent().toString();
            if (parentTreeNodeName.equals(UIExplorerConstants.ALL_NAME)) {
                iconName = "theme/ui/explorer/catalog_all_tree_leaf.png";
            } else if (parentTreeNodeName.equals(UIExplorerConstants.COMPONENT_NAME)) {
                iconName = "theme/ui/explorer/catalog_component_tree_leaf.png";
            } else if (parentTreeNodeName.equals(UIExplorerConstants.TYPE_NAME)) {
                iconName = "theme/ui/explorer/catalog_type_tree_leaf.png";
            }
        }
        this.setIcon(IconFactory.getSwingIcon(iconName));
        tree.setRowHeight(20);
        return this;
    }
}

