/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.dialog;

import com.nepxion.swing.dialog.DialogResizer;
import com.nepxion.swing.listener.DisplayAbilityListener;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.window.WindowManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class JBasicDialog
extends JDialog {
    private boolean hint = false;
    private boolean adaptable = false;
    private Dimension dimension;
    private Dimension minimumDimension;
    private Dimension maximumDimension;
    private DialogResizer resizer;

    public JBasicDialog(Frame owner, String title) {
        this(owner, title, null);
    }

    public JBasicDialog(Dialog owner, String title) {
        this(owner, title, null);
    }

    public JBasicDialog(Frame owner, String title, Dimension dimension) {
        this(owner, title, dimension, true);
    }

    public JBasicDialog(Dialog owner, String title, Dimension dimension) {
        this(owner, title, dimension, true);
    }

    public JBasicDialog(Frame owner, String title, boolean modal) {
        this(owner, title, null, modal, false);
    }

    public JBasicDialog(Dialog owner, String title, boolean modal) {
        this(owner, title, null, modal, false);
    }

    public JBasicDialog(Frame owner, String title, Dimension dimension, boolean modal) {
        this(owner, title, dimension, modal, false);
    }

    public JBasicDialog(Dialog owner, String title, Dimension dimension, boolean modal) {
        this(owner, title, dimension, modal, false);
    }

    public JBasicDialog(Frame owner, String title, boolean modal, boolean hint) {
        this(owner, title, null, modal, hint, false);
    }

    public JBasicDialog(Dialog owner, String title, boolean modal, boolean hint) {
        this(owner, title, null, modal, hint, false);
    }

    public JBasicDialog(Frame owner, String title, Dimension dimension, boolean modal, boolean hint) {
        this(owner, title, dimension, modal, hint, false);
    }

    public JBasicDialog(Dialog owner, String title, Dimension dimension, boolean modal, boolean hint) {
        this(owner, title, dimension, modal, hint, false);
    }

    public JBasicDialog(Frame owner, String title, boolean modal, boolean hint, boolean adaptable) {
        this(owner, title, null, modal, hint, adaptable);
    }

    public JBasicDialog(Dialog owner, String title, boolean modal, boolean hint, boolean adaptable) {
        this(owner, title, null, modal, hint, adaptable);
    }

    public JBasicDialog(Frame owner, String title, Dimension dimension, boolean modal, boolean hint, boolean adaptable) {
        super(owner, title, modal);
        this.dimension = dimension;
        this.hint = hint;
        this.adaptable = adaptable;
        this.initComponents();
    }

    public JBasicDialog(Dialog owner, String title, Dimension dimension, boolean modal, boolean hint, boolean adaptable) {
        super(owner, title, modal);
        this.dimension = dimension;
        this.hint = hint;
        this.adaptable = adaptable;
        this.initComponents();
    }

    private void initComponents() {
        this.resizer = new DialogResizer();
        if (this.dimension != null) {
            this.setDimension(this.dimension);
        } else {
            this.addHierarchyListener(new DisplayAbilityListener(){

                @Override
                public void displayAbilityChanged(HierarchyEvent e) {
                    JBasicDialog.this.setDimension(JBasicDialog.this.getContentPane().getPreferredSize());
                    JBasicDialog.this.removeHierarchyListener(this);
                }
            });
        }
        this.setAdaptable(this.adaptable);
        this.setResizable(true);
    }

    public boolean isHint() {
        return this.hint;
    }

    public void setHint(boolean hint) {
        this.hint = hint;
    }

    public boolean isAdaptable() {
        return this.adaptable;
    }

    public void setAdaptable(boolean adaptable) {
        this.adaptable = adaptable;
        if (adaptable) {
            if (this.minimumDimension == null) {
                this.setMinimumDimension(this.dimension);
            }
            this.addComponentListener(this.resizer);
        } else {
            this.removeComponentListener(this.resizer);
        }
    }

    public int getDecoratedMargin() {
        return JDialog.isDefaultLookAndFeelDecorated() ? 27 : 0;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
        WindowManager.setCenter(this, dimension);
        this.resizer.setDimension(dimension);
    }

    public Dimension getMinimumDimension() {
        return this.minimumDimension;
    }

    public void setMinimumDimension(Dimension minimumDimension) {
        this.minimumDimension = minimumDimension;
        this.resizer.setMinimumDimension(minimumDimension);
    }

    public Dimension getMaximumDimension() {
        return this.maximumDimension;
    }

    public void setMaximumDimension(Dimension maximumDimension) {
        this.maximumDimension = maximumDimension;
        this.resizer.setMaximumDimension(maximumDimension);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        int selectedValue;
        if (this.hint && e.getID() == 201 && (selectedValue = JBasicOptionPane.showConfirmDialog(this.getParent(), SwingLocale.getString("confirm_to_exit"), SwingLocale.getString("confirm"), 0)) != 0) {
            return;
        }
        super.processWindowEvent(e);
    }
}

