/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import twaver.BatchAdapter;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxSelectionEvent;
import twaver.DataBoxSelectionListener;
import twaver.DataBoxSequenceAdapter;
import twaver.DataBoxSequenceListener;
import twaver.EditableFilter;
import twaver.Element;
import twaver.ElementAttribute;
import twaver.MouseActionEvent;
import twaver.PopupMenuGenerator;
import twaver.SendToBottomFilter;
import twaver.SendToTopFilter;
import twaver.TDataBox;
import twaver.TPropertyDescriptor;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.VisibleFilter;
import twaver.base.A.E.H;
import twaver.base.A.F.B.F;
import twaver.base.A.I.A;
import twaver.base.A.J.A.B;
import twaver.base.A.J.A.G;
import twaver.table.Category;
import twaver.table.TTable;
import twaver.table.TTableAdapter;
import twaver.table.TTableColumn;
import twaver.table.TTableModelEvent;
import twaver.table.TTableRowFilter;

public class TElementTable
extends TTable
implements A {
    protected TDataBox box;
    private Class \u0217 = null;
    private Map \u0213 = new TreeMap(Category.INDEX_COMPARATOR);
    private Map \u020a = new HashMap();
    private JPanel \u0211 = new JPanel(new FlowLayout(0));
    protected Map elementIDMapper = new HashMap();
    protected Map rowOIDMapper = new HashMap();
    private Map \u0207 = new HashMap();
    private EditableFilter \u020c = null;
    private List \u0208 = new ArrayList();
    private List \u0214 = new ArrayList();
    private boolean \u0210 = false;
    private boolean \u020b = false;
    private boolean \u0250 = TUIManager.getBoolean("table.converse.increase.order");
    private boolean \u020f = TUIManager.getBoolean("table.ensure.visible.on.selected");
    private boolean \u0254 = true;
    private boolean \u020d = true;
    private SendToTopFilter \u0253 = null;
    private SendToBottomFilter \u0252 = null;
    private PopupMenuGenerator \u0215 = null;
    private Element \u0205 = null;
    private DataBoxSequenceListener \u0206 = new DataBoxSequenceAdapter(){

        public void hiberarchyChanged(Element element) {
            TElementTable.this.reloadData();
        }
    };
    private BatchListener \u0204 = new BatchAdapter(){

        public void batchEnded(BatchEvent e2) {
            TElementTable.this.getTableModel().publishData();
        }
    };
    private DataBoxListener \u0209 = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            TElementTable.this.addElement(e2.getElement());
        }

        public void elementRemoved(DataBoxEvent e2) {
            TElementTable.this.B(e2.getElement());
        }

        public void elementsCleared(DataBoxEvent e2) {
            TElementTable.this.S();
        }
    };
    protected TTableRowFilter filter = new TTableRowFilter(){

        public boolean isVisible(TTable table, Vector rowData) {
            int count = TElementTable.this.\u0208.size();
            if (count > 0) {
                Element element = TElementTable.this.getElementByRowData(rowData);
                return TElementTable.this.isVisible(element);
            }
            return true;
        }
    };
    private TTableAdapter \u0216 = new TTableAdapter(){

        public void rowClicked(int clickCount, Vector rowData, int columnIndex) {
            Element element = TElementTable.this.getElementByRowData(rowData);
            if (element != null && TElementTable.this.getCursor() != G.D && TElementTable.this.getCursor() != B.E) {
                MouseActionEvent event = new MouseActionEvent(element, columnIndex, null, TElementTable.this.getCurrentMouseEvent(), TElementTable.this, -1);
                if (clickCount == 1) {
                    TElementTable.this.B(event);
                } else if (clickCount == 2) {
                    TElementTable.this.A(event);
                }
            }
        }

        public void rowSelectionChanged(List selectedRows, boolean isSelectionAdjusting) {
            TElementTable.this.syncSelectionFromViewToDataBox(selectedRows);
        }

        public void tableDataChanged(TTableModelEvent e2) {
            if (e2.getType() == 3) {
                if (TElementTable.this.\u0210) {
                    return;
                }
                TElementTable.this.A(e2);
            } else if (e2.getType() != 0) {
                if (e2.getType() == 1) {
                    if (TElementTable.this.\u0210) {
                        return;
                    }
                    Vector rowData = e2.getRowData();
                    _A data = (_A)TElementTable.this.rowOIDMapper.get(rowData.get(0));
                    if (data != null) {
                        TElementTable.this.rowOIDMapper.remove(rowData.get(0));
                        Object elementID = data.A.getID();
                        TElementTable.this.elementIDMapper.remove(elementID);
                        TElementTable.this.box.removeElementByID(elementID);
                    }
                } else if (e2.getType() == 2) {
                    if (TElementTable.this.\u0210) {
                        return;
                    }
                    Iterator it = TElementTable.this.iterator();
                    while (it.hasNext()) {
                        Element element = (Element)it.next();
                        TElementTable.this.box.removeElement(element);
                    }
                } else if (e2.getType() == 4) {
                    TElementTable.this.reloadData();
                } else if (e2.getType() == 5) {
                    TElementTable.this.reloadData();
                }
            }
        }
    };
    private PropertyChangeListener \u0251 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TElementTable.this.A(evt);
        }
    };
    private DataBoxSelectionListener \u0212 = new DataBoxSelectionListener(){

        public void selectionChanged(DataBoxSelectionEvent e2) {
            TElementTable.this.syncSelectionFromDataBoxToView();
        }
    };
    private List \u020e = new ArrayList();

    public void setEditingRow(int aRow) {
        super.setEditingRow(aRow);
        if (aRow < 0) {
            this.\u0205 = null;
            return;
        }
        this.\u0205 = this.getElementByRowIndex(aRow);
    }

    public Element getCurrentEditingElement() {
        return this.\u0205;
    }

    public boolean isPublishable() {
        if (this.box != null && this.box.isBatching()) {
            return false;
        }
        return super.isPublishable();
    }

    public boolean isVisible(Element element) {
        int count = this.\u0208.size();
        for (int i2 = 0; i2 < count; ++i2) {
            VisibleFilter visibleFilter = (VisibleFilter)this.\u0208.get(i2);
            if (visibleFilter.isVisible(element)) continue;
            return false;
        }
        return true;
    }

    private void A(PropertyChangeEvent evt) {
        Element element = (Element)evt.getSource();
        if (!this.interested(element)) {
            return;
        }
        String propertyName = evt.getPropertyName();
        if (this.isIteratorByHiberarchy() && propertyName.equals("parent")) {
            this.reloadData();
            return;
        }
        if (propertyName.equals("element.update.ui") || propertyName.equals("businessObject")) {
            this.reloadElement(element);
            return;
        }
        _A data = (_A)this.elementIDMapper.get(element.getID());
        if (data != null) {
            TTableColumn column = this.tableModel.getColumnByName(propertyName);
            if (column == null) {
                return;
            }
            Object propertyValue = this.readElementPropertyValue(data.A, column);
            int columnIndex = this.tableModel.getRawColumnIndexByName(propertyName);
            if (columnIndex >= 0 && columnIndex < data.B.size() && this.tableModel.A(data.B, columnIndex, propertyValue)) {
                this.tableModel.publishData();
            }
        }
    }

    public TElementTable() {
        this(new TDataBox());
    }

    public TElementTable(TDataBox box) {
        this.addRowFilter(this.filter);
        this.setDataBox(box);
        this.addTableListener(this.\u0216);
    }

    public TDataBox getDataBox() {
        return this.box;
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            throw new IllegalArgumentException("Cannot set a null TDataBox");
        }
        if (this.box == box) {
            return;
        }
        TDataBox oldValue = this.box;
        if (this.box != null) {
            this.box.removeBatchListener(this.\u0204);
            this.box.removeDataBoxListener(this.\u0209);
            this.box.removeElementPropertyChangeListener(this.\u0251);
            this.box.getSelectionModel().removeDataBoxSelectionListener(this.\u0212);
            if (this.\u020b) {
                this.box.removeDataBoxSequenceListener(this.\u0206);
            }
        }
        this.box = box;
        this.box.addBatchListener(this.\u0204);
        this.box.addDataBoxListener(this.\u0209);
        this.box.addElementPropertyChangeListener(this.\u0251);
        this.box.getSelectionModel().addDataBoxSelectionListener(this.\u0212);
        if (this.\u020b) {
            this.box.addDataBoxSequenceListener(this.\u0206);
        }
        this.firePropertyChange("databox", oldValue, this.box);
        this.setElementClass(this.\u0217);
        this.syncSelectionFromDataBoxToView();
    }

    public List getVisibleFilters() {
        return new ArrayList(this.\u0208);
    }

    public void addVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null && !this.\u0208.contains(visibleFilter)) {
            this.\u0208.add(visibleFilter);
            this.tableModel.publishData();
        }
    }

    public void removeVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null) {
            this.\u0208.remove(visibleFilter);
            this.tableModel.publishData();
        }
    }

    public void reloadElement(Element element) {
        _A data = (_A)this.elementIDMapper.get(element.getID());
        if (data == null) {
            return;
        }
        List columns = this.tableModel.getRawColumn();
        for (int i2 = 2; i2 < columns.size(); ++i2) {
            TTableColumn column = (TTableColumn)columns.get(i2);
            Object propertyValue = this.readElementPropertyValue(data.A, column);
            if (i2 >= data.B.size()) continue;
            data.B.set(i2, propertyValue);
        }
        this.tableModel.publishData();
    }

    protected void syncSelectionFromDataBoxToView() {
        if (this.\u0210 || !this.isAutoSyncSelectionFromDataBoxToView()) {
            return;
        }
        this.\u0210 = true;
        if (this.isEnsureVisibleOnSelected()) {
            this.ensureVisible(this.box.getLastSelectedElement());
        }
        ArrayList<Vector> selectedRowDatas = new ArrayList<Vector>();
        Iterator it = this.box.selection();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            Vector row = this.getRowDataByElementID(element.getID());
            if (row == null) continue;
            selectedRowDatas.add(row);
        }
        this.tableModel.setSelectedRows(selectedRowDatas);
        this.\u0210 = false;
    }

    public void ensureVisible(Element element) {
        Vector rowData;
        if (element != null && (rowData = this.getRowDataByElementID(element.getID())) != null) {
            this.ensureVisible(rowData);
        }
    }

    public void ensureVisibleAtCurrentPage(Element element) {
        Vector rowData;
        if (element != null && (rowData = this.getRowDataByElementID(element.getID())) != null) {
            this.ensureVisibleAtCurrentPage(rowData);
        }
    }

    protected void syncSelectionFromViewToDataBox(List selectedRows) {
        Element element;
        if (this.\u0210 || !this.isAutoSyncSelectionFromViewToDataBox()) {
            return;
        }
        this.\u0210 = true;
        LinkedHashMap<Object, Element> map = new LinkedHashMap<Object, Element>();
        if (selectedRows != null) {
            for (int i2 = 0; i2 < selectedRows.size(); ++i2) {
                Vector rowData = (Vector)selectedRows.get(i2);
                element = this.getElementByOID(rowData.get(0));
                if (element == null) continue;
                map.put(element.getID(), element);
            }
        }
        LinkedList<Element> list = new LinkedList<Element>();
        Iterator it = this.box.selection();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (!map.containsKey(element.getID())) continue;
            list.add(element);
            map.remove(element.getID());
        }
        list.addAll(map.values());
        if (list.size() != this.box.getSelectionModel().size() || !TElementTable.A(list.iterator(), this.box.getSelectionModel().selection())) {
            this.box.getSelectionModel().setSelection(list);
        }
        this.\u0210 = false;
    }

    private static boolean A(Iterator it1, Iterator it2) {
        while (it1.hasNext()) {
            if (it1.next() == it2.next()) continue;
            return false;
        }
        return true;
    }

    public List getElementDoubleClickedActionListeners() {
        return this.\u0214;
    }

    public List getElementClickedActionListeners() {
        return this.\u020e;
    }

    public void addElementDoubleClickedActionListener(ActionListener l2) {
        if (!this.\u0214.contains(l2)) {
            this.\u0214.add(l2);
        }
    }

    public void removeElementDoubleClickedActionListener(ActionListener l2) {
        this.\u0214.remove(l2);
    }

    private void A(ActionEvent event) {
        for (int i2 = 0; i2 < this.\u0214.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u0214.get(i2);
            l2.actionPerformed(event);
        }
    }

    public void addElementClickedActionListener(ActionListener l2) {
        if (!this.\u020e.contains(l2)) {
            this.\u020e.add(l2);
        }
    }

    public void removeElementClickedActionListener(ActionListener l2) {
        this.\u020e.remove(l2);
    }

    private void B(ActionEvent event) {
        for (int i2 = 0; i2 < this.\u020e.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u020e.get(i2);
            l2.actionPerformed(event);
        }
    }

    public boolean isEditable() {
        return this.tableModel.isEditable();
    }

    public void setEditable(boolean isEditable) {
        this.tableModel.setEditable(isEditable);
    }

    protected boolean isEditable(int rowIndex) {
        if (this.\u020c == null) {
            return true;
        }
        Element element = this.getElementByRowIndex(rowIndex);
        return element == null ? true : this.\u020c.isEditable(element);
    }

    public void setEnsureVisibleOnSelected(boolean isEnsureVisibleOnSelected) {
        this.\u020f = isEnsureVisibleOnSelected;
    }

    public boolean isEnsureVisibleOnSelected() {
        return this.\u020f;
    }

    public Class getElementClass() {
        return this.\u0217;
    }

    public void setElementClass(Class elementClass) {
        Class oldElementClass = this.\u0217;
        this.\u0217 = elementClass;
        if (this.tableModel == null) {
            return;
        }
        this.\u0210 = true;
        this.R();
        this.T();
        this.Q();
        this.\u0210 = false;
        this.firePropertyChange("elementClass", this.\u0217, oldElementClass);
    }

    public void reloadData() {
        if (this.\u0210) {
            return;
        }
        this.\u0210 = true;
        this.T();
        this.Q();
        this.\u0210 = false;
        this.syncSelectionFromDataBoxToView();
    }

    public JPanel getCategoryVisiblePanel() {
        return this.\u0211;
    }

    private boolean A(Category category) {
        Boolean visible = (Boolean)this.\u020a.get(category);
        if (visible != null) {
            return visible;
        }
        this.\u020a.put(category, Boolean.TRUE);
        return true;
    }

    private List B(Category category) {
        if (!this.\u0213.containsKey(category)) {
            this.\u0213.put(category, new ArrayList());
        }
        List columnList = (List)this.\u0213.get(category);
        return columnList;
    }

    private void T() {
        this.\u0211.removeAll();
        Iterator it = this.\u0213.keySet().iterator();
        while (it.hasNext()) {
            final Category category = (Category)it.next();
            final JCheckBox checkBox = new JCheckBox(category.getDisplayName());
            checkBox.setSelected(this.A(category));
            checkBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    List columnList = TElementTable.this.B(category);
                    boolean visible = checkBox.isSelected();
                    TElementTable.this.\u020a.put(category, visible);
                    for (int i2 = 0; i2 < columnList.size(); ++i2) {
                        TTableColumn column = (TTableColumn)columnList.get(i2);
                        column.setVisible(visible);
                    }
                }
            });
            this.\u0211.add(checkBox);
        }
        this.\u0211.revalidate();
        this.\u0211.repaint();
    }

    protected void addElement(Element element) {
        if (!this.interested(element)) {
            return;
        }
        if (!this.elementIDMapper.containsKey(element.getID())) {
            if (this.isIteratorByHiberarchy()) {
                this.reloadData();
            } else {
                _A data = new _A(element);
                this.elementIDMapper.put(element.getID(), data);
                this.rowOIDMapper.put(TWaverUtil.valueOf(this.tableModel.getCurrentOID() + 1), data);
                if (this.isConverseIncreaseOrder()) {
                    this.tableModel.insertRow(0, data.B);
                } else {
                    this.tableModel.addRow(data.B);
                }
            }
        }
    }

    private void B(Element element) {
        if (!this.interested(element)) {
            return;
        }
        _A data = (_A)this.elementIDMapper.remove(element.getID());
        if (data != null) {
            this.elementIDMapper.remove(element.getID());
            this.rowOIDMapper.remove(data.B.get(0));
            this.tableModel.removeRow(data.B);
        }
    }

    private void S() {
        if (this.elementIDMapper.size() > 0 || this.rowOIDMapper.size() > 0) {
            this.elementIDMapper.clear();
            this.rowOIDMapper.clear();
            this.tableModel.clearRawData();
        }
    }

    public int getPageIndex(Element element) {
        Vector data = this.getRowDataByElement(element);
        return this.tableModel.getPageIndex(data);
    }

    public int getRowIndex(Element element) {
        Vector data = this.getRowDataByElement(element);
        return this.tableModel.getRowIndex(data);
    }

    public int getRowIndexAtPage(Element element) {
        Vector data = this.getRowDataByElement(element);
        return this.tableModel.getRowIndexAtPage(data);
    }

    public Vector getRowDataByElement(Element element) {
        return this.getRowDataByElementID(element.getID());
    }

    public Vector getRowDataByElementID(Object elemetID) {
        _A data = (_A)this.elementIDMapper.get(elemetID);
        if (data != null) {
            return data.B;
        }
        return null;
    }

    public Collection getRowDatasByElements(Collection elements) {
        ArrayList<Vector> list = new ArrayList<Vector>();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            list.add(this.getRowDataByElement(element));
        }
        return list;
    }

    public Element getElementByOID(Object oid) {
        _A data = (_A)this.rowOIDMapper.get(oid);
        if (data != null) {
            return data.A;
        }
        return null;
    }

    public Element getElementByRowData(Vector rowData) {
        if (rowData == null || rowData.size() == 0) {
            return null;
        }
        return this.getElementByOID(rowData.get(0));
    }

    public List getAllCheckedElements() {
        Vector data = this.tableModel.getAllCheckedRowData();
        ArrayList<Element> list = new ArrayList<Element>(data.size());
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.get(i2);
            Element element = this.getElementByRowData(rowData);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public List getCurrentPageElements() {
        Vector data = this.tableModel.getCurrentPageData();
        ArrayList<Element> list = new ArrayList<Element>(data.size());
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.get(i2);
            Element element = this.getElementByRowData(rowData);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public List getPublishedElements() {
        Vector data = this.tableModel.getPublishedData();
        ArrayList<Element> list = new ArrayList<Element>(data.size());
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.get(i2);
            Element element = this.getElementByRowData(rowData);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    private void A(TTableModelEvent event) {
        int columnIndex = event.getColumnIndex();
        if (columnIndex == 0 || columnIndex == 1) {
            return;
        }
        Vector rowData = event.getRowData();
        _A data = (_A)this.rowOIDMapper.get(rowData.get(0));
        if (data != null) {
            Object newValue = event.getNewValue();
            TTableColumn column = (TTableColumn)this.tableModel.getRawColumn().get(columnIndex);
            this.writeElementPropertyValue(data.A, column, newValue);
            Object value = this.readElementPropertyValue(data.A, column);
            if (value != null && newValue != null && !value.equals(newValue) || value == null && newValue != null || value != null && newValue == null) {
                rowData.set(columnIndex, value);
                this.tableModel.publishData();
            }
        }
    }

    public boolean interested(Element element) {
        if (this.\u0217 == null) {
            return false;
        }
        if (element == null) {
            return false;
        }
        return this.\u0217.isAssignableFrom(element.getClass());
    }

    private void Q() {
        this.elementIDMapper.clear();
        this.rowOIDMapper.clear();
        this.tableModel.clearRawData();
        Vector<Vector> tableData = new Vector<Vector>(Math.max(this.box.size(), 30));
        int currentOID = this.tableModel.getCurrentOID();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            _A data = new _A(element);
            this.elementIDMapper.put(element.getID(), data);
            this.rowOIDMapper.put(TWaverUtil.valueOf(++currentOID), data);
            tableData.add(data.B);
        }
        this.tableModel.setTableRawData(tableData);
    }

    protected Iterator iterator() {
        LinkedList<Element> result;
        block5: {
            result = new LinkedList<Element>();
            if (this.\u0217 == null) break block5;
            if (this.isIteratorByHiberarchy()) {
                Enumeration e2 = this.box.breadthFirstEnumeration();
                while (e2.hasMoreElements()) {
                    Element element = (Element)e2.nextElement();
                    if (!this.\u0217.isAssignableFrom(element.getClass())) continue;
                    result.add(element);
                }
            } else {
                Iterator it = this.box.iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    if (!this.\u0217.isAssignableFrom(element.getClass())) continue;
                    if (this.isConverseIncreaseOrder()) {
                        result.add(element);
                        continue;
                    }
                    result.add(0, element);
                }
            }
        }
        return result.iterator();
    }

    public List getAllBeanInfo(Class elementClass) {
        if (elementClass == null) {
            return TWaverConst.EMPTY_LIST;
        }
        Object value = this.\u0207.get(elementClass);
        if (value instanceof String) {
            String url = value.toString();
            BeanInfo beanInfo = F.A().A(elementClass, url, false);
            ArrayList<BeanInfo> list = new ArrayList<BeanInfo>();
            if (beanInfo == null) {
                throw new NullPointerException("can not find xml '" + url + "'");
            }
            list.add(beanInfo);
            this.\u0207.put(elementClass, list);
            return list;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return F.A().E(elementClass);
    }

    private void R() {
        this.tableModel.clearRawData();
        this.tableModel.clearAllColumns();
        this.\u0213.clear();
        if (this.\u0217 == null) {
            return;
        }
        List beanInfos = this.getAllBeanInfo(this.\u0217);
        Iterator properties = H.A(beanInfos).iterator();
        while (properties.hasNext()) {
            TPropertyDescriptor property = (TPropertyDescriptor)properties.next();
            ElementAttribute attribute = property.getElementAttribute();
            String categoryName = attribute.getCategoryName();
            Category category = Category.getCategory(categoryName);
            if (category == null) {
                throw new NullPointerException("Category with name '" + categoryName + "' isn't registered.");
            }
            TTableColumn column = new TTableColumn(attribute.getKey(), property.getDisplayName(), attribute.getSortComparator(), attribute.getRenderer(), attribute.isEditable(), attribute.getEditor(), this.A(category) && attribute.isVisible(), attribute.getWidth(), attribute.getJavaClass(), property.getReadMethod(), property.getWriteMethod());
            column.setSortable(attribute.isSortable());
            column.setPropertyDescriptor(property);
            column.setMaxPackWidth(attribute.getMaxPackWidth());
            column.setMinPackWidth(attribute.getMinPackWidth());
            column.setMaxPackHeight(attribute.getMaxPackHeight());
            column.setMinPackHeight(attribute.getMinPackHeight());
            column.setExtraWidthAssignable(attribute.isExtraWidthAssignable());
            column.setRowPackParticipable(attribute.isRowPackParticipable());
            column.setIcon(attribute.getIcon());
            if (attribute.getMinWidth() >= 0) {
                column.setMinWidth(attribute.getMinWidth());
            }
            if (attribute.getMaxWidth() >= 0) {
                column.setMaxWidth(attribute.getMaxWidth());
            }
            List columnList = this.B(category);
            columnList.add(column);
        }
        ArrayList allColumns = new ArrayList();
        Iterator it = this.\u0213.keySet().iterator();
        while (it.hasNext()) {
            Category category = (Category)it.next();
            List columnList = this.B(category);
            allColumns.addAll(columnList);
        }
        this.tableModel.addColumns(allColumns);
    }

    protected Object readElementPropertyValue(Element element, TTableColumn column) {
        return element.getPropertyValue(column.getPropertyDescriptor());
    }

    protected void writeElementPropertyValue(Element element, TTableColumn column, Object value) {
        element.setPropertyValue(column.getPropertyDescriptor(), value);
    }

    public void registerElementClassXML(Class elementClass, String url) {
        this.\u0207.put(elementClass, url);
        if (elementClass == this.\u0217) {
            this.setElementClass(this.\u0217);
        }
    }

    public void registerElementClassXML(Class elementClass, InputStream inputStream) {
        List attributes = TWaverUtil.createElementAttributes(elementClass, inputStream);
        if (attributes != null) {
            this.registerElementClassAttributes(elementClass, attributes);
        }
    }

    public void registerElementClassAttributes(Class elementClass, List attributes) {
        BeanInfo beanInfo = H.A(elementClass, attributes);
        ArrayList<BeanInfo> list = new ArrayList<BeanInfo>();
        list.add(beanInfo);
        this.\u0207.put(elementClass, list);
        if (elementClass == this.\u0217) {
            this.setElementClass(this.\u0217);
        }
    }

    public List getElementClassAttributes(Class elementClass) {
        Object list = this.\u0207.get(elementClass);
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    public Element getElementByRowIndex(int row) {
        Vector rowData = this.getRowDataByRowIndex(row);
        return this.getElementByRowData(rowData);
    }

    public boolean isConverseIncreaseOrder() {
        return this.\u0250;
    }

    public void setConverseIncreaseOrder(boolean converseIncreaseOrder) {
        this.\u0250 = converseIncreaseOrder;
    }

    public void updateTViewUI() {
        this.setElementClass(this.getElementClass());
    }

    public void updateUI() {
        super.updateUI();
        this.setElementClass(this.getElementClass());
    }

    public boolean isAutoSyncSelectionFromDataBoxToView() {
        return this.\u0254;
    }

    public void setAutoSyncSelectionFromDataBoxToView(boolean autoSyncSelectionFromDataBoxToTable) {
        this.\u0254 = autoSyncSelectionFromDataBoxToTable;
    }

    public boolean isAutoSyncSelectionFromViewToDataBox() {
        return this.\u020d;
    }

    public void setAutoSyncSelectionFromViewToDataBox(boolean autoSyncSelectionFromTableToDataBox) {
        this.\u020d = autoSyncSelectionFromTableToDataBox;
    }

    public EditableFilter getEditableFilter() {
        return this.\u020c;
    }

    public void setEditableFilter(EditableFilter editableFilter) {
        this.\u020c = editableFilter;
        this.repaint();
    }

    public PopupMenuGenerator getPopupMenuGenerator() {
        return this.\u0215;
    }

    public void setPopupMenuGenerator(PopupMenuGenerator popupMenuGenerator) {
        this.\u0215 = popupMenuGenerator;
    }

    public boolean isIteratorByHiberarchy() {
        return this.\u020b;
    }

    public void setIteratorByHiberarchy(boolean iteratorByHiberarchy) {
        if (this.\u020b != iteratorByHiberarchy) {
            this.\u020b = iteratorByHiberarchy;
            this.reloadData();
            if (this.\u020b) {
                this.box.addDataBoxSequenceListener(this.\u0206);
            } else {
                this.box.removeDataBoxSequenceListener(this.\u0206);
            }
        }
    }

    public SendToTopFilter getSendToTopFilter() {
        return this.\u0253;
    }

    public void setSendToTopFilter(SendToTopFilter sendToTopFilter) {
        this.\u0253 = sendToTopFilter;
        this.tableModel.publishData();
    }

    public SendToBottomFilter getSendToBottomFilter() {
        return this.\u0252;
    }

    public void setSendToBottomFilter(SendToBottomFilter sendToBottomFilter) {
        this.\u0252 = sendToBottomFilter;
        this.tableModel.publishData();
    }

    public List filterTopRows(List publishedData) {
        if (this.\u0253 == null) {
            return null;
        }
        ArrayList<Vector> list = new ArrayList<Vector>();
        Iterator it = publishedData.iterator();
        while (it.hasNext()) {
            Vector data = (Vector)it.next();
            Element element = this.getElementByRowData(data);
            if (element == null || !this.\u0253.isSendToToppable(element)) continue;
            list.add(data);
            it.remove();
        }
        return list;
    }

    public List filterBottomRows(List publishedData) {
        if (this.\u0252 == null) {
            return null;
        }
        ArrayList<Vector> list = new ArrayList<Vector>();
        Iterator it = publishedData.iterator();
        while (it.hasNext()) {
            Vector data = (Vector)it.next();
            Element element = this.getElementByRowData(data);
            if (element == null || !this.\u0252.isSendToBottomable(element)) continue;
            list.add(data);
            it.remove();
        }
        return list;
    }

    class _A {
        private Element A = null;
        Vector B = new Vector();

        _A(Element element) {
            this.A = element;
            this.A();
        }

        private void A() {
            List list = TElementTable.this.tableModel.getRawColumn();
            for (int i2 = 2; i2 < list.size(); ++i2) {
                TTableColumn column = (TTableColumn)list.get(i2);
                Object value = TElementTable.this.readElementPropertyValue(this.A, column);
                this.B.add(value);
            }
        }
    }
}

