/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import java.util.Map;
import y.base.Node;
import y.io.GMLIOHandler;
import y.io.gml.HierarchicGraphParser;
import y.io.gml.ItemParser;
import y.io.gml.NodeParser;
import y.io.gml.ParserFactory;
import y.view.Graph2D;
import y.view.Graph2DNodeRealizer;
import y.view.NodeRealizer;
import y.view.hierarchy.HierarchyManager;

public class HierarchyNodeParser
extends NodeParser {
    protected ParserFactory parserFactory;
    protected Node folderNode;
    protected HierarchicGraphParser parent;

    public HierarchyNodeParser(Graph2D graph2D, Map map, HierarchicGraphParser hierarchicGraphParser, ParserFactory parserFactory) {
        super(graph2D, map);
        this.parserFactory = parserFactory;
        this.parent = hierarchicGraphParser;
    }

    public void begin() {
        super.begin();
        this.folderNode = null;
    }

    public void beginScope(String string) {
        HierarchyManager hierarchyManager;
        if (this.level == 0 && "graph".equals(string) && (hierarchyManager = HierarchyManager.getInstance(this.graph)) != null) {
            this.folderNode = this.graph.createNode();
            hierarchyManager.convertToFolderNode(this.folderNode);
            Graph2D graph2D = (Graph2D)hierarchyManager.getInnerGraph(this.folderNode);
            ItemParser itemParser = (ItemParser)this.parserFactory.createGraphParser(graph2D, this.parent);
            this.parent.folderNodeId2Parser.put(this.attributes.get("id"), itemParser);
            this.addChild(string, itemParser);
        }
        super.beginScope(string);
    }

    public void end() {
        Object object;
        HierarchyManager hierarchyManager;
        String string = (String)this.attributes.get("graphUrl");
        if (string != null && this.folderNode == null && (hierarchyManager = HierarchyManager.getInstance(this.graph)) != null) {
            this.folderNode = this.graph.createNode();
            hierarchyManager.convertToFolderNode(this.folderNode);
            object = (Graph2D)hierarchyManager.getInnerGraph(this.folderNode);
            try {
                GMLIOHandler gMLIOHandler = new GMLIOHandler();
                gMLIOHandler.read((Graph2D)object, string);
            }
            catch (IOException iOException) {
                System.err.println("Could not load inner graph " + iOException);
                this.folderNode = null;
            }
        }
        if (this.folderNode != null) {
            hierarchyManager = HierarchyManager.getInstance(this.graph);
            this.handleLabels();
            object = new Graph2DNodeRealizer(this.nr);
            ((Graph2DNodeRealizer)object).setInnerGraph((Graph2D)hierarchyManager.getInnerGraph(this.folderNode));
            this.graph.setRealizer(this.folderNode, (NodeRealizer)object);
            this.id2Node.put(this.attributes.get("id"), this.folderNode);
        } else {
            super.end();
        }
    }

    public Object getItem() {
        if (this.folderNode != null) {
            return this.folderNode;
        }
        return super.getItem();
    }
}

