/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework;

import com.nepxion.swing.framework.JFrameWorkHierarchy;
import com.nepxion.swing.framework.JFrameWorkStatusBar;
import java.awt.Component;
import java.awt.event.ActionEvent;

public abstract class JFrameWorkThread
extends Thread {
    private Component component;
    private JFrameWorkHierarchy frameWorkHierarchy;

    public JFrameWorkThread(JFrameWorkHierarchy frameWorkHierarchy) {
        this.frameWorkHierarchy = frameWorkHierarchy;
    }

    public JFrameWorkThread(JFrameWorkHierarchy frameWorkHierarchy, Component component) {
        this.frameWorkHierarchy = frameWorkHierarchy;
        this.component = component;
    }

    public JFrameWorkThread(JFrameWorkHierarchy frameWorkHierarchy, ActionEvent actionEvent) {
        Object object;
        this.frameWorkHierarchy = frameWorkHierarchy;
        if (actionEvent != null && (object = actionEvent.getSource()) != null && object instanceof Component) {
            this.component = (Component)object;
        }
    }

    @Override
    public void run() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.setComponentEnabled(false);
        this.setThreadStatus(true);
        this.execute();
        this.setThreadStatus(false);
        this.setComponentEnabled(true);
    }

    private void setComponentEnabled(boolean enabled) {
        if (this.component != null) {
            this.component.setEnabled(enabled);
        }
    }

    private void setThreadStatus(boolean started) {
        if (this.frameWorkHierarchy == null) {
            return;
        }
        JFrameWorkStatusBar frameWorkStatusBar = this.frameWorkHierarchy.getStatusBar();
        if (frameWorkStatusBar == null) {
            return;
        }
        if (frameWorkStatusBar.isVisible()) {
            if (started) {
                frameWorkStatusBar.start();
            } else {
                frameWorkStatusBar.stop();
            }
        }
    }

    public abstract void execute();
}

