/*
 * Decompiled with CFR 0.152.
 */
package twaver.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import twaver.Element;
import twaver.Generator;
import twaver.list.TList;
import twaver.swing.TTristateCheckBox;
import twaver.tree.TTreeCellIcon;

public class TListCellRenderer
extends DefaultListCellRenderer {
    private TList C;
    private TTristateCheckBox A;
    private JPanel D;
    private boolean B = false;

    public TListCellRenderer(TList list) {
        this.C = list;
        this.A();
        this.C.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectionMode".equals(evt.getPropertyName())) {
                    TListCellRenderer.this.A();
                }
            }
        });
    }

    private void A() {
        if (this.C.getTListSelectionMode() == 1) {
            if (this.D == null) {
                this.D = new JPanel(new BorderLayout());
                this.A = new TTristateCheckBox();
                this.A.setOpaque(false);
                this.D.setOpaque(true);
                this.D.add((Component)this.A, "West");
                this.D.add((Component)this, "Center");
            }
        } else if (this.D != null) {
            this.D.removeAll();
            this.A = null;
            this.D = null;
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Element element = (Element)value;
        cellHasFocus = false;
        if (this.C.getTListSelectionMode() == 1 && !this.C.isPaintSelectedStateWhenChecked()) {
            isSelected = false;
        } else if (this.C.isAutoSyncSelectionFromDataBoxToView() && this.C.isAutoSyncSelectionFromViewToDataBox()) {
            isSelected = element.isSelected();
        }
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (this.C.isIconVisible()) {
            this.setIcon(this.getIcon(element));
        } else {
            this.setIcon(null);
        }
        this.setText(this.getText(element));
        if (this.C.getTListSelectionMode() == 1) {
            int style = this.C.getUncheckableStyle(element);
            boolean checkable = this.C.isCheckable(element);
            this.A.setVisible(checkable || style != 1);
            this.A.setBlank(!checkable && style == 2);
            this.A.setSelected(element.isSelected());
            this.D.setBackground(this.getBackground());
            if (this.C.isEnabled()) {
                this.A.setEnabled(checkable);
                this.setEnabled(checkable);
            } else {
                this.A.setEnabled(false);
                this.setEnabled(false);
            }
            this.D.setToolTipText(this.getToolTipText(element));
            return this.D;
        }
        this.setEnabled(list.isEnabled());
        this.setToolTipText(this.getToolTipText(element));
        return this;
    }

    protected Icon getIcon(Element element) {
        Generator generator = this.C.getElementIconGenerator();
        if (generator == null) {
            return new TTreeCellIcon(element);
        }
        return (Icon)generator.generate(element);
    }

    protected String getText(Element element) {
        Generator generator = this.C.getElementLabelGenerator();
        if (generator == null) {
            return element.getName();
        }
        return (String)generator.generate(element);
    }

    protected String getToolTipText(Element element) {
        Generator generator = this.C.getElementToolTipTextGenerator();
        if (generator == null) {
            String text = element.getToolTipText();
            if (text == null) {
                return element.getName();
            }
            return text;
        }
        return (String)generator.generate(element);
    }

    public void updateUI() {
        super.updateUI();
        if (this.D != null) {
            this.A.updateUI();
            this.D.updateUI();
        }
    }

    public boolean isCenterAlignment() {
        return this.B;
    }

    public void setCenterAlignment(boolean isCenterAlignment) {
        this.B = isCenterAlignment;
        if (this.B) {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
        } else {
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(11);
            this.setVerticalTextPosition(0);
        }
        this.C.updateUI();
    }
}

