/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.thread.dialog;

import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.thread.dialog.AbstractSwingWorker;
import com.nepxion.swing.thread.dialog.AbstractThreadDialog;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public abstract class JThreadDialog
extends AbstractThreadDialog {
    private SwingWorker swingWorker;
    private int delayTime = 200;

    public JThreadDialog(Frame owner, String title) {
        this(owner, title, SwingLocale.getString("transact_and_wait"));
    }

    public JThreadDialog(Dialog owner, String title) {
        this(owner, title, SwingLocale.getString("transact_and_wait"));
    }

    public JThreadDialog(Frame owner, String title, String information) {
        this(owner, title, new JLabel(IconFactory.getSwingIcon("thread/progress.gif")), information);
    }

    public JThreadDialog(Dialog owner, String title, String information) {
        this(owner, title, new JLabel(IconFactory.getSwingIcon("thread/progress.gif")), information);
    }

    public JThreadDialog(Frame owner, String title, JLabel animationLabel, String information) {
        super(owner, title, animationLabel, information);
    }

    public JThreadDialog(Dialog owner, String title, JLabel animationLabel, String information) {
        super(owner, title, animationLabel, information);
    }

    @Override
    public void execute() {
        this.swingWorker = new SwingWorker();
        this.swingWorker.execute();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JThreadDialog.this.setVisible(true);
                JThreadDialog.this.dispose();
            }
        });
    }

    @Override
    protected void fireHidden() {
        this.dispose();
    }

    @Override
    protected void fireCancelled() {
        if (this.swingWorker != null) {
            this.swingWorker.cancel(true);
        }
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    protected abstract void loadForeground(Object var1) throws Exception;

    protected abstract Object loadBackground() throws Exception;

    public class SwingWorker
    extends AbstractSwingWorker {
        public SwingWorker() {
            super(JThreadDialog.this, JThreadDialog.this.delayTime);
        }

        @Override
        protected void loadForeground(final Object data) throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (data instanceof Exception) {
                        return;
                    }
                    try {
                        JThreadDialog.this.loadForeground(data);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SwingWorker.this.fireForegroundException(e);
                        Exception exception = null;
                        exception = e.getCause() != null && e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
                        ExceptionTracer.traceException(HandleManager.getFrame(SwingWorker.this.getComponent()), exception);
                        return;
                    }
                    JThreadDialog.this.fireHidden();
                }
            });
        }

        @Override
        protected Object loadBackground() throws Exception {
            return JThreadDialog.this.loadBackground();
        }
    }
}

