/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tabbedpane;

import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.checkbox.JCheckBoxSelector;
import com.nepxion.swing.tabbedpane.ITabbedPane;
import com.nepxion.swing.tabbedpane.TabbedPaneManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class TabbedPanePopupMenuAdapter {
    private JBasicMenuItem closeMenuItem;
    private JBasicMenuItem closeAllMenuItem;
    private JBasicMenuItem closeOthersMenuItem;
    private JBasicMenuItem closeSelectedMenuItem;
    private JCheckBoxSelector checkBoxSelector;
    private ITabbedPane tabbedPane;

    public TabbedPanePopupMenuAdapter(final ITabbedPane tabbedPane, JPopupMenu popupMenu) {
        this.tabbedPane = tabbedPane;
        this.closeMenuItem = new JBasicMenuItem(IconFactory.getSwingIcon("item_close.png"));
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = tabbedPane.getSelectedIndex();
                tabbedPane.removeTabAt(selectedIndex);
            }
        });
        popupMenu.add(this.closeMenuItem);
        this.closeAllMenuItem = new JBasicMenuItem(SwingLocale.getString("close_all"), (Icon)IconFactory.getSwingIcon("item_close_all.png"), SwingLocale.getString("close_all"));
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame((Component)((Object)tabbedPane)), SwingLocale.getString("confirm_to_close_all_tabs"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                tabbedPane.removeAllTabs();
            }
        });
        popupMenu.add(this.closeAllMenuItem);
        this.closeOthersMenuItem = new JBasicMenuItem(IconFactory.getBlankIcon());
        this.closeOthersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame((Component)((Object)tabbedPane)), SwingLocale.getString("confirm_to_close_others_tabs"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                int selectedIndex = tabbedPane.getSelectedIndex();
                tabbedPane.removeReverseTabsAt(selectedIndex);
            }
        });
        popupMenu.add(this.closeOthersMenuItem);
        this.closeSelectedMenuItem = new JBasicMenuItem(SwingLocale.getString("close_selected"), (Icon)IconFactory.getBlankIcon(), SwingLocale.getString("close_selected"));
        this.closeSelectedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPaneManager.showCloseDialog(tabbedPane, TabbedPanePopupMenuAdapter.this.checkBoxSelector);
            }
        });
        popupMenu.add(this.closeSelectedMenuItem);
    }

    public void adaptClosableItem(int selectedIndex) {
        String text = this.tabbedPane.getTitleAt(selectedIndex);
        boolean isTabClosable = this.tabbedPane.isTabClosableAt(selectedIndex);
        this.closeMenuItem.setEnabled(isTabClosable);
        this.closeMenuItem.setText(SwingLocale.getString("close") + " " + SwingLocale.getString("quotation_left") + text + SwingLocale.getString("quotation_right"));
        this.closeMenuItem.setToolTipText(SwingLocale.getString("close") + " " + SwingLocale.getString("quotation_left") + text + SwingLocale.getString("quotation_right"));
        this.closeOthersMenuItem.setText(SwingLocale.getString("close_all_except") + " " + SwingLocale.getString("quotation_left") + text + SwingLocale.getString("quotation_right"));
        this.closeOthersMenuItem.setToolTipText(SwingLocale.getString("close_all_except") + " " + SwingLocale.getString("quotation_left") + text + SwingLocale.getString("quotation_right"));
    }
}

