/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tabbedpane;

import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.lookandfeel.LookAndFeelManager;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.checkbox.JCheckBoxSelector;
import com.nepxion.swing.tabbedpane.ITabbedPane;
import com.nepxion.swing.tabbedpane.JBasicTabbedPane;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class TabbedPaneManager {
    public static void setPreferenceStyle(JTabbedPane tabbedPane) {
        tabbedPane.setFocusable(false);
        if (LookAndFeelManager.isNimbusLookAndFeel() && tabbedPane instanceof JBasicTabbedPane) {
            JBasicTabbedPane basicTabbedPane = (JBasicTabbedPane)tabbedPane;
            basicTabbedPane.setDrawBorder(false);
            basicTabbedPane.setDrawCenter(false);
        }
    }

    public static void showCloseDialog(ITabbedPane tabbedPane, JCheckBoxSelector checkBoxSelector) {
        List selectedComponents;
        if (tabbedPane == null) {
            return;
        }
        Vector<ElementNode> selectionElementNodes = new Vector<ElementNode>();
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            if (!tabbedPane.isTabClosableAt(i)) continue;
            String title = tabbedPane.getTitleAt(i);
            String toolTipText = tabbedPane.getToolTipTextAt(i);
            Icon icon = tabbedPane.getIcon(i);
            Component component = tabbedPane.getComponentAt(i);
            ElementNode elementNode = new ElementNode(title, title, icon, toolTipText, (Object)component);
            selectionElementNodes.add(elementNode);
        }
        if (selectionElementNodes.size() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame((Component)((Object)tabbedPane)), SwingLocale.getString("no_close_item"), SwingLocale.getString("warning"), 2);
            return;
        }
        if (checkBoxSelector == null) {
            checkBoxSelector = new JCheckBoxSelector(HandleManager.getFrame((Component)((Object)tabbedPane)), SwingLocale.getString("select_close"));
        }
        checkBoxSelector.getCheckBoxList().setListData(selectionElementNodes);
        checkBoxSelector.setVisible(true);
        checkBoxSelector.dispose();
        if (checkBoxSelector.isConfirmed() && (selectedComponents = checkBoxSelector.getSelectedUserObjects()) != null) {
            tabbedPane.removeTabs(selectedComponents);
        }
    }

    public static int getTabHeight(JTabbedPane tabbedPane) {
        int maxContentHeight = TabbedPaneManager.getMaxContentHeight(tabbedPane);
        int tabHeight = tabbedPane.getSize().height - maxContentHeight;
        return tabHeight;
    }

    public static int getPreferredTabHeight(JTabbedPane tabbedPane) {
        int maxContentHeight = TabbedPaneManager.getMaxPreferredContentHeight(tabbedPane);
        int tabHeight = tabbedPane.getPreferredSize().height - maxContentHeight;
        return tabHeight;
    }

    public static int getMaxContentHeight(JTabbedPane tabbedPane) {
        int contentHeight = -1;
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Component component = tabbedPane.getComponentAt(i);
            if (component.getSize().height <= contentHeight) continue;
            contentHeight = component.getSize().height;
        }
        return contentHeight;
    }

    public static int getMaxPreferredContentHeight(JTabbedPane tabbedPane) {
        int contentHeight = -1;
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Component component = tabbedPane.getComponentAt(i);
            if (component.getPreferredSize().height <= contentHeight) continue;
            contentHeight = component.getPreferredSize().height;
        }
        return contentHeight;
    }
}

