/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.shrinkbar;

import com.nepxion.swing.border.LineBorder;
import com.nepxion.swing.shrinkbar.JShrinkHeader;
import com.nepxion.swing.shrinkbar.JSplitBar;
import com.nepxion.swing.shrinkbar.ShrinkContants;
import com.nepxion.swing.style.texture.shrink.IHeaderTextureStyle;
import com.nepxion.swing.toolbar.JBasicToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BasicShrinkBar
extends JPanel
implements ShrinkContants {
    protected JShrinkHeader shrinkHeader;
    protected JSplitBar splitBar;
    protected JPanel shrinkContentPane;
    protected int splitWidth = 2;

    public BasicShrinkBar(int placement) {
        this(placement, 2);
    }

    public BasicShrinkBar(int placement, IHeaderTextureStyle headerTextureStyle) {
        this(placement, 2, headerTextureStyle);
    }

    public BasicShrinkBar(int placement, int contentPaneType) {
        this(placement, contentPaneType, DEFAULT_HEADER_TEXTURE_STYLE);
    }

    public BasicShrinkBar(int placement, int contentPaneType, IHeaderTextureStyle headerTextureStyle) {
        this.shrinkHeader = new JShrinkHeader(placement, contentPaneType, headerTextureStyle){

            @Override
            public void setShrinked(boolean shrinked) {
                super.setShrinked(shrinked);
                BasicShrinkBar.this.splitBar.setShrinked(shrinked);
                BasicShrinkBar.this.shrinkChanged(shrinked);
            }
        };
        this.splitBar = new JSplitBar(this.shrinkHeader, this.splitWidth);
        this.shrinkContentPane = new JPanel();
        this.shrinkContentPane.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.shrinkHeader, "North");
        this.add((Component)this.shrinkContentPane, "Center");
        this.togglePlacement();
    }

    protected void togglePlacement() {
        if (!this.isShrinkable()) {
            throw new IllegalArgumentException("The shrinking is disabled");
        }
        int placement = this.getPlacement();
        if (placement == 0) {
            this.shrinkContentPane.add((Component)this.splitBar, "West");
            this.shrinkContentPane.setBorder(this.createBorder(this.splitWidth - 1, 0, this.splitWidth, this.splitWidth));
        } else if (placement == 1) {
            this.shrinkContentPane.add((Component)this.splitBar, "East");
            this.shrinkContentPane.setBorder(this.createBorder(this.splitWidth - 1, this.splitWidth, this.splitWidth, 0));
        }
    }

    protected void shrinkChanged(boolean shrinked) {
    }

    public JShrinkHeader getShrinkHeader() {
        return this.shrinkHeader;
    }

    public JLabel getShrinkLabel() {
        return this.shrinkHeader.getLabel();
    }

    public JBasicToolBar getShrinkToolBar() {
        return this.shrinkHeader.getToolBar();
    }

    public String getTitle() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getText();
    }

    public void setTitle(String title) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setText(title);
    }

    public Icon getIcon() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getIcon();
    }

    public void setIcon(Icon icon) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setIcon(icon);
    }

    @Override
    public String getToolTipText() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setToolTipText(toolTipText);
    }

    public Color getTitleColor() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getForeground();
    }

    public void setTitleColor(Color color) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setForeground(color);
    }

    public Font getTitleFont() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getFont();
    }

    public void setTitleFont(Font font) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setFont(font);
    }

    public int getPlacement() {
        return this.shrinkHeader.getPlacement();
    }

    public void setPlacement(int placement) {
        this.shrinkHeader.setPlacement(placement);
        this.togglePlacement();
    }

    public int getContentPaneType() {
        return this.shrinkHeader.getContentPaneType();
    }

    public void setContentPaneType(int contentPaneType) {
        this.shrinkHeader.setContentPaneType(contentPaneType);
    }

    public boolean isShrinked() {
        return this.shrinkHeader.isShrinked();
    }

    public void setShrinked(boolean shrinked) {
        this.shrinkHeader.setShrinked(shrinked);
    }

    public boolean isShrinkable() {
        return this.shrinkHeader.isShrinkable();
    }

    public void setShrinkable(boolean shrinkable) {
        this.shrinkHeader.setShrinkable(shrinkable);
        if (shrinkable) {
            this.togglePlacement();
        } else if (this.retrieveComponent(this.splitBar)) {
            this.shrinkContentPane.remove(this.splitBar);
            this.shrinkContentPane.setBorder(this.createBorder(this.splitWidth - 1, this.splitWidth, this.splitWidth, this.splitWidth));
        }
    }

    private boolean retrieveComponent(Component component) {
        for (int i = 0; i < this.shrinkContentPane.getComponentCount(); ++i) {
            Component c = this.shrinkContentPane.getComponent(i);
            if (c != component) continue;
            return true;
        }
        return false;
    }

    public int getShrinkedWidth() {
        return this.shrinkHeader.getShrinkedWidth();
    }

    public void setShrinkedWidth(int shrinkedWidth) {
        this.shrinkHeader.setShrinkedWidth(shrinkedWidth);
    }

    private Border createBorder(int top, int left, int bottom, int right) {
        LineBorder lineBorder = new LineBorder(this.shrinkHeader.getHeaderTextureStyle().getBorderColor());
        lineBorder.setColor(null, 1);
        return BorderFactory.createCompoundBorder(lineBorder, BorderFactory.createEmptyBorder(top, left, bottom, right));
    }
}

