/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.checkbox;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.button.ISelectorMenuButton;
import com.nepxion.swing.selector.button.JBasicSelectorMenuButton;
import com.nepxion.swing.selector.button.JClassicSelectorMenuButton;
import com.nepxion.swing.selector.checkbox.JCheckBoxListPanel;
import com.nepxion.swing.textfield.JBasicTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPanel;

public class JCheckBoxSelectorBar
extends JPanel {
    private JBasicTextField textField = new JBasicTextField();
    private ISelectorMenuButton menuButton;
    private JCheckBoxListPanel checkBoxListPanel;

    public JCheckBoxSelectorBar(List allElementNodes) {
        this(allElementNodes, false);
    }

    public JCheckBoxSelectorBar(List allElementNodes, boolean isClassicStyle) {
        this.textField.setEditable(false);
        this.checkBoxListPanel = new JCheckBoxListPanel(allElementNodes);
        this.checkBoxListPanel.setPreferredSize(new Dimension(300, 300));
        this.menuButton = isClassicStyle ? new JClassicSelectorMenuButton((Icon)IconFactory.getSwingIcon("property.png"), SwingLocale.getString("selection")){

            @Override
            public boolean confirm() {
                return JCheckBoxSelectorBar.this.confirm();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        } : new JBasicSelectorMenuButton((Icon)IconFactory.getSwingIcon("property.png"), SwingLocale.getString("selection")){

            @Override
            public boolean confirm() {
                return JCheckBoxSelectorBar.this.confirm();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        };
        this.menuButton.setContentPane(this.checkBoxListPanel);
        JPanel buttonContainer = this.menuButton.getOptionButtonPanel().getContainer();
        JClassicButton refreshButton = new JClassicButton(SwingLocale.getString("refresh"), IconFactory.getSwingIcon("stereo/refresh_16.png"), SwingLocale.getString("refresh"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxSelectorBar.this.refresh();
            }
        });
        buttonContainer.add((Component)refreshButton, 0);
        JClassicButton selectAllButton = new JClassicButton(SwingLocale.getString("select_all"), IconFactory.getSwingIcon("stereo/redo_16.png"), SwingLocale.getString("select_all"));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxSelectorBar.this.checkBoxListPanel.adaptListFacade((byte)0);
            }
        });
        buttonContainer.add((Component)selectAllButton, 1);
        JClassicButton selectReverseButton = new JClassicButton(SwingLocale.getString("select_reverse"), IconFactory.getSwingIcon("stereo/undo_16.png"), SwingLocale.getString("select_reverse"));
        selectReverseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxSelectorBar.this.checkBoxListPanel.adaptListFacade((byte)2);
            }
        });
        buttonContainer.add((Component)selectReverseButton, 2);
        buttonContainer.add(Box.createHorizontalStrut(5), 3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)((Object)this.menuButton), "East");
        ButtonManager.updateUI((Container)this, new Dimension(26, 26));
    }

    public void refresh() {
    }

    public boolean confirm() {
        List selectedElementNodes = this.checkBoxListPanel.getSelectedElementNodes();
        if (selectedElementNodes == null || selectedElementNodes.size() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("select_not_null"), SwingLocale.getString("warning"), 2);
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (ElementNode elementNode : selectedElementNodes) {
            String text = elementNode.getText();
            stringBuffer.append(text + ",");
        }
        String content = stringBuffer.toString();
        content = content.substring(0, content.lastIndexOf(","));
        this.textField.setText(content);
        return true;
    }

    public JBasicTextField getTextField() {
        return this.textField;
    }

    public ISelectorMenuButton getMenuButton() {
        return this.menuButton;
    }

    public JCheckBoxListPanel getCheckBoxListPanel() {
        return this.checkBoxListPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEditable(enabled);
        ((Component)((Object)this.menuButton)).setEnabled(enabled);
    }

    public Object getValue() {
        return this.textField.getText();
    }

    public void setValue(Object value) {
        this.textField.setText(value != null ? value.toString() : "");
    }
}

