/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.servlet;

import com.nepxion.util.database.pool.proxool.ProxoolContext;
import com.nepxion.util.log.LoggerContext;
import com.nepxion.util.scheduler.quartz.QuartzContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class ContextServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initLogger();
        this.initProxool();
        this.initQuartz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLogger() {
        String loggerPath = this.getInitParameter("loggerPath");
        if (loggerPath != null) {
            loggerPath = this.getServletContext().getRealPath(loggerPath);
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(loggerPath);
                properties.load(inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            loggerPath = loggerPath.substring(0, loggerPath.lastIndexOf("\\") + 1);
            properties.setProperty("log4j.appender.FileAppender.File", loggerPath + properties.getProperty("log4j.appender.FileAppender.File"));
            properties.setProperty("log4j.appender.RollingFileAppender.File", loggerPath + properties.getProperty("log4j.appender.RollingFileAppender.File"));
            this.initServiceLogger(properties, loggerPath);
            try {
                LoggerContext.register(properties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initServiceLogger(Properties properties, String loggerPath) {
    }

    private void initProxool() {
        String proxoolPath = this.getInitParameter("proxoolPath");
        if (proxoolPath != null) {
            proxoolPath = this.getServletContext().getRealPath(proxoolPath);
            try {
                ProxoolContext.register(proxoolPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initQuartz() {
        String quartzPath = this.getInitParameter("quartzPath");
        if (quartzPath != null) {
            quartzPath = this.getServletContext().getRealPath(quartzPath);
            try {
                QuartzContext.register(quartzPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

