/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.database.pool.proxool;

import com.nepxion.util.database.pool.proxool.ProxoolConstants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ProxoolContext
implements ProxoolConstants {
    private static Log log = LogFactory.getLog(ProxoolContext.class);

    public static void register() throws ProxoolException {
        ProxoolContext.register("conf/proxool.properties");
    }

    public static void register(String filePath) throws ProxoolException {
        log.info((Object)"---- Proxool Context Initialization Start ---");
        try {
            PropertyConfigurator.configure((String)filePath);
        }
        catch (ProxoolException e) {
            log.fatal((Object)e);
            throw e;
        }
        log.info((Object)"----- Proxool Context Initialization End ----");
    }

    public static void register(Properties properties) throws ProxoolException {
        log.info((Object)"---- Proxool Context Initialization Start ---");
        try {
            PropertyConfigurator.configure((Properties)properties);
        }
        catch (ProxoolException e) {
            log.fatal((Object)e);
            throw e;
        }
        log.info((Object)"---- Proxool Context Initialization Start ---");
    }

    public static void register(URL codeBase) throws MalformedURLException, IOException, ProxoolException {
        Properties properties = new Properties();
        try {
            URL url = new URL(codeBase + "conf/proxool.properties");
            properties.load(url.openStream());
            ProxoolContext.register(properties);
        }
        catch (MalformedURLException e) {
            log.fatal((Object)e);
            throw e;
        }
        catch (IOException e) {
            log.fatal((Object)e);
            throw e;
        }
        catch (ProxoolException e) {
            log.fatal((Object)e);
            throw e;
        }
    }
}

