/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.io.BadVersionException;
import y.io.IOHandler;
import y.util.D;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DNodeRealizer;
import y.view.NodeRealizer;
import y.view.hierarchy.HierarchyManager;

public class YGFIOHandler
extends IOHandler {
    private HierarchyManager i;
    private boolean j;

    public String getFileFormatString() {
        return "Y Graph Format";
    }

    public String getFileNameExtension() {
        return "ygf";
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        D.bug(this, (Object)"writeOS");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        this.i = HierarchyManager.getInstance(graph2D);
        this.write(graph2D, objectOutputStream);
        objectOutputStream.flush();
    }

    protected void write(Graph2D graph2D, ObjectOutputStream objectOutputStream) throws IOException {
        D.bug(this, (Object)"writeOOS");
        objectOutputStream.writeByte(1);
        objectOutputStream.writeBoolean(this.i != null);
        objectOutputStream.writeInt(graph2D.nodeCount());
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            this.writeNodeInfo(graph2D, nodeCursor.node(), objectOutputStream);
            nodeCursor.next();
        }
        objectOutputStream.writeInt(graph2D.edgeCount());
        EdgeCursor edgeCursor = graph2D.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            objectOutputStream.writeInt(edge.source().index());
            objectOutputStream.writeInt(edge.target().index());
            this.writeEdgeInfo(graph2D, edge, objectOutputStream);
            edgeCursor.next();
        }
    }

    protected void writeEdgeInfo(Graph2D graph2D, Edge edge, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        this.writeEdgeRealizer(graph2D, edge, objectOutputStream);
        this.writeInterEdgeInfo(graph2D, edge, objectOutputStream);
    }

    protected void writeEdgeRealizer(Graph2D graph2D, Edge edge, ObjectOutputStream objectOutputStream) throws IOException {
        EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
        objectOutputStream.writeObject(edgeRealizer.getClass().getName());
        edgeRealizer.write(objectOutputStream);
    }

    protected void writeInterEdgeInfo(Graph2D graph2D, Edge edge, ObjectOutputStream objectOutputStream) throws IOException {
        if (this.i == null) {
            return;
        }
        if (this.i.isInterEdge(edge)) {
            int n;
            Object[] objectArray;
            Node node;
            objectOutputStream.writeBoolean(true);
            if (this.i.isFolderNode(edge.source())) {
                node = this.i.getRealSource(edge);
                objectOutputStream.writeBoolean(true);
                objectArray = this.i.getFolderPath(node);
                n = 1;
                while (n < objectArray.length && objectArray[n] != edge.source()) {
                    ++n;
                }
                objectOutputStream.writeInt(objectArray.length - n);
                ++n;
                while (n < objectArray.length) {
                    objectOutputStream.writeInt(((Node)objectArray[n]).index());
                    ++n;
                }
                objectOutputStream.writeInt(node.index());
            } else {
                objectOutputStream.writeBoolean(false);
            }
            if (this.i.isFolderNode(edge.target())) {
                node = this.i.getRealTarget(edge);
                objectOutputStream.writeBoolean(true);
                objectArray = this.i.getFolderPath(node);
                n = 1;
                while (n < objectArray.length && objectArray[n] != edge.target()) {
                    ++n;
                }
                objectOutputStream.writeInt(objectArray.length - n);
                ++n;
                while (n < objectArray.length) {
                    objectOutputStream.writeInt(((Node)objectArray[n]).index());
                    ++n;
                }
                objectOutputStream.writeInt(node.index());
            } else {
                objectOutputStream.writeBoolean(false);
            }
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    protected void writeNodeInfo(Graph2D graph2D, Node node, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        this.writeNodeRealizer(graph2D, node, objectOutputStream);
        this.writeFolderNodeInfo(graph2D, node, objectOutputStream);
    }

    protected void writeNodeRealizer(Graph2D graph2D, Node node, ObjectOutputStream objectOutputStream) throws IOException {
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        objectOutputStream.writeObject(nodeRealizer.getClass().getName());
        nodeRealizer.write(objectOutputStream);
        if (nodeRealizer instanceof Graph2DNodeRealizer && this.i == null) {
            this.write(((Graph2DNodeRealizer)nodeRealizer).getInnerGraph(), objectOutputStream);
        }
    }

    protected void writeFolderNodeInfo(Graph2D graph2D, Node node, ObjectOutputStream objectOutputStream) throws IOException {
        if (this.i == null) {
            return;
        }
        if (this.i.isFolderNode(node)) {
            objectOutputStream.writeBoolean(true);
            this.write((Graph2D)this.i.getInnerGraph(node), objectOutputStream);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        graph2D.firePreEvent();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.i = HierarchyManager.getInstance(graph2D);
        this.read(graph2D, objectInputStream);
        graph2D.firePostEvent();
    }

    protected void read(Graph2D graph2D, ObjectInputStream objectInputStream) throws IOException {
        D.bug(this, (Object)"readOIS");
        D.bug(this, (Object)"read Version");
        byte by = objectInputStream.readByte();
        if (by == 0) {
            this.j = false;
        } else if (by == 1) {
            this.j = objectInputStream.readBoolean();
        } else {
            throw new BadVersionException(by);
        }
        D.bug(this, (Object)"read nodes");
        int n = objectInputStream.readInt();
        Node[] nodeArray = new Node[n];
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = graph2D.createNode(null);
            this.readNodeInfo(graph2D, nodeArray[n2], objectInputStream);
            ++n2;
        }
        D.bug(this, (Object)"read edges");
        int n3 = objectInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            Node node = nodeArray[objectInputStream.readInt()];
            Node node2 = nodeArray[objectInputStream.readInt()];
            Edge edge = graph2D.createEdge(node, node2, null);
            this.readEdgeInfo(graph2D, edge, objectInputStream);
            ++n4;
        }
        D.bug(this, (Object)"readOIS done");
    }

    protected void readNodeInfo(Graph2D graph2D, Node node, ObjectInputStream objectInputStream) throws IOException {
        D.bug(this, (Object)("read node" + node));
        byte by = objectInputStream.readByte();
        if (by == 0) {
            this.readNodeRealizer(graph2D, node, objectInputStream);
        } else if (by == 1) {
            this.readNodeRealizer(graph2D, node, objectInputStream);
            this.readFolderNodeInfo(graph2D, node, objectInputStream);
        } else {
            throw new BadVersionException(by);
        }
    }

    protected void readNodeRealizer(Graph2D graph2D, Node node, ObjectInputStream objectInputStream) throws IOException {
        try {
            D.bug(this, (Object)("read node" + node));
            Class<?> clazz = Class.forName((String)objectInputStream.readObject());
            NodeRealizer nodeRealizer = (NodeRealizer)clazz.newInstance();
            graph2D.setRealizer(node, nodeRealizer);
            nodeRealizer.read(objectInputStream);
            if (nodeRealizer instanceof Graph2DNodeRealizer && !this.j) {
                Graph2D graph2D2 = this.createInnerGraph(node);
                this.read(graph2D2, objectInputStream);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected Graph2D createInnerGraph(Node node) {
        return new Graph2D();
    }

    protected void readFolderNodeInfo(Graph2D graph2D, Node node, ObjectInputStream objectInputStream) throws IOException {
        if (!this.j) {
            return;
        }
        if (objectInputStream.readBoolean()) {
            Graph2D graph2D2;
            if (this.i != null) {
                this.i.convertToFolderNode(node);
                graph2D2 = (Graph2D)this.i.getInnerGraph(node);
            } else {
                graph2D2 = this.createInnerGraph(node);
            }
            if (graph2D.getRealizer(node) instanceof Graph2DNodeRealizer) {
                Graph2DNodeRealizer graph2DNodeRealizer = (Graph2DNodeRealizer)graph2D.getRealizer(node);
                graph2DNodeRealizer.setInnerGraph(graph2D2);
            }
            this.read(graph2D2, objectInputStream);
        }
    }

    protected void readEdgeInfo(Graph2D graph2D, Edge edge, ObjectInputStream objectInputStream) throws IOException {
        byte by = objectInputStream.readByte();
        if (by == 0) {
            this.readEdgeRealizer(graph2D, edge, objectInputStream);
        } else if (by == 1) {
            this.readEdgeRealizer(graph2D, edge, objectInputStream);
            this.readInterEdgeInfo(graph2D, edge, objectInputStream);
        } else {
            throw new BadVersionException(by);
        }
    }

    protected void readEdgeRealizer(Graph2D graph2D, Edge edge, ObjectInputStream objectInputStream) throws IOException {
        try {
            D.bug(this, (Object)("read edge" + edge));
            Class<?> clazz = Class.forName((String)objectInputStream.readObject());
            EdgeRealizer edgeRealizer = (EdgeRealizer)clazz.newInstance();
            graph2D.setRealizer(edge, edgeRealizer);
            edgeRealizer.read(objectInputStream);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void readInterEdgeInfo(Graph2D graph2D, Edge edge, ObjectInputStream objectInputStream) throws IOException {
        if (!this.j) {
            return;
        }
        if (objectInputStream.readBoolean()) {
            int n;
            int n2;
            Graph graph;
            Node node = edge.source();
            Node node2 = edge.target();
            if (objectInputStream.readBoolean()) {
                graph = graph2D;
                n2 = objectInputStream.readInt();
                do {
                    n = objectInputStream.readInt();
                    if (this.i == null) continue;
                    graph = this.i.getInnerGraph(node);
                    node = this.a(graph, n);
                } while (--n2 > 0);
            }
            if (objectInputStream.readBoolean()) {
                graph = graph2D;
                n2 = objectInputStream.readInt();
                do {
                    n = objectInputStream.readInt();
                    if (this.i == null) continue;
                    graph = this.i.getInnerGraph(node2);
                    node2 = this.a(graph, n);
                } while (--n2 > 0);
            }
            if (this.i != null) {
                this.i.convertToInterEdge(edge, node, node2);
            }
        }
    }

    private Node a(Graph graph, int n) {
        int n2 = 0;
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            if (n2 == n) {
                return nodeCursor.node();
            }
            nodeCursor.next();
            ++n2;
        }
        return null;
    }
}

