/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tween;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class PositionTweener
implements ActionListener {
    private Component component;
    private int frameInterval = 1;
    private int frameCount = 20;
    private int frameIndex = 0;
    private Timer timer;
    private Rectangle startBounds;
    private Rectangle endBounds;

    public PositionTweener(Component component, Rectangle startBounds, Rectangle endBounds) {
        this(component, startBounds, endBounds, 1, 20);
    }

    public PositionTweener(Component component, Rectangle startBounds, Rectangle endBounds, int frameInterval, int frameCount) {
        this.component = component;
        this.startBounds = startBounds;
        this.endBounds = endBounds;
        this.frameInterval = frameInterval;
        this.frameCount = frameCount;
        this.timer = new Timer(this.frameInterval, this);
    }

    public void tween() {
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int startX = this.startBounds.x;
        int startY = this.startBounds.y;
        int startWidth = this.startBounds.width;
        int startHeight = this.startBounds.height;
        int endX = this.endBounds.x;
        int endY = this.endBounds.y;
        int endWidth = this.endBounds.width;
        int endHeight = this.endBounds.height;
        int xOffset = (endX - startX) * this.frameIndex / this.frameCount;
        int yOffset = (endY - startY) * this.frameIndex / this.frameCount;
        int widthOffset = (endWidth - startWidth) * this.frameIndex / this.frameCount;
        int heightOffset = (endHeight - startHeight) * this.frameIndex / this.frameCount;
        Rectangle bounds = new Rectangle(startX + xOffset, startY + yOffset, startWidth + widthOffset, startHeight + heightOffset);
        this.component.setBounds(bounds);
        this.component.validate();
        if (this.frameIndex == this.frameCount) {
            this.timer.stop();
        } else {
            ++this.frameIndex;
        }
    }
}

