/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree.lazyloader;

import com.nepxion.swing.tree.TreeManager;
import com.nepxion.swing.tree.lazyloader.ILazyLoader;
import com.nepxion.swing.tree.lazyloader.ILazyLoaderTree;
import com.nepxion.swing.tree.lazyloader.JLazyLoaderTreeNode;
import com.nepxion.swing.tree.lazyloader.LazyLoaderSwingWorker;
import com.nepxion.swing.tree.lazyloader.LoadingTreeNode;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LazyLoaderTreeManager
extends TreeManager {
    public static void load(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        ILazyLoader lazyLoader = lazyLoaderTree.getLazyLoader();
        if (lazyLoader == null) {
            throw new IllegalArgumentException("LazyLoader can't be null");
        }
        if (treeNode == null || !(treeNode instanceof JLazyLoaderTreeNode)) {
            return;
        }
        JLazyLoaderTreeNode lazyLoaderTreeNode = (JLazyLoaderTreeNode)treeNode;
        if (lazyLoader.isLoaded(lazyLoaderTreeNode) || lazyLoader.isLoading(lazyLoaderTreeNode) || lazyLoaderTreeNode.isLeaf()) {
            return;
        }
        LazyLoaderSwingWorker lazyLoaderSwingWorker = new LazyLoaderSwingWorker(lazyLoaderTree, lazyLoaderTreeNode);
        lazyLoaderSwingWorker.execute();
    }

    public static void load(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.load(lazyLoaderTree, treeNode);
    }

    public static void load(ILazyLoaderTree lazyLoaderTree, TreeNode[] treeNodes) {
        for (int i = 0; i < treeNodes.length; ++i) {
            TreeNode treeNode = treeNodes[i];
            LazyLoaderTreeManager.load(lazyLoaderTree, treeNode);
        }
    }

    public static void load(ILazyLoaderTree lazyLoaderTree, TreePath[] treePaths) {
        for (int i = 0; i < treePaths.length; ++i) {
            TreePath treePath = treePaths[i];
            LazyLoaderTreeManager.load(lazyLoaderTree, treePath);
        }
    }

    public static void loadGrandchildren(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode childTreeNode = enumeration.nextElement();
            LazyLoaderTreeManager.load(lazyLoaderTree, childTreeNode);
        }
        LazyLoaderTreeManager.load(lazyLoaderTree, treeNode);
    }

    public static void loadGrandchildren(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.loadGrandchildren(lazyLoaderTree, treeNode);
    }

    public static void loadGrandchildren(ILazyLoaderTree lazyLoaderTree, TreeNode[] treeNodes) {
        for (int i = 0; i < treeNodes.length; ++i) {
            TreeNode treeNode = treeNodes[i];
            LazyLoaderTreeManager.loadGrandchildren(lazyLoaderTree, treeNode);
        }
    }

    public static void loadGrandchildren(ILazyLoaderTree lazyLoaderTree, TreePath[] treePaths) {
        for (int i = 0; i < treePaths.length; ++i) {
            TreePath treePath = treePaths[i];
            LazyLoaderTreeManager.loadGrandchildren(lazyLoaderTree, treePath);
        }
    }

    public static void loadAll(ILazyLoaderTree lazyLoaderTree) {
        TreeNode root = (TreeNode)lazyLoaderTree.getModel().getRoot();
        LazyLoaderTreeManager.loadAll(lazyLoaderTree, root);
    }

    public static void loadAll(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode childTreeNode = enumeration.nextElement();
            LazyLoaderTreeManager.loadAll(lazyLoaderTree, childTreeNode);
        }
        LazyLoaderTreeManager.load(lazyLoaderTree, treeNode);
    }

    public static void loadAll(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.loadAll(lazyLoaderTree, treeNode);
    }

    public static void cancel(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        LoadingTreeNode loadingTreeNode;
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode childTreeNode = enumeration.nextElement();
            LazyLoaderTreeManager.cancel(lazyLoaderTree, childTreeNode);
        }
        if (treeNode instanceof LoadingTreeNode && (loadingTreeNode = (LoadingTreeNode)treeNode).getSwingWorker() != null) {
            loadingTreeNode.getSwingWorker().cancel(true);
        }
    }

    public static void cancel(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.cancel(lazyLoaderTree, treeNode);
    }

    public static void cancel(ILazyLoaderTree lazyLoaderTree, TreeNode[] treeNodes) {
        for (int i = 0; i < treeNodes.length; ++i) {
            TreeNode treeNode = treeNodes[i];
            LazyLoaderTreeManager.cancel(lazyLoaderTree, treeNode);
        }
    }

    public static void cancel(ILazyLoaderTree lazyLoaderTree, TreePath[] treePaths) {
        for (int i = 0; i < treePaths.length; ++i) {
            TreePath treePath = treePaths[i];
            LazyLoaderTreeManager.cancel(lazyLoaderTree, treePath);
        }
    }

    public static void cancelGrandchildren(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode childTreeNode = enumeration.nextElement();
            LazyLoaderTreeManager.cancel(lazyLoaderTree, childTreeNode);
        }
        LazyLoaderTreeManager.cancel(lazyLoaderTree, treeNode);
    }

    public static void cancelGrandchildren(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.cancelGrandchildren(lazyLoaderTree, treeNode);
    }

    public static void cancelGrandchildren(ILazyLoaderTree lazyLoaderTree, TreeNode[] treeNodes) {
        for (int i = 0; i < treeNodes.length; ++i) {
            TreeNode treeNode = treeNodes[i];
            LazyLoaderTreeManager.cancelGrandchildren(lazyLoaderTree, treeNode);
        }
    }

    public static void cancelGrandchildren(ILazyLoaderTree lazyLoaderTree, TreePath[] treePaths) {
        for (int i = 0; i < treePaths.length; ++i) {
            TreePath treePath = treePaths[i];
            LazyLoaderTreeManager.cancelGrandchildren(lazyLoaderTree, treePath);
        }
    }

    public static void cancelAll(ILazyLoaderTree lazyLoaderTree) {
        TreeNode root = (TreeNode)lazyLoaderTree.getModel().getRoot();
        LazyLoaderTreeManager.cancel(lazyLoaderTree, root);
    }

    public static void cancelAll(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode childTreeNode = enumeration.nextElement();
            LazyLoaderTreeManager.cancelAll(lazyLoaderTree, childTreeNode);
        }
        LazyLoaderTreeManager.cancelAll(lazyLoaderTree, treeNode);
    }

    public static void cancelAll(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.cancelAll(lazyLoaderTree, treeNode);
    }

    public static void refresh(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        ILazyLoader lazyLoader = lazyLoaderTree.getLazyLoader();
        if (lazyLoader == null) {
            throw new IllegalArgumentException("LazyLoader can't be null");
        }
        if (treeNode == null || !(treeNode instanceof JLazyLoaderTreeNode)) {
            return;
        }
        JLazyLoaderTreeNode lazyLoaderTreeNode = (JLazyLoaderTreeNode)treeNode;
        if (lazyLoader.isLoading(lazyLoaderTreeNode)) {
            return;
        }
        if (lazyLoaderTreeNode.getChildCount() > 0) {
            lazyLoaderTreeNode.removeAllChildren();
        }
        lazyLoaderTreeNode.setLoaded(false);
        lazyLoaderTreeNode.setLeaf(false);
        LazyLoaderSwingWorker lazyLoaderSwingWorker = new LazyLoaderSwingWorker(lazyLoaderTree, lazyLoaderTreeNode);
        lazyLoaderSwingWorker.execute();
    }

    public static void refresh(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.refresh(lazyLoaderTree, treeNode);
    }

    public static void search(ILazyLoaderTree lazyLoaderTree, TreePath treePath) {
        TreeNode treeNode = lazyLoaderTree.getTreeNode(treePath);
        LazyLoaderTreeManager.search(lazyLoaderTree, treeNode);
    }

    public static void search(ILazyLoaderTree lazyLoaderTree, TreeNode treeNode) {
        TreePath treePath = lazyLoaderTree.getTreePath(treeNode);
        if (treeNode.getChildCount() > 0) {
            lazyLoaderTree.expand(treePath);
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode childTreeNode = enumeration.nextElement();
                LazyLoaderTreeManager.search(lazyLoaderTree, childTreeNode);
            }
        } else {
            LazyLoaderTreeManager.load(lazyLoaderTree, treeNode);
        }
    }
}

