/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.preference;

import com.nepxion.swing.border.BorderManager;
import com.nepxion.swing.checkbox.JBasicCheckBox;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.panel.JTimePanel;
import com.nepxion.swing.preference.JPreference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class JSchedulerPreference
extends JPreference {
    private JTimePanel timePanel = new JTimePanel(1);
    private JBasicCheckBox bubbleTipCheckBox;

    public JSchedulerPreference() {
        this.timePanel.setInterval(new int[]{0, 0, 0, 15, 0});
        this.timePanel.showMilliSecond(false);
        this.timePanel.setBorder(BorderManager.createComplexTitledBorder(SwingLocale.getString("timer_interval")));
        this.bubbleTipCheckBox = new JBasicCheckBox(SwingLocale.getString("timer_bubble_tip"), true);
        this.bubbleTipCheckBox.setBorder(BorderFactory.createEmptyBorder());
        JPanel scheduleMessagePanel = new JPanel();
        scheduleMessagePanel.setLayout(new FiledLayout(0, 0, 5));
        scheduleMessagePanel.setBorder(BorderManager.createComplexTitledBorder(SwingLocale.getString("timer_message_hint")));
        scheduleMessagePanel.add(this.bubbleTipCheckBox);
        this.setLayout(new FiledLayout(0, 2, 5));
        this.add(this.timePanel);
        this.add(scheduleMessagePanel);
    }

    public JTimePanel getTimePanel() {
        return this.timePanel;
    }

    public int[] getInterval() {
        return this.timePanel.getInterval();
    }

    public boolean isBubbleTipShown() {
        return this.bubbleTipCheckBox.isSelected();
    }

    @Override
    public boolean verify() {
        return this.timePanel.verify();
    }

    @Override
    public String getToggleText() {
        return SwingLocale.getString("scheduler_toggle_text");
    }

    @Override
    public void setToggleText(String toggleText) {
    }

    @Override
    public Icon getToggleIcon() {
        return IconFactory.getSwingIcon("banner/timer.png");
    }

    @Override
    public void setToggleIcon(Icon toggleIcon) {
    }

    @Override
    public Icon getToggleBannerIcon() {
        return IconFactory.getSwingIcon("banner/timer.png");
    }

    @Override
    public void setToggleBannerIcon(Icon toggleBannerIcon) {
    }

    @Override
    public String getToggleDescription() {
        return SwingLocale.getString("scheduler_toggle_description");
    }

    @Override
    public void setToggleDescription(String toggleDescription) {
    }
}

