/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.E.D;
import twaver.base.A.H.I;
import twaver.chart.RadarAxis;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.network.SVGContext;

public class SVGRadarChart
extends AbstractSVGChart {
    private Font \u0102 = TUIManager.getFont("tchart.radar.axis.text.font");
    private Color \u0113 = TUIManager.getColor("tchart.radar.axis.text.color");
    private Color \u0114 = TUIManager.getColor("tchart.radar.axis.color");
    private String \u011d = TUIManager.getString("tchart.radar.axis.stroke");
    private double \u0101 = TUIManager.getDouble("tchart.radar.axis.start.angle");
    private boolean \u0117 = TUIManager.getBoolean("tchart.radar.axis.text.visible");
    private boolean \u010b = TUIManager.getBoolean("tchart.radar.axis.visible");
    private boolean \u0112 = TUIManager.getBoolean("tchart.radar.axis.inflexion.visible");
    private int \u011a = TUIManager.getInt("tchart.radar.axis.inflexion.style");
    private boolean \u0121 = TUIManager.getBoolean("tchart.radar.ring.visible");
    private int \u011c = TUIManager.getInt("tchart.radar.ring.style");
    private Color \u00f8 = TUIManager.getColor("tchart.radar.ring.major.color");
    private String \u011f = TUIManager.getString("tchart.radar.ring.major.stroke");
    private boolean \u0118 = TUIManager.getBoolean("tchart.radar.ring.min.visible");
    private Color \u0109 = TUIManager.getColor("tchart.radar.ring.min.color");
    private String \u0104 = TUIManager.getString("tchart.radar.ring.min.stroke");
    private boolean \u0110 = TUIManager.getBoolean("tchart.radar.fill");
    private Color \u010e = TUIManager.getColor("tchart.radar.fill.color");
    private boolean \u0119 = TUIManager.getBoolean("tchart.radar.fill.gradient");
    private Color \u011e = TUIManager.getColor("tchart.radar.fill.gradient.color");
    private int \u010c = TUIManager.getInt("tchart.radar.fill.gradient.factory");
    private double \u0111 = TUIManager.getDouble("tchart.radar.scale.max.value");
    private double \u010a = TUIManager.getDouble("tchart.radar.scale.min.value");
    private boolean \u0105 = TUIManager.getBoolean("tchart.radar.scale.major.text.visible");
    private Font \u0106 = TUIManager.getFont("tchart.radar.scale.major.text.font");
    private Color \u0107 = TUIManager.getColor("tchart.radar.scale.major.text.color");
    private int \u00fc = TUIManager.getInt("tchart.radar.scale.major.count");
    private int \u010d = TUIManager.getInt("tchart.radar.scale.min.count");
    private boolean \u0103 = TUIManager.getBoolean("tchart.radar.shape.fill.gradient");
    private Color \u00fb = TUIManager.getColor("tchart.radar.shape.fill.gradient.color");
    private int \u011b = TUIManager.getInt("tchart.inflexion.style");
    private boolean \u00fe = TUIManager.getBoolean("tchart.radar.inflexion.visible");
    private boolean \u00fd = TUIManager.getBoolean("tchart.radar.line.visible");
    private boolean \u0116 = TUIManager.getBoolean("tchart.radar.area.fill");
    private List \u0120 = new ArrayList();
    private Rectangle \u0100;
    private double \u00fa;
    private double \u00f9;
    private double \u0115 = 0.0;
    private double \u010f = 0.0;
    private int \u0122 = 50;
    private int \u0108 = 128;
    private static double \u00ff = Math.PI / 180;

    public SVGRadarChart() {
    }

    public SVGRadarChart(TDataBox box) {
        super(box);
    }

    public SVGRadarChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor);
    }

    public SVGRadarChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    protected void calculate() {
    }

    public StringBuffer toSVGContent(SVGContext context, int width, int height) {
        StringBuffer result = new StringBuffer();
        this.paintChart(context, result, width, height);
        return result;
    }

    public void paintChart(SVGContext context, StringBuffer result, int width, int height) {
        this.backgroundBounds.x = this.xGap;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = width - 2 * this.xGap;
        this.backgroundBounds.height = height - 2 * this.yGap;
        this.appendSVGBackground(context, result);
        double widthR = (double)(width - 2 * this.xGap) / 2.0;
        double heightR = (double)(height - 2 * this.yGap) / 2.0;
        double widthMaxR = 0.0;
        double heightMaxR = 0.0;
        if (this.\u0117) {
            int listSize = this.\u0120.size();
            for (int i2 = 0; i2 < listSize; ++i2) {
                Object obj = this.\u0120.get(i2);
                String text = "";
                if (obj instanceof RadarAxis) {
                    RadarAxis axis = (RadarAxis)obj;
                    if (!axis.isAxisTextVisible()) continue;
                    text = axis.getText();
                } else {
                    text = obj.toString();
                }
                Dimension dim = this.A(text, this.\u0102);
                if (dim.getWidth() > widthMaxR) {
                    widthMaxR = dim.getWidth();
                }
                if (!(dim.getHeight() > heightMaxR)) continue;
                heightMaxR = dim.getHeight();
            }
        }
        double r = heightR - heightMaxR > widthR - widthMaxR ? widthR - widthMaxR : heightR - heightMaxR;
        this.\u0100 = D.A((double)this.xGap + widthR - r, (double)this.yGap + heightR - r, (double)this.xGap + widthR + r, (double)this.yGap + heightR + r);
        this.\u00fa = this.\u0100.getCenterX();
        this.\u00f9 = this.\u0100.getCenterY();
        this.\u0115 = this.\u0111 - this.\u010a;
        if (this.\u0120.size() < 1) {
            return;
        }
        this.D(context, result);
        this.A(context, result);
        this.B(context, result);
        this.C(context, result);
    }

    private void D(SVGContext context, StringBuffer result) {
        double r = this.\u0100.getWidth() / 2.0;
        double minr = r / (double)this.\u00fc;
        if (this.\u0110) {
            Shape shape = null;
            if (this.\u011c == 2) {
                Ellipse2D.Double ellip;
                shape = ellip = new Ellipse2D.Double(this.\u0100.getX(), this.\u0100.getY(), this.\u0100.getWidth(), this.\u0100.getHeight());
            } else if (this.\u011c == 1) {
                GeneralPath path = new GeneralPath();
                int size = this.\u0120.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    double ang = (this.\u010f * (double)j2 + this.\u0101) * \u00ff;
                    float pointX = (int)(this.\u00fa + r * Math.cos(ang));
                    float pointY = (int)(this.\u00f9 + r * Math.sin(ang));
                    if (j2 == 0) {
                        path.moveTo(pointX, pointY);
                        continue;
                    }
                    path.lineTo(pointX, pointY);
                }
                path.closePath();
                shape = path;
            }
            if (shape != null) {
                if (this.\u0119) {
                    String gradientID = this.getGradientID(context, this.\u010c, this.\u011e, this.\u010e);
                    I.A(context, result, shape, gradientID);
                } else {
                    I.A(context, result, shape, this.\u010e);
                }
            }
        }
        if (this.\u00fc < 1 || !this.\u0121) {
            return;
        }
        for (int i2 = 0; i2 <= this.\u00fc; ++i2) {
            double length = minr * (double)i2;
            double minLength = minr / (double)(this.\u010d + 1);
            if (this.\u011c == 2) {
                Ellipse2D.Double ring = new Ellipse2D.Double(this.\u00fa - length, this.\u00f9 - length, length * 2.0, length * 2.0);
                I.A(context, result, ring, this.\u00f8, TUIManager.getStrokeByType(this.\u011f));
                if (i2 == this.\u00fc || !this.\u0118) continue;
                for (int j3 = 1; j3 <= this.\u010d; ++j3) {
                    double dx = this.\u00fa - (length + minLength * (double)j3);
                    double dy = this.\u00f9 - (length + minLength * (double)j3);
                    ring = new Ellipse2D.Double(dx, dy, (length + minLength * (double)j3) * 2.0, (length + minLength * (double)j3) * 2.0);
                    I.A(context, result, ring, this.\u0109, TUIManager.getStrokeByType(this.\u0104));
                }
                continue;
            }
            if (this.\u011c != 1) continue;
            GeneralPath path = new GeneralPath();
            int size = this.\u0120.size();
            for (int j4 = 0; j4 < size; ++j4) {
                double angle = (this.\u010f * (double)j4 + this.\u0101) * \u00ff;
                float pointX = (int)(this.\u00fa + length * Math.cos(angle));
                float pointY = (int)(this.\u00f9 + length * Math.sin(angle));
                if (j4 == 0) {
                    path.moveTo(pointX, pointY);
                    continue;
                }
                path.lineTo(pointX, pointY);
            }
            path.closePath();
            I.A(context, result, path, this.\u00f8, TUIManager.getStrokeByType(this.\u011f));
            if (i2 == this.\u00fc || !this.\u0118) continue;
            for (int m2 = 1; m2 <= this.\u010d; ++m2) {
                path = new GeneralPath();
                for (int j5 = 0; j5 < size; ++j5) {
                    double ang = (this.\u010f * (double)j5 + this.\u0101) * \u00ff;
                    float pointX = (float)(this.\u00fa + (length + (double)m2 * minLength) * Math.cos(ang));
                    float pointY = (float)(this.\u00f9 + (length + (double)m2 * minLength) * Math.sin(ang));
                    if (j5 == 0) {
                        path.moveTo(pointX, pointY);
                        continue;
                    }
                    path.lineTo(pointX, pointY);
                }
                path.closePath();
                I.A(context, result, path, this.\u0109, TUIManager.getStrokeByType(this.\u0104));
            }
        }
    }

    private void A(SVGContext context, StringBuffer result) {
        double r = this.\u0100.getWidth() / 2.0;
        int size = this.\u0120.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Stroke strokeOfAxis = TUIManager.getStrokeByType(this.\u011d);
            double angle = ((double)i2 * this.\u010f + this.\u0101) * \u00ff;
            Point2D.Double point = new Point2D.Double(this.\u00fa + r * Math.cos(angle), this.\u00f9 + r * Math.sin(angle));
            String item = "";
            Object obj = this.\u0120.get(i2);
            item = obj instanceof RadarAxis ? ((RadarAxis)obj).getText() : obj.toString();
            if (this.\u010b) {
                Line2D.Double line = new Line2D.Double(new Point2D.Double(this.\u00fa, this.\u00f9), point);
                I.A(context, result, line, this.\u0114, strokeOfAxis);
                this.paintAxisInflexion(context, result, strokeOfAxis, this.\u0114, point, i2, item);
            }
            if (!this.\u0117) continue;
            double labelPointX = this.\u00fa + (r + 2.0) * Math.cos(angle);
            double labelPointY = this.\u00f9 + (r + 2.0) * Math.sin(angle);
            I.A(context, result, item, this.\u0113, this.\u0102, (int)labelPointX, (int)labelPointY, this.getAxisTextPosition((double)i2 * this.\u010f + this.\u0101));
        }
    }

    protected int getAxisTextPosition(double angle) {
        angle = (angle % 360.0 + 360.0) % 360.0;
        int position = 1;
        if (angle == 0.0) {
            position = 5;
        }
        if (angle == 180.0) {
            position = 4;
        }
        if (angle == 90.0) {
            position = 3;
        }
        if (angle == 270.0) {
            position = 2;
        }
        if (angle > 270.0 && angle < 360.0) {
            position = 7;
        }
        if (angle > 180.0 && angle < 270.0) {
            position = 6;
        }
        if (angle > 90.0 && angle < 180.0) {
            position = 8;
        }
        if (angle > 0.0 && angle < 90.0) {
            position = 9;
        }
        return position;
    }

    protected int getAxisScaleTextPosition(double angle) {
        angle = (angle % 360.0 + 360.0) % 360.0;
        int position = 1;
        if (angle == 0.0) {
            position = 3;
        }
        if (angle == 180.0) {
            position = 8;
        }
        if (angle == 90.0) {
            position = 5;
        }
        if (angle == 270.0) {
            position = 5;
        }
        if (angle > 270.0 && angle < 360.0) {
            position = 9;
        }
        if (angle > 180.0 && angle < 270.0) {
            position = 8;
        }
        if (angle > 90.0 && angle < 180.0) {
            position = 6;
        }
        if (angle > 0.0 && angle < 90.0) {
            position = 7;
        }
        return position;
    }

    protected void paintAxisInflexion(SVGContext context, StringBuffer result, Stroke stroke, Color color, Point2D.Double point, int index, String item) {
        Shape shape;
        if (!this.\u0112) {
            return;
        }
        int w = 2;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 1;
        }
        Rectangle bounds = new Rectangle((int)(point.x - (double)w), (int)(point.y - (double)w), w * 2 + 1, w * 2 + 1);
        if (this.\u011a == 2) {
            if (bounds.width % 2 == 1) {
                ++bounds.width;
            }
            if (bounds.height % 2 == 1) {
                ++bounds.height;
            }
        }
        if ((shape = this.getInflexionShape(this.\u011a, bounds)) != null) {
            I.A(context, result, shape, color);
        }
    }

    protected Shape getInflexionShape(int inflexionStyle, Rectangle bounds) {
        Shape shape = null;
        if (inflexionStyle == 1) {
            int x = bounds.x;
            int y = bounds.y;
            int width = bounds.width;
            int height = bounds.height;
            shape = new Area(new Ellipse2D.Float(x, y, width, height));
        } else if (inflexionStyle == 2) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height / 2);
            path.lineTo(bounds.x + bounds.width / 2, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height / 2);
            path.closePath();
            shape = new Area(path);
        } else if (inflexionStyle == 3) {
            shape = bounds;
        } else if (inflexionStyle == 4) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height);
            path.closePath();
            shape = new Area(path);
        }
        return shape;
    }

    public int getInflexionStyle(Element element) {
        Object value = element.getClientProperty("chart.inflexion.style");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return this.\u011b;
    }

    protected Rectangle getInflexionBounds(Element element, Point point) {
        Dimension inflexionSize = this.getInflexionSize(element, point);
        int w = inflexionSize.width;
        int h2 = inflexionSize.height;
        Rectangle bounds = new Rectangle(point.x - w, point.y - h2, w * 2 + 1, h2 * 2 + 1);
        if (this.getInflexionStyle(element) == 2) {
            if (bounds.width % 2 == 1) {
                ++bounds.width;
            }
            if (bounds.height % 2 == 1) {
                ++bounds.height;
            }
        }
        return bounds;
    }

    protected Dimension getInflexionSize(Element element, Point point) {
        Stroke stroke = this.getStroke(element);
        int w = 3;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 2;
        }
        return new Dimension(w, w);
    }

    private void B(SVGContext context, StringBuffer result) {
        if (this.\u00fc < 1 || !this.\u0105) {
            return;
        }
        double r = this.\u0100.getWidth() / 2.0;
        int size = this.\u0120.size();
        double minr = r / (double)this.\u00fc;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!this.isScaleVisible(i2)) continue;
            double angle = ((double)i2 * this.\u010f + this.\u0101) * \u00ff;
            Object obj = this.\u0120.get(i2);
            int scaleTextposition = this.getAxisScaleTextPosition((double)i2 * this.\u010f + this.\u0101);
            for (int j2 = 1; j2 <= this.\u00fc; ++j2) {
                String val = this.getScaleValueText(obj, j2);
                if (val == null) continue;
                int x = (int)(this.\u00fa + minr * (double)j2 * Math.cos(angle));
                int y = (int)(this.\u00f9 + minr * (double)j2 * Math.sin(angle));
                I.A(context, result, val, this.\u0107, this.\u0106, x, y, scaleTextposition);
            }
        }
    }

    protected boolean isScaleVisible(int index) {
        return true;
    }

    protected String getScaleValueText(Object obj, int index) {
        RadarAxis raxis;
        double axisMin = 0.0;
        double axisMax = 0.0;
        if (obj instanceof RadarAxis) {
            raxis = (RadarAxis)obj;
            if (!raxis.isAxisTextVisible()) {
                return null;
            }
        } else {
            double avgValue = this.\u0115 / (double)this.\u00fc;
            String value = this.getFormat().format(avgValue * (double)index + this.\u010a);
            return value;
        }
        axisMin = raxis.getMinValue();
        axisMax = raxis.getMaxValue();
        double avgValue = axisMax == axisMin ? axisMax : (axisMax - axisMin) / (double)this.\u00fc;
        String value = this.getFormat().format(avgValue * (double)index + axisMin);
        return value;
    }

    private void C(SVGContext context, StringBuffer result) {
        Element element;
        if (this.publishedElements.size() < 1) {
            return;
        }
        Iterator it = this.publishedElements.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (element.isSelected()) continue;
            this.A(context, result, element);
        }
        it = this.publishedElements.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (!element.isSelected()) continue;
            this.A(context, result, element);
        }
    }

    private void A(SVGContext context, StringBuffer result, Element element) {
        List list = this.getValues(element);
        double r = this.\u0100.getWidth() / 2.0;
        GeneralPath path = new GeneralPath();
        int size = this.\u0120.size();
        double fillminr = 0.0;
        Element lastSelectedElement = this.box.getLastSelectedElement();
        int alpha = this.\u0108;
        if (lastSelectedElement != null && !element.isSelected()) {
            alpha = this.\u0122;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            Object axis = this.\u0120.get(i2);
            double axisMinValue = this.\u010a;
            double axisMaxValue = this.\u0111;
            double axisRange = this.\u0115;
            if (axis instanceof RadarAxis) {
                RadarAxis radarAxis = (RadarAxis)axis;
                axisMinValue = radarAxis.getMinValue();
                axisMaxValue = radarAxis.getMaxValue();
                axisRange = Math.abs(axisMaxValue - axisMinValue);
            }
            Point2D.Double point = null;
            Double value = null;
            if (i2 >= list.size()) {
                point = new Point2D.Double(this.\u00fa, this.\u00f9);
            } else {
                value = (Double)list.get(i2);
                double ang = ((double)i2 * this.\u010f + this.\u0101) * \u00ff;
                if (value != null) {
                    double val = value;
                    if (val < axisMinValue) {
                        point = new Point2D.Double(this.\u00fa, this.\u00f9);
                    } else if (val > axisMaxValue) {
                        point = new Point2D.Double(this.\u00fa + r * Math.cos(ang), this.\u00f9 + r * Math.sin(ang));
                    } else {
                        double len = r * (val - axisMinValue) / axisRange;
                        point = new Point2D.Double(this.\u00fa + len * Math.cos(ang), this.\u00f9 + len * Math.sin(ang));
                    }
                } else {
                    point = new Point2D.Double(this.\u00fa, this.\u00f9);
                }
            }
            if (fillminr < Math.abs(point.x - this.\u00fa)) {
                fillminr = Math.abs(point.x - this.\u00fa);
            }
            if (fillminr < Math.abs(point.y - this.\u00f9)) {
                fillminr = Math.abs(point.y - this.\u00f9);
            }
            if (this.isInflexionVisible(element)) {
                this.paintInflexion(context, result, element, new Point((int)point.x, (int)point.y), value, i2);
            }
            if (i2 == 0) {
                path.moveTo((float)point.x, (float)point.y);
                continue;
            }
            path.lineTo((float)point.x, (float)point.y);
        }
        path.closePath();
        Shape shape = this.getStroke(element).createStrokedShape(path);
        if (this.isAreaFill(element)) {
            try {
                if (this.\u0103) {
                    Color alcolor = new Color(this.\u00fb.getRed(), this.\u00fb.getGreen(), this.\u00fb.getBlue(), alpha);
                    String gradientID = this.getGradientID(context, 10, alcolor, this.getColor(element));
                    I.A(context, result, path, (Object)gradientID, null, (Object)"0", 0.5f, 0.0, null);
                } else {
                    I.A(context, result, path, (Object)this.getColor(element), null, (Object)"1", 0.5f, 0.0, null);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (this.isLineVisible(element)) {
            I.A(context, result, shape, this.getColor(element), shape);
        }
    }

    protected boolean isInflexionVisible(Element element) {
        return this.\u00fe;
    }

    protected boolean isLineVisible(Element element) {
        return this.\u00fd;
    }

    protected boolean isAreaFill(Element element) {
        return this.\u0116;
    }

    protected void paintInflexion(SVGContext context, StringBuffer result, Element element, Point point, Double value, int i2) {
        Rectangle bounds;
        int inflexionStyle = this.getInflexionStyle(element);
        Shape shape = this.getInflexionShape(inflexionStyle, bounds = this.getInflexionBounds(element, point));
        if (shape != null) {
            Color color = this.getColor(element);
            I.A(context, result, shape, color);
        }
    }

    public void addAxisText(Object itemText) {
        if (this.\u0120.contains(itemText)) {
            return;
        }
        this.\u0120.add(itemText);
        this.\u010f = this.\u0120.size() > 0 ? 360.0 / (double)this.\u0120.size() : 360.0;
    }

    public void addAxis(Object radarAxis) {
        if (this.\u0120.contains(radarAxis)) {
            return;
        }
        this.\u0120.add(radarAxis);
        this.\u010f = this.\u0120.size() > 0 ? 360.0 / (double)this.\u0120.size() : 360.0;
    }

    public void removeAxisText(Object itemText) {
        if (!this.\u0120.contains(itemText)) {
            return;
        }
        this.\u0120.remove(itemText);
        this.\u010f = this.\u0120.size() > 0 ? 360.0 / (double)this.\u0120.size() : 360.0;
    }

    public void removeAxisText(int itemIndex) {
        if (itemIndex < 0 || itemIndex >= this.\u0120.size()) {
            return;
        }
        this.\u0120.remove(itemIndex);
        this.\u010f = this.\u0120.size() > 0 ? 360.0 / (double)this.\u0120.size() : 360.0;
    }

    public Font getAxisTextFont() {
        return this.\u0102;
    }

    public void setAxisTextFont(Font axisTextFont) {
        this.\u0102 = axisTextFont;
    }

    public Color getAxisTextColor() {
        return this.\u0113;
    }

    public void setAxisTextColor(Color axisTextColor) {
        this.\u0113 = axisTextColor;
    }

    public Color getAxisColor() {
        return this.\u0114;
    }

    public void setAxisColor(Color axisColor) {
        this.\u0114 = axisColor;
    }

    public String getAxisStroke() {
        return this.\u011d;
    }

    public void setAxisStroke(String axisStroke) {
        this.\u011d = axisStroke;
    }

    public double getAxisStartAngle() {
        return this.\u0101;
    }

    public void setAxisStartAngle(double axisStartAngle) {
        this.\u0101 = axisStartAngle;
    }

    public int getRingStyle() {
        return this.\u011c;
    }

    public void setRingStyle(int ringStyle) {
        this.\u011c = ringStyle;
    }

    public Color getRingMajorColor() {
        return this.\u00f8;
    }

    public void setRingMajorColor(Color ringMajorColor) {
        this.\u00f8 = ringMajorColor;
    }

    public String getRingMajorStroke() {
        return this.\u011f;
    }

    public void setRingMajorStroke(String ringMajorStroke) {
        this.\u011f = ringMajorStroke;
    }

    public boolean isRingMinVisible() {
        return this.\u0118;
    }

    public void setRingMinVisible(boolean ringMinVisible) {
        this.\u0118 = ringMinVisible;
    }

    public Color getRingMinColor() {
        return this.\u0109;
    }

    public void setRingMinColor(Color ringMinColor) {
        this.\u0109 = ringMinColor;
    }

    public String getRingMinStroke() {
        return this.\u0104;
    }

    public void setRingMinStroke(String ringMinStroke) {
        this.\u0104 = ringMinStroke;
    }

    public double getScaleMaxValue() {
        return this.\u0111;
    }

    public void setScaleMaxValue(double scaleMaxValue) {
        this.\u0111 = scaleMaxValue;
    }

    public double getScaleMinValue() {
        return this.\u010a;
    }

    public void setScaleMinValue(double scaleMinValue) {
        this.\u010a = scaleMinValue;
    }

    public boolean isScaleMajorTextVisible() {
        return this.\u0105;
    }

    public void setScaleMajorTextVisible(boolean scaleMajorTextVisible) {
        this.\u0105 = scaleMajorTextVisible;
    }

    public Font getScaleMajorTextFont() {
        return this.\u0106;
    }

    public void setScaleMajorTextFont(Font scaleMajorTextFont) {
        this.\u0106 = scaleMajorTextFont;
    }

    public Color getScaleMajorTextColor() {
        return this.\u0107;
    }

    public void setScaleMajorTextColor(Color scaleMajorTextColor) {
        this.\u0107 = scaleMajorTextColor;
    }

    public int getScaleMajorCount() {
        return this.\u00fc;
    }

    public void setScaleMajorCount(int scaleMajorCount) {
        this.\u00fc = scaleMajorCount < 0 ? 0 : scaleMajorCount;
    }

    public int getScaleMinCount() {
        return this.\u010d;
    }

    public void setScaleMinCount(int scaleMinCount) {
        this.\u010d = scaleMinCount < 0 ? 0 : scaleMinCount;
    }

    public List getAxisList() {
        return this.\u0120;
    }

    public Rectangle getDrawBound() {
        return this.\u0100;
    }

    public boolean isRingVisible() {
        return this.\u0121;
    }

    public void setRingVisible(boolean ringVisible) {
        this.\u0121 = ringVisible;
    }

    public boolean isAxisTextVisible() {
        return this.\u0117;
    }

    public void setAxisTextVisible(boolean axisTextVisible) {
        this.\u0117 = axisTextVisible;
    }

    public boolean isAxisVisible() {
        return this.\u010b;
    }

    public void setAxisVisible(boolean axisVisible) {
        this.\u010b = axisVisible;
    }

    public boolean isRadarFill() {
        return this.\u0110;
    }

    public void setRadarFill(boolean radarFill) {
        this.\u0110 = radarFill;
    }

    public Color getRadarFillColor() {
        return this.\u010e;
    }

    public void setRadarFillColor(Color radarFillColor) {
        this.\u010e = radarFillColor;
    }

    public boolean isRadarFillGradient() {
        return this.\u0119;
    }

    public void setRadarFillGradient(boolean radarFillGradient) {
        this.\u0119 = radarFillGradient;
    }

    public Color getRadarFillGradientColor() {
        return this.\u011e;
    }

    public void setRadarFillGradientColor(Color radarFillGradientColor) {
        this.\u011e = radarFillGradientColor;
    }

    public int getRadarFillGradientFactory() {
        return this.\u010c;
    }

    public void setRadarFillGradientFactory(int radarFillGradientFactory) {
        this.\u010c = radarFillGradientFactory;
    }

    public boolean isShapeFillGradient() {
        return this.\u0103;
    }

    public void setShapeFillGradient(boolean shapeFillGradient) {
        this.\u0103 = shapeFillGradient;
    }

    public Color getShapeFillGradientColor() {
        return this.\u00fb;
    }

    public void setShapeFillGradientColor(Color shapeFillGradientColor) {
        this.\u00fb = shapeFillGradientColor;
    }

    public int getAxisInflexionStyle() {
        return this.\u011a;
    }

    public void setAxisInflexionStyle(int axisInflexionStyle) {
        this.\u011a = axisInflexionStyle;
    }

    public boolean isAxisInflexionVisible() {
        return this.\u0112;
    }

    public void setAxisInflexionVisible(boolean axisInflexionVisible) {
        this.\u0112 = axisInflexionVisible;
    }

    public boolean isInflexionVisible() {
        return this.\u00fe;
    }

    public void setInflexionVisible(boolean inflexionVisible) {
        this.\u00fe = inflexionVisible;
    }

    public boolean isLineVisible() {
        return this.\u00fd;
    }

    public void setLineVisible(boolean lineVisible) {
        this.\u00fd = lineVisible;
    }

    public boolean isAreaFill() {
        return this.\u0116;
    }

    public void setAreaFill(boolean areaFill) {
        this.\u0116 = areaFill;
    }

    public int getInflexionStyle() {
        return this.\u011b;
    }

    public void setInflexionStyle(int inflexionStyle) {
        this.\u011b = inflexionStyle;
    }
}

