/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.list;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class BasicListModel
extends AbstractListModel {
    private Vector rowDatas;

    public BasicListModel() {
        this(null);
    }

    public BasicListModel(Vector rowDatas) {
        this.rowDatas = rowDatas != null ? rowDatas : new Vector();
    }

    public Vector getRowDatas() {
        return this.rowDatas;
    }

    public void setRowDatas(Vector rowDatas) {
        int size = this.rowDatas.size();
        this.rowDatas = rowDatas;
        this.fireContentsChanged(this, 0, size);
    }

    @Override
    public int getSize() {
        return this.rowDatas.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.rowDatas.elementAt(index);
    }

    public void copyInto(Object[] array) {
        this.rowDatas.copyInto(array);
    }

    public void trimToSize() {
        this.rowDatas.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.rowDatas.ensureCapacity(minCapacity);
    }

    public void setSize(int newSize) {
        int oldSize = this.rowDatas.size();
        this.rowDatas.setSize(newSize);
        if (oldSize > newSize) {
            this.fireIntervalRemoved(this, newSize, oldSize - 1);
        } else if (oldSize < newSize) {
            this.fireIntervalAdded(this, oldSize, newSize - 1);
        }
    }

    public int capacity() {
        return this.rowDatas.capacity();
    }

    public int size() {
        return this.rowDatas.size();
    }

    public boolean isEmpty() {
        return this.rowDatas.isEmpty();
    }

    public Enumeration elements() {
        return this.rowDatas.elements();
    }

    public boolean contains(Object element) {
        return this.rowDatas.contains(element);
    }

    public int indexOf(Object element) {
        return this.rowDatas.indexOf(element);
    }

    public int indexOf(Object element, int index) {
        return this.rowDatas.indexOf(element, index);
    }

    public int lastIndexOf(Object element) {
        return this.rowDatas.lastIndexOf(element);
    }

    public int lastIndexOf(Object element, int index) {
        return this.rowDatas.lastIndexOf(element, index);
    }

    public Object elementAt(int index) {
        return this.rowDatas.elementAt(index);
    }

    public Object firstElement() {
        return this.rowDatas.firstElement();
    }

    public Object lastElement() {
        return this.rowDatas.lastElement();
    }

    public void setElementAt(Object object, int index) {
        this.rowDatas.setElementAt(object, index);
        this.fireContentsChanged(this, index, index);
    }

    public void removeElementAt(int index) {
        this.rowDatas.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void insertElementAt(Object object, int index) {
        this.rowDatas.insertElementAt(object, index);
        this.fireIntervalAdded(this, index, index);
    }

    public void addElement(Object object) {
        int index = this.rowDatas.size();
        this.rowDatas.addElement(object);
        this.fireIntervalAdded(this, index, index);
    }

    public void addElements(List objects) {
        int index = this.rowDatas.size();
        this.rowDatas.addAll(objects);
        this.fireIntervalAdded(this, index, index);
    }

    public void addElements(List objects, int index) {
        this.rowDatas.addAll(index, objects);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean removeElement(Object object) {
        int index = this.indexOf(object);
        boolean value = this.rowDatas.removeElement(object);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return value;
    }

    public void removeAllElements() {
        int index = this.rowDatas.size() - 1;
        this.rowDatas.removeAllElements();
        if (index >= 0) {
            this.fireIntervalRemoved(this, 0, index);
        }
    }

    public void limitElements(int limitedElementCount, boolean isFromTop) {
        int rowCount = this.rowDatas.size();
        if (rowCount > limitedElementCount) {
            int deletedCount = rowCount - limitedElementCount;
            int[] deletedRows = new int[deletedCount];
            for (int i = 0; i < deletedCount; ++i) {
                deletedRows[i] = isFromTop ? i : rowCount - i - 1;
            }
            this.removeElements(deletedRows);
        }
    }

    public String toString() {
        return this.rowDatas.toString();
    }

    public Object[] toArray() {
        Object[] array = new Object[this.rowDatas.size()];
        this.rowDatas.copyInto(array);
        return array;
    }

    public Object get(int index) {
        return this.rowDatas.elementAt(index);
    }

    public Object set(int index, Object element) {
        Object object = this.rowDatas.elementAt(index);
        this.rowDatas.setElementAt(element, index);
        this.fireContentsChanged(this, index, index);
        return object;
    }

    public void add(int index, Object element) {
        this.rowDatas.insertElementAt(element, index);
        this.fireIntervalAdded(this, index, index);
    }

    public Object remove(int index) {
        Object object = this.rowDatas.elementAt(index);
        this.rowDatas.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
        return object;
    }

    public void removeElements(int[] indexes) {
        ArrayList elements = new ArrayList();
        for (int i = 0; i < indexes.length; ++i) {
            int row = indexes[i];
            Object element = this.rowDatas.elementAt(row);
            elements.add(element);
        }
        this.removeElements(elements);
    }

    public void removeElements(List elements) {
        int index = this.rowDatas.size() - 1;
        this.rowDatas.removeAll(elements);
        if (index >= 0) {
            this.fireIntervalRemoved(this, 0, index);
        }
    }

    public void clear() {
        int index = this.rowDatas.size() - 1;
        this.rowDatas.removeAllElements();
        if (index >= 0) {
            this.fireIntervalRemoved(this, 0, index);
        }
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must be <= toIndex");
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            this.rowDatas.removeElementAt(i);
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }

    public void moveUp(int index) {
        if (index <= 0) {
            return;
        }
        Object object = this.rowDatas.elementAt(index);
        this.rowDatas.remove(index);
        this.rowDatas.add(index - 1, object);
        this.fireContentsChanged(this, index - 1, index);
    }

    public void moveDown(int index) {
        if (index >= this.rowDatas.size() - 1) {
            return;
        }
        Object object = this.rowDatas.elementAt(index);
        this.rowDatas.remove(index);
        this.rowDatas.add(index + 1, object);
        this.fireContentsChanged(this, index, index + 1);
    }
}

