/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.textfield;

import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.swing.textfield.number.JNumberTextField;
import com.nepxion.swing.tip.balloon.JBalloonTip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class JIPAddressTextField
extends JBasicTextField {
    private JNumberTextField ipAddressTextField1;
    private JNumberTextField ipAddressTextField2;
    private JNumberTextField ipAddressTextField3;
    private JNumberTextField ipAddressTextField4;
    private int align = 2;

    public JIPAddressTextField() {
        this(2);
    }

    public JIPAddressTextField(int align) {
        this(null, align);
    }

    public JIPAddressTextField(String ipAddress) {
        this(ipAddress, 2);
    }

    public JIPAddressTextField(String ipAddress, int align) {
        this.align = align;
        this.ipAddressTextField1 = this.createTextField();
        JLabel dotLabel1 = this.createLabel();
        this.ipAddressTextField2 = this.createTextField();
        JLabel dotLabel2 = this.createLabel();
        this.ipAddressTextField3 = this.createTextField();
        JLabel dotLabel3 = this.createLabel();
        this.ipAddressTextField4 = this.createTextField();
        this.setLayout(new BoxLayout(this, 0));
        this.setFocusable(false);
        if (align != 2) {
            this.add(Box.createHorizontalStrut(20));
        }
        this.add(this.ipAddressTextField1);
        this.add(dotLabel1);
        this.add(this.ipAddressTextField2);
        this.add(dotLabel2);
        this.add(this.ipAddressTextField3);
        this.add(dotLabel3);
        this.add(this.ipAddressTextField4);
        if (align != 2) {
            this.add(Box.createHorizontalStrut(20));
        }
        this.removeMouseListener(this.getPopupMenuAdapter());
        this.setIPAddress(ipAddress);
    }

    private JNumberTextField createTextField() {
        final JNumberTextField ipAddressTextField = new JNumberTextField(3, 0, 0.0, 255.0){

            @Override
            public boolean exclude(String value) {
                if (value.equals(".")) {
                    this.transferFocus();
                    return true;
                }
                return false;
            }
        };
        ipAddressTextField.setHorizontalAlignment(4);
        ipAddressTextField.setBorder(null);
        ipAddressTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                char c = e.getKeyChar();
                boolean isDigit = Character.isDigit(c);
                JBalloonTip balloonTip = ipAddressTextField.getBalloonTip();
                int length = ipAddressTextField.getText().length();
                if (!balloonTip.isVisible() && isDigit && length == 3) {
                    ipAddressTextField.transferFocus();
                }
            }
        });
        if (this.align == 2) {
            DimensionManager.setDimension(ipAddressTextField, new Dimension(30, this.getPreferredSize().height));
        }
        return ipAddressTextField;
    }

    private JLabel createLabel() {
        JLabel label = new JLabel(".");
        label.setPreferredSize(new Dimension(2, this.getPreferredSize().height));
        return label;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.ipAddressTextField1 != null && this.ipAddressTextField2 != null && this.ipAddressTextField3 != null && this.ipAddressTextField4 != null) {
            this.ipAddressTextField1.setEnabled(enabled);
            this.ipAddressTextField2.setEnabled(enabled);
            this.ipAddressTextField3.setEnabled(enabled);
            this.ipAddressTextField4.setEnabled(enabled);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.ipAddressTextField1 != null && this.ipAddressTextField2 != null && this.ipAddressTextField3 != null && this.ipAddressTextField4 != null) {
            this.ipAddressTextField1.setEditable(editable);
            this.ipAddressTextField2.setEditable(editable);
            this.ipAddressTextField3.setEditable(editable);
            this.ipAddressTextField4.setEditable(editable);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.ipAddressTextField1 != null && this.ipAddressTextField2 != null && this.ipAddressTextField3 != null && this.ipAddressTextField4 != null) {
            this.ipAddressTextField1.setBackground(bg);
            this.ipAddressTextField2.setBackground(bg);
            this.ipAddressTextField3.setBackground(bg);
            this.ipAddressTextField4.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.ipAddressTextField1 != null && this.ipAddressTextField2 != null && this.ipAddressTextField3 != null && this.ipAddressTextField4 != null) {
            this.ipAddressTextField1.setForeground(fg);
            this.ipAddressTextField2.setForeground(fg);
            this.ipAddressTextField3.setForeground(fg);
            this.ipAddressTextField4.setForeground(fg);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.ipAddressTextField1 != null && this.ipAddressTextField2 != null && this.ipAddressTextField3 != null && this.ipAddressTextField4 != null) {
            this.ipAddressTextField1.setFont(f);
            this.ipAddressTextField2.setFont(f);
            this.ipAddressTextField3.setFont(f);
            this.ipAddressTextField4.setFont(f);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.ipAddressTextField1 != null && this.ipAddressTextField2 != null && this.ipAddressTextField3 != null && this.ipAddressTextField4 != null) {
            this.ipAddressTextField1.setOpaque(isOpaque);
            this.ipAddressTextField2.setOpaque(isOpaque);
            this.ipAddressTextField3.setOpaque(isOpaque);
            this.ipAddressTextField4.setOpaque(isOpaque);
        }
    }

    public void setIPAddress(String ipAddress) {
        if (ipAddress == null || ipAddress.equals("")) {
            this.ipAddressTextField1.setText("");
            this.ipAddressTextField2.setText("");
            this.ipAddressTextField3.setText("");
            this.ipAddressTextField4.setText("");
        } else {
            if (ipAddress.indexOf(".") == -1 || ipAddress.split("\\.").length != 4) {
                throw new IllegalArgumentException(SwingLocale.getString("invalid_ip_address") + " : " + ipAddress);
            }
            String[] ipAddresses = ipAddress.split("\\.");
            try {
                int number1 = Integer.parseInt(ipAddresses[0]);
                int number2 = Integer.parseInt(ipAddresses[1]);
                int number3 = Integer.parseInt(ipAddresses[2]);
                int number4 = Integer.parseInt(ipAddresses[3]);
                if (number1 < 0 || number1 > 255 || number2 < 0 || number2 > 255 || number3 < 0 || number3 > 255 || number4 < 0 || number4 > 255) {
                    throw new IllegalArgumentException(SwingLocale.getString("invalid_ip_address") + " : " + ipAddress);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(SwingLocale.getString("invalid_ip_address") + " : " + ipAddress);
            }
            this.ipAddressTextField1.setText(ipAddresses[0]);
            this.ipAddressTextField2.setText(ipAddresses[1]);
            this.ipAddressTextField3.setText(ipAddresses[2]);
            this.ipAddressTextField4.setText(ipAddresses[3]);
        }
    }

    public String getIPAddress() {
        String ipAddress1 = this.ipAddressTextField1.getText().trim();
        String ipAddress2 = this.ipAddressTextField2.getText().trim();
        String ipAddress3 = this.ipAddressTextField3.getText().trim();
        String ipAddress4 = this.ipAddressTextField4.getText().trim();
        if (ipAddress1.equals("") && ipAddress2.equals("") && ipAddress3.equals("") && ipAddress4.equals("")) {
            return "";
        }
        return (ipAddress1.equals("") ? "0" : ipAddress1) + "." + (ipAddress2.equals("") ? "0" : ipAddress2) + "." + (ipAddress3.equals("") ? "0" : ipAddress3) + "." + (ipAddress4.equals("") ? "0" : ipAddress4);
    }

    @Override
    public void setText(String text) {
        this.setIPAddress(text);
    }

    @Override
    public String getText() {
        return this.getIPAddress();
    }
}

