/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.ui.explorer;

import com.nepxion.swing.icon.paint.GeoCellIcon;
import com.nepxion.swing.icon.paint.SelectionIcon;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.renderer.table.DefaultTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.Border;

public class UIExplorerTableCellRenderer
extends DefaultTableCellRenderer {
    public UIExplorerTableCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setText("");
        this.setIcon(null);
        this.setBorder(null);
        if (value instanceof Boolean) {
            SelectionIcon icon = new SelectionIcon((Boolean)value);
            this.setIcon(icon);
        } else if (value instanceof Border) {
            CellBorder border = new CellBorder(table.getValueAt(row, 0).toString(), (Border)value);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), border));
        } else if (value instanceof Color) {
            GeoCellIcon icon = new GeoCellIcon(2, (Color)value);
            this.setIcon(icon);
        } else if (value instanceof Font) {
            this.setText(SwingLocale.getString("ui_sample_zh_cn") + " Sample");
            this.setFont((Font)value);
        } else if (value instanceof Icon) {
            CellIcon icon = new CellIcon(table.getValueAt(row, 0).toString(), (Icon)value);
            this.setIcon(icon);
        } else if (value instanceof Number || value instanceof String) {
            // empty if block
        }
        return this;
    }

    public class CellBorder
    implements Border {
        private Border border;
        private Component component;

        public CellBorder(String key, Border border) {
            this.border = border;
            try {
                int index = key.lastIndexOf(46);
                if (index != -1) {
                    String classname = "javax.swing.J" + key.substring(0, index);
                    this.component = (Component)Class.forName(classname).newInstance();
                }
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return this.border.isBorderOpaque();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this.component != null) {
                c = this.component;
            }
            return this.border.getBorderInsets(c);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.component != null) {
                c = this.component;
            }
            try {
                this.border.paintBorder(c, g, x, y, width, height);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public class CellIcon
    implements Icon {
        private Icon icon;
        private Component component;

        public CellIcon(String key, Icon icon) {
            this.icon = icon;
            try {
                int index = key.lastIndexOf(46);
                if (index != -1) {
                    String classname = "javax.swing.J" + key.substring(0, index);
                    this.component = (Component)Class.forName(classname).newInstance();
                }
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.component != null) {
                c = this.component;
            }
            try {
                this.icon.paintIcon(c, g, x, y);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

