/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tray;

import com.jeans.trayicon.TrayIconCallback;
import com.jeans.trayicon.TrayIconException;
import com.jeans.trayicon.TrayIconPopup;
import com.jeans.trayicon.WindowsTrayIcon;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.popupmenu.PopupMenuContext;
import com.nepxion.swing.topic.TopicContext;
import com.nepxion.swing.tray.AwtTrayIconPopupMenu;
import com.nepxion.swing.tray.ITrayIconPopupMenu;
import com.nepxion.swing.tray.SwingTrayIconPopupMenu;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class JTray {
    private WindowsTrayIcon trayIcon;
    private ITrayIconPopupMenu trayIconPopupMenu;
    private int showBalloonTimes = 0;
    private boolean alwaysShowBalloon = false;
    private JFrame frame;

    public JTray(JFrame frame) {
        this(frame, PopupMenuContext.getTitle());
    }

    public JTray(JFrame frame, String title) {
        this(frame, title, IconFactory.getSwingIcon("tray_java.png"), 16, 16);
    }

    public JTray(JFrame frame, ImageIcon imageIcon) {
        this(frame, PopupMenuContext.getTitle(), imageIcon);
    }

    public JTray(JFrame frame, String title, ImageIcon imageIcon) {
        this(frame, title, imageIcon, 16, 16);
    }

    public JTray(JFrame frame, ImageIcon imageIcon, int imageIconWidth, int imageIconHeight) {
        this(frame, PopupMenuContext.getTitle(), imageIcon, imageIconWidth, imageIconHeight);
    }

    public JTray(JFrame frame, String title, ImageIcon imageIcon, int imageIconWidth, int imageIconHeight) {
        this.frame = frame;
        this.frame.addWindowListener(new TrayWindowListener());
        WindowsTrayIcon.initTrayIcon((String)frame.getTitle());
        try {
            this.trayIcon = new WindowsTrayIcon(imageIcon.getImage(), imageIconWidth, imageIconHeight);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (TrayIconException e) {
            e.printStackTrace();
        }
        this.trayIcon.setToolTipText(frame.getTitle());
        this.trayIcon.addMouseListener((MouseListener)new TrayIconMouseListener());
        if (System.getProperty("java.version").indexOf("1.6.0") > -1) {
            this.trayIconPopupMenu = new AwtTrayIconPopupMenu(this);
            this.trayIcon.setPopup((TrayIconPopup)((AwtTrayIconPopupMenu)this.trayIconPopupMenu));
        } else {
            this.trayIconPopupMenu = new SwingTrayIconPopupMenu(this, title);
            ((SwingTrayIconPopupMenu)this.trayIconPopupMenu).setTrayIcon(this.trayIcon);
        }
    }

    public WindowsTrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public ITrayIconPopupMenu getTrayIconPopupMenu() {
        return this.trayIconPopupMenu;
    }

    public void setVisible(boolean visible) {
        this.trayIcon.setVisible(visible);
    }

    public void setAlwaysShowBalloon(boolean alwaysShowBalloon) {
        this.alwaysShowBalloon = alwaysShowBalloon;
    }

    public void showBalloon() {
        if (this.alwaysShowBalloon) {
            this.showBalloon(SwingLocale.getString("tray_title"), this.frame.getTitle());
        } else if (this.showBalloonTimes == 0) {
            this.showBalloon(SwingLocale.getString("tray_title"), this.frame.getTitle());
            ++this.showBalloonTimes;
        }
    }

    public void showBalloon(String message, String title) {
        this.showBalloon(message, title, 10000, 1);
    }

    public void showBalloon(String message, String title, int timeout, int flag) {
        WindowsTrayIcon.enableUnicodeConversion((int)2, (boolean)true);
        try {
            this.trayIcon.showBalloon(title, message, timeout, flag);
        }
        catch (TrayIconException e) {
            e.printStackTrace();
        }
    }

    public void flash() {
        try {
            WindowsTrayIcon.flashWindow((Frame)this.frame);
        }
        catch (TrayIconException e) {
            e.printStackTrace();
        }
    }

    public void restore() {
        this.frame.setVisible(!this.frame.isVisible());
        this.trayIconPopupMenu.restore(this.frame.isVisible());
        if (!this.frame.isVisible()) {
            this.showBalloon();
        }
    }

    public void about() {
        Component topicComponent = TopicContext.getTopicComponent();
        if (topicComponent == null) {
            return;
        }
        topicComponent.setVisible(true);
    }

    public void exit() {
        WindowsTrayIcon.cleanUp();
        System.exit(0);
    }

    public class TrayWindowsMessageCallback
    implements TrayIconCallback {
        public int callback(int param) {
            return 4321;
        }
    }

    public class TrayWindowListener
    extends WindowAdapter {
        @Override
        public void windowIconified(WindowEvent e) {
            JTray.this.restore();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            JTray.this.exit();
        }
    }

    public class TrayIconMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() == 16) {
                JTray.this.restore();
            }
        }
    }

    public class TrayIconActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JTray.this.restore();
        }
    }
}

