/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import twaver.PixelFilter;

public class HSBPixelFilter
implements PixelFilter {
    public static float[] RGBtoHSB(int r, int g2, int b2, float[] hslvals) {
        float L2;
        float H2;
        float S2;
        float maxcolor;
        float B2;
        float G2;
        float R2;
        float mincolor;
        if (hslvals == null) {
            hslvals = new float[3];
        }
        if ((mincolor = Math.min(R2 = (float)r / 255.0f, Math.min(G2 = (float)g2 / 255.0f, B2 = (float)b2 / 255.0f))) == (maxcolor = Math.max(R2, Math.max(G2, B2)))) {
            S2 = 0.0f;
            H2 = 0.0f;
            L2 = mincolor;
        } else {
            float colordiff = maxcolor - mincolor;
            L2 = (maxcolor + mincolor) / 2.0f;
            S2 = L2 < 0.5f ? colordiff / (maxcolor + mincolor) : colordiff / (2.0f - maxcolor - mincolor);
            H2 = R2 == maxcolor ? (G2 - B2) / colordiff : (G2 == maxcolor ? 2.0f + (B2 - R2) / colordiff : 4.0f + (R2 - G2) / colordiff);
            if ((H2 /= 6.0f) < 0.0f) {
                H2 += 1.0f;
            }
        }
        hslvals[0] = H2;
        hslvals[1] = S2;
        hslvals[2] = L2;
        return hslvals;
    }

    public static int HSBtoRGB(float h2, float sl, float l2) {
        float v;
        float r = l2;
        float g2 = l2;
        float b2 = l2;
        float f2 = v = l2 <= 0.5f ? l2 * (1.0f + sl) : l2 + sl - l2 * sl;
        if (v > 0.0f) {
            float m2 = l2 + l2 - v;
            float sv = (v - m2) / v;
            h2 = (float)((double)h2 * 6.0);
            int sextant = (int)h2;
            float fract = h2 - (float)sextant;
            float vsf = v * sv * fract;
            float mid1 = m2 + vsf;
            float mid2 = v - vsf;
            switch (sextant) {
                case 0: {
                    r = v;
                    g2 = mid1;
                    b2 = m2;
                    break;
                }
                case 1: {
                    r = mid2;
                    g2 = v;
                    b2 = m2;
                    break;
                }
                case 2: {
                    r = m2;
                    g2 = v;
                    b2 = mid1;
                    break;
                }
                case 3: {
                    r = m2;
                    g2 = mid2;
                    b2 = v;
                    break;
                }
                case 4: {
                    r = mid1;
                    g2 = m2;
                    b2 = v;
                    break;
                }
                case 5: {
                    r = v;
                    g2 = m2;
                    b2 = mid2;
                }
            }
        }
        return new Color(r, g2, b2).getRGB();
    }

    public int filter(int pixel, Color filterColor) {
        int alpha = pixel >> 24 & 0xFF;
        if (alpha > 0) {
            int pixelR = pixel >> 16 & 0xFF;
            int pixelG = pixel >> 8 & 0xFF;
            int pixelB = pixel & 0xFF;
            float[] pixelHSB = HSBPixelFilter.RGBtoHSB(pixelR, pixelG, pixelB, null);
            float hue = pixelHSB[0];
            float saturation = pixelHSB[1];
            float brightness = pixelHSB[2];
            int filterColorR = filterColor.getRed();
            int filterColorG = filterColor.getGreen();
            int filterColorB = filterColor.getBlue();
            float[] filterColorHSB = HSBPixelFilter.RGBtoHSB(filterColorR, filterColorG, filterColorB, null);
            hue = filterColorHSB[0];
            saturation = filterColorHSB[1];
            return HSBPixelFilter.HSBtoRGB(hue, saturation, brightness);
        }
        return 0;
    }
}

