/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import java.awt.Dimension;
import y.base.Node;
import y.layout.CanonicMultiStageLayouter;
import y.layout.OrientationLayouter;
import y.layout.tree.ARTreeLayouter;
import y.layout.tree.BalloonLayouter;
import y.layout.tree.HVTreeLayouter;
import y.layout.tree.TreeLayouter;
import y.module.LayoutModule;
import y.option.OptionHandler;
import y.util.DataProviderAdapter;
import y.view.Graph2D;

public class TreeLayoutModule
extends LayoutModule {
    private static final String ap = "LAYOUT_STYLE";
    private static final String ah = "PREFERRED_CHILD_WEDGE";
    private static final String as = "DIRECTED_ROOT";
    private static final String a3 = "LEFT_TO_RIGHT";
    private static final String bh = "ALLOW_OVERLAPS";
    private static final String an = "GENERAL";
    private static final String bb = "ROLAND_WIESE";
    private static final String aj = "COMPACTNESS_FACTOR";
    private static final String ar = "MINIMAL_NODE_DISTANCE";
    private static final String am = "ACT_ON_SELECTION_ONLY";
    private static final String ao = "BOTTOM_TO_TOP";
    private static final String at = "BALLOON";
    private static final String a5 = "MINIMAL_LAYER_DISTANCE";
    private static final String al = "ORIENTATION";
    private static final String au = "PREFERRED_ROOT_WEDGE";
    private static final String av = "RIGHT_TO_LEFT";
    private static final String a1 = "HV";
    private static final String bj = "VERTICAL_SPACE";
    private static final String bi = "AR";
    private static final String a8 = "HORIZONTAL_SPACE";
    private static final String bc = "ORTHOGONAL";
    private static final String ai = "PLAIN";
    private static final String a7 = "TREE";
    private static final String bg = "TOP_TO_BOTTOM";
    private static final String ag = "MINIMAL_EDGE_LENGTH";
    private static final String ax = "ROOT_NODE_POLICY";
    private static final String a6 = "CENTER_ROOT";
    private static final String a0 = "WEIGHTED_CENTER_ROOT";
    private static final String az = "BEND_DISTANCE";
    private static final String a2 = "ASPECT_RATIO";
    private static final String ba = "USE_VIEW_ASPECT_RATIO";
    private static final String aw = "DIRECTED";
    private static final String bd = "ORTHOGONAL_EDGE_ROUTING";
    private static final String[] a9 = new String[]{"DIRECTED", "BALLOON", "HV", "AR"};
    private static final String[] ak = new String[]{"TOP_TO_BOTTOM", "LEFT_TO_RIGHT", "BOTTOM_TO_TOP", "RIGHT_TO_LEFT"};
    private static final String[] af = new String[]{"DIRECTED_ROOT", "CENTER_ROOT", "WEIGHTED_CENTER_ROOT"};
    private static final String be = "PORT_STYLE";
    private static final String ay = "NODE_CENTER";
    private static final String bf = "BORDER_CENTER";
    private static final String a4 = "BORDER_DISTRIBUTED";
    private static final String[] aq = new String[]{"NODE_CENTER", "BORDER_CENTER", "BORDER_DISTRIBUTED"};

    public TreeLayoutModule() {
        super(a7, "Roland Wiese", "A layouter for tree structures");
    }

    public OptionHandler createOptionHandler() {
        TreeLayouter treeLayouter = new TreeLayouter();
        BalloonLayouter balloonLayouter = new BalloonLayouter();
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.useSection(an);
        optionHandler.addEnum(ap, a9, 0);
        optionHandler.addBool(am, false);
        optionHandler.useSection(aw);
        optionHandler.addInt(ar, (int)treeLayouter.getMinimalNodeDistance(), 1, 100);
        optionHandler.addInt(a5, (int)treeLayouter.getMinimalLayerDistance(), 10, 300);
        optionHandler.addEnum(al, ak, 0);
        optionHandler.addEnum(be, aq, 0);
        optionHandler.addBool(bd, false);
        optionHandler.useSection(at);
        optionHandler.addEnum(ax, af, 0);
        optionHandler.addInt(ah, balloonLayouter.getPreferredChildWedge(), 1, 359);
        optionHandler.addInt(au, balloonLayouter.getPreferredRootWedge(), 1, 359);
        optionHandler.addInt(ag, balloonLayouter.getMinimalEdgeLength(), 10, 400);
        optionHandler.addDouble(aj, balloonLayouter.getCompactnessFactor(), 0.1, 0.9);
        optionHandler.addBool(bh, balloonLayouter.getAllowOverlaps());
        optionHandler.useSection(a1);
        HVTreeLayouter hVTreeLayouter = new HVTreeLayouter();
        optionHandler.addInt(a8, (int)hVTreeLayouter.getHorizontalSpace());
        optionHandler.addInt(bj, (int)hVTreeLayouter.getVerticalSpace());
        ARTreeLayouter aRTreeLayouter = new ARTreeLayouter();
        optionHandler.useSection(bi);
        optionHandler.addInt(a8, (int)aRTreeLayouter.getHorizontalSpace());
        optionHandler.addInt(bj, (int)aRTreeLayouter.getVerticalSpace());
        optionHandler.addInt(az, (int)aRTreeLayouter.getBendDistance());
        optionHandler.addDouble(a2, aRTreeLayouter.getAspectRatio());
        optionHandler.addBool(ba, true);
        return optionHandler;
    }

    public void mainrun() {
        CanonicMultiStageLayouter canonicMultiStageLayouter = null;
        Graph2D graph2D = this.getGraph2D();
        OptionHandler optionHandler = this.getOptionHandler();
        String string = optionHandler.getString(ap);
        if (string.equals(aw)) {
            TreeLayouter treeLayouter = new TreeLayouter();
            treeLayouter.setMinimalNodeDistance(optionHandler.getInt(aw, ar));
            treeLayouter.setMinimalLayerDistance(optionHandler.getInt(aw, a5));
            OrientationLayouter orientationLayouter = (OrientationLayouter)treeLayouter.getOrientationLayouter();
            if (optionHandler.getString(al).equals(bg)) {
                orientationLayouter.setOrientation((byte)0);
            } else if (optionHandler.getString(al).equals(ao)) {
                orientationLayouter.setOrientation((byte)2);
            } else if (optionHandler.getString(al).equals(av)) {
                orientationLayouter.setOrientation((byte)3);
            } else {
                orientationLayouter.setOrientation((byte)1);
            }
            if (optionHandler.getBool(bd)) {
                treeLayouter.setLayoutStyle(1);
            } else {
                treeLayouter.setLayoutStyle(0);
            }
            if (optionHandler.getString(be).equals(ay)) {
                treeLayouter.setPortStyle(0);
            } else if (optionHandler.getString(be).equals(bf)) {
                treeLayouter.setPortStyle(1);
            } else if (optionHandler.getString(be).equals(a4)) {
                treeLayouter.setPortStyle(2);
            }
            canonicMultiStageLayouter = treeLayouter;
        } else if (string.equals(at)) {
            BalloonLayouter balloonLayouter = new BalloonLayouter();
            if (optionHandler.get(ax).equals(af[0])) {
                balloonLayouter.setRootNodePolicy((byte)0);
            } else if (optionHandler.get(ax).equals(af[1])) {
                balloonLayouter.setRootNodePolicy((byte)1);
            } else {
                balloonLayouter.setRootNodePolicy((byte)2);
            }
            balloonLayouter.setPreferredChildWedge(optionHandler.getInt(ah));
            balloonLayouter.setPreferredRootWedge(optionHandler.getInt(au));
            balloonLayouter.setMinimalEdgeLength(optionHandler.getInt(at, ag));
            balloonLayouter.setCompactnessFactor(optionHandler.getDouble(aj));
            balloonLayouter.setAllowOverlaps(optionHandler.getBool(bh));
            canonicMultiStageLayouter = balloonLayouter;
        } else if (string.equals(a1)) {
            HVTreeLayouter hVTreeLayouter = new HVTreeLayouter();
            DataProviderAdapter dataProviderAdapter = new DataProviderAdapter(){

                public Object get(Object object) {
                    if (TreeLayoutModule.this.getGraph2D().isSelected((Node)object)) {
                        return HVTreeLayouter.VERTICAL_SUBTREE;
                    }
                    return HVTreeLayouter.HORIZONTAL_SUBTREE;
                }
            };
            graph2D.addDataProvider(HVTreeLayouter.SUBTREE_ORIENTATION, dataProviderAdapter);
            hVTreeLayouter.setHorizontalSpace(optionHandler.getInt(a1, a8));
            hVTreeLayouter.setVerticalSpace(optionHandler.getInt(a1, bj));
            canonicMultiStageLayouter = hVTreeLayouter;
        } else if (string.equals(bi)) {
            ARTreeLayouter aRTreeLayouter = new ARTreeLayouter();
            DataProviderAdapter dataProviderAdapter = new DataProviderAdapter(){

                public Object get(Object object) {
                    if (TreeLayoutModule.this.getGraph2D().isSelected((Node)object)) {
                        return ARTreeLayouter.ROUTING_HORIZONTAL;
                    }
                    return ARTreeLayouter.ROUTING_VERTICAL;
                }
            };
            Dimension dimension = this.getGraph2DView().getSize();
            if (optionHandler.getBool(ba)) {
                aRTreeLayouter.setAspectRatio(dimension.getWidth() / dimension.getHeight());
            } else {
                aRTreeLayouter.setAspectRatio(optionHandler.getDouble(a2));
            }
            aRTreeLayouter.setHorizontalSpace(optionHandler.getInt(bi, a8));
            aRTreeLayouter.setVerticalSpace(optionHandler.getInt(bi, bj));
            aRTreeLayouter.setBendDistance(optionHandler.getInt(bi, az));
            graph2D.addDataProvider(ARTreeLayouter.ROUTING_POLICY, dataProviderAdapter);
            canonicMultiStageLayouter = aRTreeLayouter;
        }
        canonicMultiStageLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(am));
        this.launchLayouter(canonicMultiStageLayouter);
        graph2D.removeDataProvider(ARTreeLayouter.ROUTING_POLICY);
        graph2D.removeDataProvider(HVTreeLayouter.SUBTREE_ORIENTATION);
    }
}

