/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.chart.AbstractChart;
import twaver.chart.Marker;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.AbstractSVGScaleChart;

public abstract class AbstractScaleChart
extends AbstractChart {
    protected boolean xAxisVisible = TUIManager.getBoolean("tchart.xaxis.visible");
    protected Color xAxisFillColor = TUIManager.getColor("tchart.xaxis.fill.color");
    protected Color xAxisOutlineColor = TUIManager.getColor("tchart.xaxis.outline.color");
    protected Font xAxisTextFont = TUIManager.getFont("tchart.xaxis.text.font");
    protected Color xAxisTextColor = TUIManager.getColor("tchart.xaxis.text.color");
    protected String xAxisText = TUIManager.getString("tchart.xaxis.text");
    protected double xAxisValue = TUIManager.getDouble("tchart.xaxis.value");
    protected String xAxisStroke = TUIManager.getString("tchart.xaxis.stroke");
    protected boolean yAxisVisible = TUIManager.getBoolean("tchart.yaxis.visible");
    protected Color yAxisFillColor = TUIManager.getColor("tchart.yaxis.fill.color");
    protected Color yAxisOutlineColor = TUIManager.getColor("tchart.yaxis.outline.color");
    protected Font yAxisTextFont = TUIManager.getFont("tchart.yaxis.text.font");
    protected Color yAxisTextColor = TUIManager.getColor("tchart.yaxis.text.color");
    protected String yAxisText = TUIManager.getString("tchart.yaxis.text");
    protected String yAxisStroke = TUIManager.getString("tchart.yaxis.stroke");
    protected String yScaleLineStroke = TUIManager.getString("tchart.yscale.line.stroke");
    protected Color yScaleLineColor = TUIManager.getColor("tchart.yscale.line.color");
    protected boolean yScaleLineVisible = TUIManager.getBoolean("tchart.yscale.line.visible");
    protected int yScalePixelGap = TUIManager.getInt("tchart.yscale.pixel.gap");
    protected double yScaleValueGap = TUIManager.getDouble("tchart.yscale.value.gap");
    protected boolean yScaleMinTextVisible = TUIManager.getBoolean("tchart.yscale.min.text.visible");
    protected boolean yScaleTextVisible = TUIManager.getBoolean("tchart.yscale.text.visible");
    protected boolean yScaleTextInside = TUIManager.getBoolean("tchart.yscale.text.inside");
    protected NumberFormat yScaleTextFormat = TUIManager.getNumberFormat("tchart.yscale.text.format");
    protected Color yScaleTextColor = TUIManager.getColor("tchart.yscale.text.color");
    protected Font yScaleTextFont = TUIManager.getFont("tchart.yscale.text.font");
    protected Font xScaleTextFont = TUIManager.getFont("tchart.xscale.text.font");
    protected Color xScaleTextColor = TUIManager.getColor("tchart.xscale.text.color");
    protected boolean xScaleTextVisible = TUIManager.getBoolean("tchart.xscale.text.visible");
    protected int xScaleTextOrientation = TUIManager.getInt("tchart.xscale.text.orientation");
    protected List xScaleTextList = null;
    protected boolean yScaleValueGapAutoCalculate = TUIManager.getBoolean("tchart.yscale.value.gap.auto.calculate");
    protected boolean yscaleAutoCaculateFlag = false;
    protected int startIndex = 0;
    protected int endIndex = Integer.MAX_VALUE;
    protected int valueSpanCount = 1;
    protected int xScaleTextSpanCount = -1;
    protected List markers = null;
    boolean \u0454 = true;

    public AbstractScaleChart() {
    }

    public AbstractScaleChart(TDataBox box) {
        super(box, null, null);
    }

    public AbstractScaleChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor, null);
    }

    public AbstractScaleChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public AbstractScaleChart(List items) {
        super(items);
    }

    public AbstractScaleChart(List items, String title) {
        super(items, title);
    }

    public AbstractScaleChart(List items, String title, Color backgroundColor) {
        super(items, title, backgroundColor);
    }

    public AbstractScaleChart(List items, String title, Color backgroundColor, Color foregroundColor) {
        super(items, title, backgroundColor, foregroundColor);
    }

    protected double toValidHeight(double height) {
        if (this.upperLimit == -1.7976931348623157E308) {
            return height * 0.9;
        }
        return height;
    }

    protected int getXAxisExtraGap(Graphics2D g2d) {
        return 0;
    }

    public void paintChart(Graphics2D g2d, int width, int height) {
        int yText;
        double valueGap;
        double pixelGap;
        int yAxisTextGapTemp;
        boolean drawYAxisText;
        int xAxisTextGap;
        boolean drawXAxisText;
        g2d.setStroke(TWaverConst.BASIC_STROKE);
        boolean bl = drawXAxisText = this.xAxisText != null && !this.xAxisText.trim().equals("");
        if (drawXAxisText) {
            Dimension size = this.B(this.xAxisText, this.xAxisTextFont);
            xAxisTextGap = size.height + this.getXAxisExtraGap(g2d);
        } else {
            xAxisTextGap = this.getXAxisExtraGap(g2d);
        }
        int baseLine = height - this.yGap - xAxisTextGap - this.shadowOffset;
        int yAxisHeight = height - 2 * this.yGap - this.shadowOffset - xAxisTextGap;
        boolean bl2 = drawYAxisText = this.yAxisText != null && !this.yAxisText.trim().equals("");
        if (drawYAxisText) {
            Dimension size = this.B(3, this.yAxisText, this.yAxisTextFont);
            yAxisTextGapTemp = size.width;
        } else {
            yAxisTextGapTemp = 0;
        }
        if (this.yScaleValueGap > 0.0) {
            pixelGap = Math.max(this.yScaleValueGap / this.range * this.toValidHeight(yAxisHeight), 1.0);
            valueGap = this.yScaleValueGap;
        } else {
            pixelGap = Math.max(this.yScalePixelGap, 1);
            valueGap = this.range * (pixelGap / this.toValidHeight(yAxisHeight));
        }
        int maxYScaleTextGap = 0;
        if (this.yScaleTextVisible && this.yScaleTextColor != null && this.yScaleTextFont != null) {
            String text;
            double value;
            double lineCursor;
            if (!this.yScaleTextInside) {
                lineCursor = this.yScaleMinTextVisible ? 0.0 : pixelGap;
                value = this.min + (this.yScaleMinTextVisible ? 0.0 : valueGap);
                while (lineCursor <= (double)(yAxisHeight + 1)) {
                    text = this.getFormatedYScaleText(value);
                    Dimension size = this.B(text, this.yScaleTextFont);
                    if (size.width > maxYScaleTextGap) {
                        maxYScaleTextGap = size.width;
                    }
                    lineCursor += pixelGap;
                    value += valueGap;
                }
            }
            lineCursor = this.yScaleMinTextVisible ? 0.0 : pixelGap;
            value = this.min + (this.yScaleMinTextVisible ? 0.0 : valueGap);
            while (lineCursor <= (double)(yAxisHeight + 1)) {
                int y;
                int x;
                text = this.getFormatedYScaleText(value);
                if (this.yScaleTextInside) {
                    x = this.xGap + yAxisTextGapTemp + this.shadowOffset;
                    y = baseLine - (int)lineCursor;
                    this.A(g2d, text, this.yScaleTextColor, this.yScaleTextFont, x + this.textGap, y + 2, 7);
                } else {
                    x = this.xGap + yAxisTextGapTemp + maxYScaleTextGap;
                    y = baseLine - (int)lineCursor + this.shadowOffset;
                    this.A(g2d, text, this.yScaleTextColor, this.yScaleTextFont, x - this.textGap, y, 4);
                }
                lineCursor += pixelGap;
                value += valueGap;
            }
        }
        int yAxisTextGap = yAxisTextGapTemp + maxYScaleTextGap;
        int xAxisWidth = width - 2 * this.xGap - this.shadowOffset - yAxisTextGap;
        this.backgroundBounds.x = this.xGap + yAxisTextGap + this.shadowOffset;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = xAxisWidth;
        this.backgroundBounds.height = yAxisHeight;
        this.paintBackground(g2d);
        if (drawYAxisText) {
            int xText = this.xGap;
            yText = yAxisHeight / 2 + this.shadowOffset + this.yGap;
            this.A(g2d, 3, this.yAxisText, this.yAxisTextColor, this.yAxisTextFont, xText, yText, 5);
        }
        if (this.yAxisVisible) {
            GeneralPath yAxis = new GeneralPath();
            yAxis.moveTo(this.xGap + yAxisTextGap, this.yGap + this.shadowOffset);
            yAxis.lineTo(this.xGap + yAxisTextGap, height - this.yGap - xAxisTextGap);
            yAxis.lineTo(this.xGap + yAxisTextGap + this.shadowOffset, height - this.yGap - xAxisTextGap - this.shadowOffset);
            yAxis.lineTo(this.xGap + yAxisTextGap + this.shadowOffset, this.yGap);
            yAxis.closePath();
            if (this.yAxisFillColor != null && this.shadowOffset > 0) {
                g2d.setColor(this.yAxisFillColor);
                g2d.fill(yAxis);
            }
            if (this.yAxisStroke != null && this.yAxisOutlineColor != null) {
                g2d.setStroke(TUIManager.getStrokeByType(this.yAxisStroke));
                g2d.setColor(this.yAxisOutlineColor);
                g2d.draw(yAxis);
            }
        }
        if (this.yScaleLineVisible && this.yScaleLineStroke != null && this.yScaleLineColor != null) {
            g2d.setStroke(TUIManager.getStrokeByType(this.yScaleLineStroke));
            g2d.setColor(this.yScaleLineColor);
            for (double lineCursor = 0.0; lineCursor <= (double)(yAxisHeight + 1); lineCursor += pixelGap) {
                g2d.drawLine(this.xGap + yAxisTextGap + this.shadowOffset, baseLine - (int)lineCursor, width - this.xGap, baseLine - (int)lineCursor);
                if (this.shadowOffset <= 0) continue;
                g2d.drawLine(this.xGap + yAxisTextGap + this.shadowOffset, baseLine - (int)lineCursor, this.xGap + yAxisTextGap, baseLine - (int)lineCursor + this.shadowOffset);
            }
        }
        if (drawXAxisText) {
            int xText = xAxisWidth / 2 + this.xGap + yAxisTextGap;
            yText = height - this.yGap;
            this.A(g2d, this.xAxisText, this.xAxisTextColor, this.xAxisTextFont, xText, yText, 2);
        }
        if (this.xAxisVisible && this.\u0454) {
            this.paintXAxis(g2d, null, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
        }
        if (this.markers != null) {
            Iterator it = this.markers.iterator();
            while (it.hasNext()) {
                Marker marker = (Marker)it.next();
                this.paintXAxis(g2d, marker, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
            }
        }
        this.paintContent(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, baseLine, pixelGap, valueGap);
    }

    protected String getFormatedYScaleText(double value) {
        if (this.yScaleTextFormat != null) {
            String ret = this.yScaleTextFormat.format(value);
            if (this.unit != null) {
                ret = ret + this.unit;
            }
            return ret;
        }
        if (this.format != null) {
            String ret = this.format.format(value);
            if (this.unit != null) {
                ret = ret + this.unit;
            }
            return ret;
        }
        return value + (this.unit == null ? "" : this.unit);
    }

    protected void paintXAxis(Graphics2D g2d, Marker marker, int width, int height, int xTextGap, int yTextGap, double pixelGap, double valueGap) {
        Color outlineColor;
        Color fillColor;
        Stroke stroke;
        double value;
        if (marker == null) {
            value = this.xAxisValue == -1.7976931348623157E308 ? this.min : this.xAxisValue;
            stroke = TUIManager.getStrokeByType(this.xAxisStroke);
            fillColor = this.xAxisFillColor;
            outlineColor = this.xAxisOutlineColor;
        } else {
            value = marker.getValue();
            stroke = TUIManager.getStrokeByType(marker.getStroke());
            fillColor = null;
            outlineColor = marker.getColor();
        }
        int h2 = -((int)((value - this.min) / valueGap * pixelGap));
        GeneralPath xAxis = new GeneralPath();
        xAxis.moveTo(this.xGap + xTextGap, height - this.yGap - yTextGap + h2);
        xAxis.lineTo(this.xGap + xTextGap + this.shadowOffset, height - this.yGap - yTextGap - this.shadowOffset + h2);
        xAxis.lineTo(width - this.xGap, height - this.yGap - yTextGap - this.shadowOffset + h2);
        xAxis.lineTo(width - this.xGap - this.shadowOffset, height - this.yGap - yTextGap + h2);
        xAxis.closePath();
        if (fillColor != null && this.shadowOffset > 0) {
            g2d.setColor(fillColor);
            g2d.fill(xAxis);
        }
        if (outlineColor != null && stroke != null) {
            g2d.setColor(outlineColor);
            g2d.setStroke(stroke);
            g2d.draw(xAxis);
        }
        if (marker != null) {
            int x = this.xGap + xTextGap + this.shadowOffset + marker.getXOffset();
            int y = height - this.yGap - yTextGap - this.shadowOffset + h2 + marker.getYOffset() + 2;
            this.A(g2d, marker.getText(), marker.getTextColor(), marker.getTextFont(), x, y, 7);
        }
    }

    protected abstract void paintContent(Graphics2D var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, double var9, double var11);

    public Color getYScaleLineColor() {
        return this.yScaleLineColor;
    }

    public void setYScaleLineColor(Color yScaleLineColor) {
        this.yScaleLineColor = yScaleLineColor;
        this.chartPane.repaint();
    }

    public String getYScaleLineStroke() {
        return this.yScaleLineStroke;
    }

    public void setYScaleLineStroke(String yScaleLineStroke) {
        this.yScaleLineStroke = yScaleLineStroke;
        this.chartPane.repaint();
    }

    public boolean isYScaleLineVisible() {
        return this.yScaleLineVisible;
    }

    public void setYScaleLineVisible(boolean yScaleLineVisible) {
        this.yScaleLineVisible = yScaleLineVisible;
        this.chartPane.repaint();
    }

    public Color getYScaleTextColor() {
        return this.yScaleTextColor;
    }

    public void setYScaleTextColor(Color yScaleTextColor) {
        this.yScaleTextColor = yScaleTextColor;
        this.chartPane.repaint();
    }

    public Font getYScaleTextFont() {
        return this.yScaleTextFont;
    }

    public void setYScaleTextFont(Font yScaleTextFont) {
        this.yScaleTextFont = yScaleTextFont;
        this.chartPane.repaint();
    }

    public NumberFormat getYScaleTextFormat() {
        return this.yScaleTextFormat;
    }

    public void setYScaleTextFormat(NumberFormat yScaleTextFormat) {
        this.yScaleTextFormat = yScaleTextFormat;
        this.chartPane.repaint();
    }

    public boolean isYScaleTextVisible() {
        return this.yScaleTextVisible;
    }

    public void setYScaleTextVisible(boolean yScaleTextVisible) {
        this.yScaleTextVisible = yScaleTextVisible;
        this.chartPane.repaint();
    }

    public Color getXAxisFillColor() {
        return this.xAxisFillColor;
    }

    public void setXAxisFillColor(Color xAxisFillColor) {
        this.xAxisFillColor = xAxisFillColor;
        this.chartPane.repaint();
    }

    public Color getXAxisOutlineColor() {
        return this.xAxisOutlineColor;
    }

    public void setXAxisOutlineColor(Color xAxisOutlineColor) {
        this.xAxisOutlineColor = xAxisOutlineColor;
        this.chartPane.repaint();
    }

    public String getXAxisText() {
        return this.xAxisText;
    }

    public void setXAxisText(String xAxisText) {
        this.xAxisText = xAxisText;
        this.chartPane.repaint();
    }

    public Color getXAxisTextColor() {
        return this.xAxisTextColor;
    }

    public void setXAxisTextColor(Color xAxisTextColor) {
        this.xAxisTextColor = xAxisTextColor;
        this.chartPane.repaint();
    }

    public Font getXAxisTextFont() {
        return this.xAxisTextFont;
    }

    public void setXAxisTextFont(Font xAxisTextFont) {
        this.xAxisTextFont = xAxisTextFont;
        this.chartPane.repaint();
    }

    public Color getYAxisFillColor() {
        return this.yAxisFillColor;
    }

    public void setYAxisFillColor(Color yAxisFillColor) {
        this.yAxisFillColor = yAxisFillColor;
        this.chartPane.repaint();
    }

    public Color getYAxisOutlineColor() {
        return this.yAxisOutlineColor;
    }

    public void setYAxisOutlineColor(Color yAxisOutlineColor) {
        this.yAxisOutlineColor = yAxisOutlineColor;
        this.chartPane.repaint();
    }

    public String getYAxisText() {
        return this.yAxisText;
    }

    public void setYAxisText(String yAxisText) {
        this.yAxisText = yAxisText;
        this.chartPane.repaint();
    }

    public Color getYAxisTextColor() {
        return this.yAxisTextColor;
    }

    public void setYAxisTextColor(Color yAxisTextColor) {
        this.yAxisTextColor = yAxisTextColor;
        this.chartPane.repaint();
    }

    public Font getYAxisTextFont() {
        return this.yAxisTextFont;
    }

    public void setYAxisTextFont(Font axisTextFont) {
        this.yAxisTextFont = axisTextFont;
        this.chartPane.repaint();
    }

    public double getYScaleValueGap() {
        return this.yScaleValueGap;
    }

    public void setYScaleValueGap(double yScaleValueGap) {
        this.yScaleValueGap = yScaleValueGap;
        this.chartPane.repaint();
    }

    public int getYScalePixelGap() {
        return this.yScalePixelGap;
    }

    public void setYScalePixelGap(int yScalePixelGap) {
        this.yScalePixelGap = yScalePixelGap;
        this.chartPane.repaint();
    }

    public boolean isYScaleMinTextVisible() {
        return this.yScaleMinTextVisible;
    }

    public void setYScaleMinTextVisible(boolean yScaleMinTextVisible) {
        this.yScaleMinTextVisible = yScaleMinTextVisible;
        this.chartPane.repaint();
    }

    public double getXAxisValue() {
        return this.xAxisValue;
    }

    public void setXAxisValue(double xAxisValue) {
        this.xAxisValue = xAxisValue;
        this.chartPane.repaint();
    }

    public List getMarkers() {
        return this.markers;
    }

    public void setMarkers(List markers) {
        this.markers = markers;
        this.chartPane.repaint();
    }

    public void addMarker(double value, Color color) {
        Marker marker = new Marker(value, color);
        this.addMarker(marker);
    }

    public void removeMarker(Marker marker) {
        if (this.markers != null) {
            this.markers.remove(marker);
        }
    }

    public void addMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        this.markers.add(marker);
        this.chartPane.repaint();
    }

    public String getXAxisStroke() {
        return this.xAxisStroke;
    }

    public void setXAxisStroke(String xAxisStroke) {
        this.xAxisStroke = xAxisStroke;
        this.chartPane.repaint();
    }

    public String getYAxisStroke() {
        return this.yAxisStroke;
    }

    public void setYAxisStroke(String yAxisStroke) {
        this.yAxisStroke = yAxisStroke;
        this.chartPane.repaint();
    }

    public boolean getXAxisVisible() {
        return this.xAxisVisible;
    }

    public void setXAxisVisible(boolean xAxisVisible) {
        this.xAxisVisible = xAxisVisible;
        this.chartPane.repaint();
    }

    public boolean getYAxisVisible() {
        return this.yAxisVisible;
    }

    public void setYAxisVisible(boolean yAxisVisible) {
        this.yAxisVisible = yAxisVisible;
        this.chartPane.repaint();
    }

    public boolean isYScaleTextInside() {
        return this.yScaleTextInside;
    }

    public void setYScaleTextInside(boolean scaleTextInside) {
        this.yScaleTextInside = scaleTextInside;
        this.chartPane.repaint();
    }

    public Color getXScaleTextColor() {
        return this.xScaleTextColor;
    }

    public void setXScaleTextColor(Color scaleTextColor) {
        this.xScaleTextColor = scaleTextColor;
        this.chartPane.repaint();
    }

    public Font getXScaleTextFont() {
        return this.xScaleTextFont;
    }

    public void setXScaleTextFont(Font scaleTextFont) {
        this.xScaleTextFont = scaleTextFont;
        this.chartPane.repaint();
    }

    public int getXScaleTextOrientation() {
        return this.xScaleTextOrientation;
    }

    public void setXScaleTextOrientation(int scaleTextOrientation) {
        this.xScaleTextOrientation = scaleTextOrientation;
        this.chartPane.repaint();
    }

    public boolean isXScaleTextVisible() {
        return this.xScaleTextVisible;
    }

    public void setXScaleTextVisible(boolean scaleTextVisible) {
        this.xScaleTextVisible = scaleTextVisible;
        this.chartPane.repaint();
    }

    public List getXScaleTextList() {
        return this.xScaleTextList;
    }

    public void setXScaleTextList(List xScaleTextList) {
        this.xScaleTextList = xScaleTextList;
        this.publishData();
    }

    public void addXScaleText(String text) {
        if (this.xScaleTextList == null) {
            this.xScaleTextList = new ArrayList();
        }
        this.xScaleTextList.add(text);
        this.publishData();
    }

    public String getXScaleText(int index) {
        if (this.xScaleTextList == null) {
            return null;
        }
        if (this.xScaleTextList.size() <= index || index < 0) {
            return null;
        }
        return (String)this.xScaleTextList.get(index);
    }

    public String getToolTipText(Element element, double value, int index) {
        String valueText;
        if (!this.isEnableToolTipText()) {
            return null;
        }
        String text = this.getToolTipText(element);
        String xScaleText = this.getXScaleText(index);
        if (xScaleText != null) {
            text = text == null ? xScaleText : text + "<br>" + xScaleText;
        }
        if ((valueText = this.getFormatedText(element, value, index)) != null) {
            text = text == null ? valueText : text + "<br>" + valueText;
        }
        if (text != null) {
            if (text.indexOf("<html>") >= 0) {
                text = text.replaceAll("<html>", "");
                text = text.replaceAll("</html>", "");
            }
            text = "<html>" + text + "</html>";
        }
        return text;
    }

    protected void calculateValuesProportionsOfRange(boolean relativeMin, int categoryCount) {
        double value;
        Object obj;
        List<Double> list;
        this.proportions.clear();
        int count = this.publishedElements.size();
        this.max = this.upperLimit;
        this.min = this.lowerLimit;
        if (this.upperLimit == -1.7976931348623157E308 || this.lowerLimit == Double.MAX_VALUE) {
            int i2;
            if (categoryCount >= 0) {
                for (i2 = 0; i2 < categoryCount; ++i2) {
                    double upSum = 0.0;
                    double lowSum = 0.0;
                    for (int j2 = 0; j2 < count; ++j2) {
                        Element element = (Element)this.publishedElements.get(j2);
                        list = this.getValues(element);
                        if (list.size() <= i2 || !((obj = list.get(i2)) instanceof Double)) continue;
                        value = (Double)obj;
                        if (value > 0.0) {
                            upSum += value;
                            continue;
                        }
                        lowSum += value;
                    }
                    if (this.upperLimit == -1.7976931348623157E308 && upSum > this.max) {
                        this.max = upSum;
                    }
                    if (this.lowerLimit != Double.MAX_VALUE || !(lowSum < this.min)) continue;
                    this.min = lowSum;
                }
            } else {
                for (i2 = 0; i2 < count; ++i2) {
                    Element element = (Element)this.publishedElements.get(i2);
                    List list2 = this.getValues(element);
                    int count2 = list2.size();
                    if (this.endIndex < count2) {
                        count2 = this.endIndex;
                    }
                    for (int j3 = this.startIndex; j3 < count2; j3 += this.valueSpanCount) {
                        Object obj2 = list2.get(j3);
                        if (!(obj2 instanceof Double)) continue;
                        double value2 = (Double)obj2;
                        if (this.upperLimit == -1.7976931348623157E308 && value2 > this.max) {
                            this.max = value2;
                        }
                        if (this.lowerLimit != Double.MAX_VALUE || !(value2 < this.min)) continue;
                        this.min = value2;
                    }
                }
            }
        }
        if (this.min == Double.MAX_VALUE) {
            if (this.max != -1.7976931348623157E308) {
                this.min = this.max * 0.9;
            } else {
                this.max = 100.0;
                this.min = 0.0;
            }
        } else if (this.max == -1.7976931348623157E308) {
            this.max = this.min * 1.1;
        }
        if (this.max == -1.7976931348623157E308) {
            if (this.min == Double.MAX_VALUE) {
                this.max = 100.0;
                this.min = 0.0;
            } else {
                this.max = this.min * 1.1;
            }
        } else if (this.min == Double.MAX_VALUE) {
            this.min = this.max * 0.9;
        }
        if (this.max == this.min) {
            if (this.max == 0.0) {
                this.max = 10.0;
                this.min = -10.0;
            } else {
                double temp = this.max * 0.1;
                this.max += temp;
                this.min -= temp;
            }
        }
        this.range = Math.abs(this.max - this.min);
        double relative = relativeMin ? this.min : 0.0;
        for (int i3 = 0; i3 < count; ++i3) {
            Element element = (Element)this.publishedElements.get(i3);
            List values = this.getValues(element);
            int count2 = values.size();
            for (int j4 = 0; j4 < count2; ++j4) {
                list = (List)this.proportions.get(element);
                if (list == null) {
                    list = new ArrayList<Double>();
                    this.proportions.put(element, list);
                }
                if (this.range != 0.0 && j4 >= this.startIndex && j4 < this.endIndex && (j4 - this.startIndex) % this.valueSpanCount == 0) {
                    obj = values.get(j4);
                    if (obj == null) {
                        list.add(null);
                        continue;
                    }
                    value = (Double)obj;
                    list.add(new Double((value - relative) / this.range));
                    continue;
                }
                list.add(null);
            }
        }
    }

    protected void calculateYScaleValueGap() {
        if (this.yScaleValueGap <= 0.0) {
            this.yscaleAutoCaculateFlag = true;
        }
        if (this.yScaleValueGapAutoCalculate && (this.yScaleValueGap <= 0.0 || this.yscaleAutoCaculateFlag)) {
            this.yScaleValueGap = this.getAutoScaleValueGap(this.range);
        }
    }

    protected double getAutoScaleValueGap(double range) {
        double gap = 0.0;
        double segment = 15.0;
        if (range <= 0.0) {
            return gap;
        }
        if (range < segment) {
            double rangeTemp;
            int ten = 10;
            if (range < 1.0) {
                String[] str = (range + "").split("\\.");
                String after = str[1];
                int length = after.length();
                for (int i2 = 0; i2 < length && "0".equals(after.substring(i2, i2 + 1)); ++i2) {
                    ten *= 10;
                }
            } else {
                ten = 1;
            }
            if ((rangeTemp = (double)ten * range) >= 4.0) {
                gap = 1.0 / (double)ten;
            } else if (rangeTemp >= segment / 10.0) {
                gap = 0.5 / (double)ten;
            } else if (rangeTemp < segment / 10.0) {
                gap = 0.1 / (double)ten;
            }
        }
        if (range < 25.0 && range >= segment) {
            gap = 5.0;
        }
        if (range >= 25.0) {
            int length = ((int)range + "").trim().length();
            int ten = 1;
            for (int i3 = 0; i3 < length - 1; ++i3) {
                ten *= 10;
            }
            gap = ten;
            double divisor = range / gap;
            if (divisor < 4.0 && (divisor = range / (gap = (double)(ten / 2))) < 4.0 && (divisor = range / (gap = (double)(ten / 5))) < 4.0) {
                gap = ten / 10;
            }
        }
        return gap;
    }

    public boolean isYScaleValueGapAutoCalculate() {
        return this.yScaleValueGapAutoCalculate;
    }

    public void setYScaleValueGapAutoCalculate(boolean scaleValueGapAutoCaculate) {
        this.yScaleValueGapAutoCalculate = scaleValueGapAutoCaculate;
        this.publishData(false);
    }

    protected void setChartSVGAttribute(AbstractSVGChart abschart) {
        super.setChartSVGAttribute(abschart);
        AbstractSVGScaleChart chart = (AbstractSVGScaleChart)abschart;
        chart.setXAxisFillColor(this.getXAxisFillColor());
        chart.setXAxisOutlineColor(this.getXAxisOutlineColor());
        chart.setXAxisStroke(this.getXAxisStroke());
        chart.setXAxisText(this.getXAxisText());
        chart.setXAxisTextColor(this.getXAxisTextColor());
        chart.setXAxisTextFont(this.getXAxisTextFont());
        chart.setXAxisValue(this.getXAxisValue());
        chart.setXAxisVisible(this.getXAxisVisible());
        chart.setXScaleTextColor(this.getXScaleTextColor());
        chart.setXScaleTextFont(this.getXScaleTextFont());
        chart.setXScaleTextList(this.getXScaleTextList());
        chart.setXScaleTextOrientation(this.getXScaleTextOrientation());
        chart.setXScaleTextVisible(this.isXScaleTextVisible());
        chart.setYAxisFillColor(this.getYAxisFillColor());
        chart.setYAxisOutlineColor(this.getYAxisOutlineColor());
        chart.setYAxisStroke(this.getYAxisStroke());
        chart.setYAxisText(this.getYAxisText());
        chart.setYAxisTextColor(this.getYAxisTextColor());
        chart.setYAxisTextFont(this.getYAxisTextFont());
        chart.setYAxisVisible(this.getYAxisVisible());
        chart.setYScaleLineColor(this.getYScaleLineColor());
        chart.setYScaleLineStroke(this.getYScaleLineStroke());
        chart.setYScaleLineVisible(this.isYScaleLineVisible());
        chart.setYScaleMinTextVisible(this.isYScaleMinTextVisible());
        chart.setYScalePixelGap(this.getYScalePixelGap());
        chart.setYScaleTextColor(this.getYScaleTextColor());
        chart.setYScaleTextFont(chart.getYScaleTextFont());
        chart.setYScaleTextFormat(chart.getYScaleTextFormat());
        chart.setYScaleTextInside(this.isYScaleTextInside());
        chart.setYScaleTextVisible(this.isYScaleTextVisible());
        chart.setYScaleValueGap(this.getYScaleValueGap());
        chart.setYScaleValueGapAutoCalculate(this.isYScaleValueGapAutoCalculate());
    }
}

