/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.table;

import com.nepxion.swing.table.ITableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class BasicTableModel
extends AbstractTableModel
implements ITableModel {
    protected List rowDatas;
    protected String[] columnNames;

    public BasicTableModel(List rowDatas, String[] columnNames) {
        this.rowDatas = rowDatas;
        this.columnNames = columnNames;
    }

    @Override
    public int getRowCount() {
        return this.rowDatas.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int column) {
        return super.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public synchronized void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.fireTableStructureChanged();
    }

    @Override
    public List getRowDatas() {
        return this.rowDatas;
    }

    @Override
    public synchronized void setRowDatas(List rowDatas) {
        this.rowDatas = rowDatas;
        this.fireTableDataChanged();
    }

    @Override
    public Object getRow(int row) {
        return this.rowDatas.get(row);
    }

    @Override
    public List getRows(int[] rows) {
        if (rows == null || rows.length == 0) {
            return null;
        }
        ArrayList<Object> rowDatas = new ArrayList<Object>();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            Object rowData = this.getRow(row);
            rowDatas.add(rowData);
        }
        return rowDatas;
    }

    @Override
    public void addRow(Object rowData) {
        this.rowDatas.add(rowData);
        this.fireTableDataChanged();
    }

    @Override
    public void addRow(Object rowData, int row) {
        this.rowDatas.add(row, rowData);
        this.fireTableDataChanged();
    }

    @Override
    public void addRows(List rowDataList) {
        this.rowDatas.addAll(rowDataList);
        this.fireTableDataChanged();
    }

    @Override
    public void addRows(List rowDataList, int row) {
        this.rowDatas.addAll(row, rowDataList);
        this.fireTableDataChanged();
    }

    @Override
    public void updateRow(Object rowData, int row) {
        this.rowDatas.remove(row);
        this.rowDatas.add(row, rowData);
        this.fireTableDataChanged();
    }

    @Override
    public void deleteRow(int row) {
        this.rowDatas.remove(row);
        this.fireTableDataChanged();
    }

    @Override
    public void deleteRow(Object rowData) {
        this.rowDatas.remove(rowData);
        this.fireTableDataChanged();
    }

    @Override
    public void deleteRows(int[] rows) {
        ArrayList<Object> rowDataList = new ArrayList<Object>();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            Object rowData = this.getRow(row);
            rowDataList.add(rowData);
        }
        this.deleteRows(rowDataList);
    }

    @Override
    public void deleteRows(List rowDataList) {
        this.rowDatas.removeAll(rowDataList);
        this.fireTableDataChanged();
    }

    @Override
    public void limitRows(int limitedRowCount, boolean isFromTop) {
        int rowCount = this.getRowCount();
        if (rowCount > limitedRowCount) {
            int deletedCount = rowCount - limitedRowCount;
            int[] deletedRows = new int[deletedCount];
            for (int i = 0; i < deletedCount; ++i) {
                deletedRows[i] = isFromTop ? i : rowCount - i - 1;
            }
            this.deleteRows(deletedRows);
        }
    }

    @Override
    public void clearRows() {
        this.rowDatas.clear();
        this.fireTableDataChanged();
    }
}

