/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.office2003;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.office2003.DefaultOffice2003Theme;
import com.jidesoft.plaf.office2003.Office2003Theme;
import com.jidesoft.plaf.office2003.Office2003WindowsUtils;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Office2003Painter
extends BasicPainter {
    private static Office2003Painter _instance;
    private String _colorName = "Default";
    private static boolean _native;
    private static Office2003Theme _defaultTheme;
    private static Office2003Theme _normalTheme;
    private static Office2003Theme _blueTheme;
    private static Office2003Theme _homeSteadTheme;
    private static Office2003Theme _metallicTheme;
    private static Map<String, Office2003Theme> _themeCache;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new Office2003Painter();
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (Office2003Painter.isNative()) {
                        if ("win.xpstyle.colorName".equals(propertyChangeEvent.getPropertyName())) {
                            if (propertyChangeEvent.getNewValue() != null) {
                                _instance.setColorName((String)propertyChangeEvent.getNewValue());
                            } else {
                                _instance.setColorName("");
                            }
                        } else if ("win.xpstyle.themeActive".equals(propertyChangeEvent.getPropertyName())) {
                            if (propertyChangeEvent.getNewValue().equals(Boolean.FALSE)) {
                                _instance.setColorName("");
                            } else {
                                _instance.setColorName(XPUtils.getColorName());
                            }
                        }
                    }
                }
            };
            Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.colorName", propertyChangeListener);
            Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.themeActive", propertyChangeListener);
            if (Office2003Painter.isNative()) {
                try {
                    if (XPUtils.isXPStyleOn()) {
                        _instance.setColorName(XPUtils.getColorName());
                    } else {
                        _instance.setColorName("");
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    _instance.setColorName("");
                }
            }
        }
        return _instance;
    }

    protected Office2003Painter() {
    }

    public void addTheme(Office2003Theme office2003Theme) {
        _themeCache.put(office2003Theme.getThemeName(), office2003Theme);
    }

    public Office2003Theme getTheme(String string) {
        return _themeCache.get(string);
    }

    public void removeTheme(String string) {
        _themeCache.remove(string);
    }

    public Collection<Office2003Theme> getAvailableThemes() {
        return _themeCache.values();
    }

    @Override
    public void installDefaults() {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.installDefaults();
        }
    }

    @Override
    public void uninstallDefaults() {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.uninstallDefaults();
        }
    }

    public String getColorName() {
        return this._colorName;
    }

    public void setColorName(String string) {
        this._colorName = string;
    }

    public static boolean isNative() {
        return _native;
    }

    public static void setNative(boolean bl) {
        _native = bl;
    }

    public Office2003Theme getCurrentTheme() {
        if (this.getColorName() == null || this.getColorName().trim().length() == 0 || _themeCache.get(this.getColorName()) == null) {
            return _themeCache.get("Default");
        }
        return _themeCache.get(this.getColorName());
    }

    @Override
    public void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        Boolean bl2 = UIManager.getBoolean("Theme.highContrast");
        if (bl2.booleanValue()) {
            super.paintButtonBackground(jComponent, graphics, rectangle, n, n2, bl);
            return;
        }
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        switch (n2) {
            case 0: {
                color3 = jComponent.getBackground();
                if (!(color3 instanceof UIResource)) {
                    color = ColorUtils.getDerivedColor(color3, 0.6f);
                    color2 = ColorUtils.getDerivedColor(color3, 0.4f);
                    bl = false;
                    break;
                }
                color = this.getCurrentTheme().getColor("controlLt");
                color2 = this.getCurrentTheme().getColor("controlDk");
                break;
            }
            case 2: {
                if (jComponent instanceof ComponentStateSupport) {
                    color3 = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(n2);
                }
                if (color3 != null && !(color3 instanceof UIResource)) {
                    color = ColorUtils.getDerivedColor(color3, 0.6f);
                    color2 = ColorUtils.getDerivedColor(color3, 0.4f);
                    break;
                }
                color = this.getCurrentTheme().getColor("selection.RolloverLt");
                color2 = this.getCurrentTheme().getColor("selection.RolloverDk");
                break;
            }
            case 3: {
                if (jComponent instanceof ComponentStateSupport) {
                    color3 = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(n2);
                }
                if (color3 != null && !(color3 instanceof UIResource)) {
                    color = ColorUtils.getDerivedColor(color3, 0.6f);
                    color2 = ColorUtils.getDerivedColor(color3, 0.4f);
                    break;
                }
                color = this.getCurrentTheme().getColor("selection.SelectedLt");
                color2 = this.getCurrentTheme().getColor("selection.SelectedDk");
                break;
            }
            case 1: {
                if (jComponent instanceof ComponentStateSupport) {
                    color3 = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(n2);
                }
                if (color3 != null && !(color3 instanceof UIResource)) {
                    color = ColorUtils.getDerivedColor(color3, 0.4f);
                    color2 = ColorUtils.getDerivedColor(color3, 0.6f);
                    break;
                }
                color = this.getCurrentTheme().getColor("selection.PressedDk");
                color2 = this.getCurrentTheme().getColor("selection.PressedLt");
            }
        }
        if (color != null && color2 != null) {
            this.paintBackground(jComponent, (Graphics2D)graphics, rectangle, bl ? this.getCurrentTheme().getColor("selection.border") : null, color, color2, n);
        }
    }

    protected void paintBackground(JComponent jComponent, Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, Color color3, int n) {
        if (color != null) {
            if (color2 != null && color3 != null) {
                JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color3, n == 0);
            }
            boolean bl = true;
            Object object = jComponent.getClientProperty("JideButton.paintDefaultBorder");
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            if (bl) {
                Color color4 = graphics2D.getColor();
                graphics2D.setColor(color);
                Object object2 = jComponent.getClientProperty("JButton.segmentPosition");
                if (object2 == null || "only".equals(object2)) {
                    graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                } else if ("first".equals(object2)) {
                    if (n == 0) {
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
                    } else {
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    }
                } else if ("middle".equals(object2)) {
                    if (n == 0) {
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
                    } else {
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    }
                } else if ("last".equals(object2)) {
                    if (n == 0) {
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                    } else {
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                    }
                }
                graphics2D.setColor(color4);
            }
        } else if (color2 != null && color3 != null) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color3, n == 0);
        }
    }

    @Override
    public void paintChevronBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n2 == 0) {
            this.paintChevron(jComponent, graphics2D, this.getCurrentTheme().getColor("Chevron.backgroundLt"), this.getCurrentTheme().getColor("Chevron.backgroundDk"), rectangle, n);
        } else if (n2 == 2) {
            this.paintChevron(jComponent, graphics2D, this.getCurrentTheme().getColor("selection.RolloverLt"), this.getCurrentTheme().getColor("selection.RolloverDk"), rectangle, n);
        } else if (n2 == 3) {
            this.paintChevron(jComponent, graphics2D, this.getCurrentTheme().getColor("selection.SelectedDk"), this.getCurrentTheme().getColor("selection.SelectedLt"), rectangle, n);
        } else if (n2 == 1) {
            this.paintChevron(jComponent, graphics2D, this.getCurrentTheme().getColor("selection.PressedDk"), this.getCurrentTheme().getColor("selection.PressedLt"), rectangle, n);
        }
    }

    @Override
    public void paintDividerBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        JideSwingUtilities.fillGradient(graphics2D, rectangle, this.getCurrentTheme().getColor("Divider.backgroundLt"), this.getCurrentTheme().getColor("Divider.backgroundDk"), true);
    }

    protected void paintChevron(JComponent jComponent, Graphics2D graphics2D, Color color, Color color2, Rectangle rectangle, int n) {
        if (n == 0) {
            if (!jComponent.getComponentOrientation().isLeftToRight()) {
                JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y + 2, rectangle.width - 2, rectangle.height - 4), color, color2, true);
                graphics2D.setColor(color);
                graphics2D.drawLine(rectangle.x + 2, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
                graphics2D.setColor(color2);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
                graphics2D.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            } else {
                JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 2, rectangle.height - 4), color, color2, true);
                graphics2D.setColor(color);
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 3, rectangle.y);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
                graphics2D.setColor(color2);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
                graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 1);
            }
        } else {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 2), color, color2, false);
            graphics2D.setColor(color);
            graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 3);
            graphics2D.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 2);
            graphics2D.setColor(color2);
            graphics2D.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
            graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 3);
        }
    }

    @Override
    public Color getColor(Object object) {
        return this.getCurrentTheme().getColor(object);
    }

    @Override
    public void paintCommandBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCommandBarBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        JideSwingUtilities.fillGradient(graphics2D, new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 4.0f, 4.0f), this.getCurrentTheme().getColor("controlLt"), this.getCurrentTheme().getColor("controlDk"), n == 0);
        graphics2D.setColor(this.getCurrentTheme().getColor("controlShadow"));
        if (n == 0) {
            graphics2D.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 1);
        } else {
            graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 3);
        }
    }

    @Override
    public void paintFloatingCommandBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        JideSwingUtilities.fillGradient(graphics2D, rectangle, this.getCurrentTheme().getColor("controlLt"), this.getCurrentTheme().getColor("controlDk"), n == 0);
    }

    @Override
    public void paintMenuShadow(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            JideSwingUtilities.fillGradient(graphics2D, rectangle, this.getCurrentTheme().getColor("controlLt"), this.getCurrentTheme().getColor("controlDk"), n != 0);
        } else {
            JideSwingUtilities.fillGradient(graphics2D, rectangle, this.getCurrentTheme().getColor("controlDk"), this.getCurrentTheme().getColor("controlLt"), n != 0);
        }
    }

    @Override
    public Color getControl() {
        return this.getCurrentTheme().getColor("control");
    }

    @Override
    public Color getControlLt() {
        return this.getCurrentTheme().getColor("controlLt");
    }

    @Override
    public Color getControlDk() {
        return this.getCurrentTheme().getColor("controlDk");
    }

    @Override
    public Color getControlShadow() {
        return this.getCurrentTheme().getColor("controlShadow");
    }

    @Override
    public Color getGripperForeground() {
        return this.getCurrentTheme().getColor("Gripper.foreground");
    }

    @Override
    public Color getGripperForegroundLt() {
        return this.getCurrentTheme().getColor("Gripper.foregroundLt");
    }

    @Override
    public Color getSeparatorForeground() {
        return this.getCurrentTheme().getColor("Separator.foreground");
    }

    @Override
    public Color getSeparatorForegroundLt() {
        return this.getCurrentTheme().getColor("Separator.foregroundLt");
    }

    @Override
    public Color getCollapsiblePaneContentBackground() {
        return this.getCurrentTheme().getColor("CollapsiblePane.contentBackground");
    }

    @Override
    public Color getCollapsiblePaneTitleForeground() {
        return this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.foreground");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForeground() {
        return this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.foreground.focus");
    }

    @Override
    public Color getCollapsiblePaneTitleForegroundEmphasized() {
        return this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.foreground.emphasized");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForegroundEmphasized() {
        return this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.foreground.focus.emphasized");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIcon() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.upIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIcon() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.downIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIconEmphasized() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.upIcon.emphasized");
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIconEmphasized() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.downIcon.emphasized");
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackground() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.titleButtonBackground");
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackgroundEmphasized() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.titleButtonBackground.emphasized");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpMask() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.upMask");
    }

    @Override
    public ImageIcon getCollapsiblePaneDownMask() {
        return (ImageIcon)this.getCurrentTheme().getIcon("CollapsiblePane.downMask");
    }

    @Override
    public Color getBackgroundDk() {
        return this.getCurrentTheme().getColor("backgroundDk");
    }

    @Override
    public Color getBackgroundLt() {
        return this.getCurrentTheme().getColor("backgroundLt");
    }

    @Override
    public Color getSelectionSelectedDk() {
        return this.getCurrentTheme().getColor("selection.SelectedDk");
    }

    @Override
    public Color getSelectionSelectedLt() {
        return this.getCurrentTheme().getColor("selection.SelectedLt");
    }

    @Override
    public Color getMenuItemBorderColor() {
        return this.getCurrentTheme().getColor("selection.border");
    }

    @Override
    public Color getMenuItemBackground() {
        return this.getCurrentTheme().getColor("MenuItem.background");
    }

    @Override
    public Color getCommandBarTitleBarBackground() {
        return this.getCurrentTheme().getColor("CommandBar.titleBarBackground");
    }

    @Override
    public Color getDockableFrameTitleBarActiveForeground() {
        return this.getCurrentTheme().getColor("DockableFrameTitlePane.activeForeground");
    }

    @Override
    public Color getDockableFrameTitleBarInactiveForeground() {
        return this.getCurrentTheme().getColor("DockableFrameTitlePane.inactiveForeground");
    }

    @Override
    public Color getTitleBarBackground() {
        return this.getCurrentTheme().getColor("DockableFrameTitlePane.backgroundDk");
    }

    @Override
    public Color getOptionPaneBannerForeground() {
        return this.getCurrentTheme().getColor("OptionPane.bannerForeground");
    }

    @Override
    public Color getTabbedPaneSelectDk() {
        return this.getCurrentTheme().getColor("TabbedPane.selectDk");
    }

    @Override
    public Color getTabbedPaneSelectLt() {
        return this.getCurrentTheme().getColor("TabbedPane.selectLt");
    }

    @Override
    public Color getOptionPaneBannerDk() {
        return this.getCurrentTheme().getColor("OptionPane.bannerDk");
    }

    @Override
    public Color getOptionPaneBannerLt() {
        return this.getCurrentTheme().getColor("OptionPane.bannerLt");
    }

    @Override
    public void paintContentBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        JideSwingUtilities.fillGradient(graphics2D, rectangle, this.getBackgroundDk(), this.getBackgroundLt(), false);
    }

    @Override
    public void paintGripper(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (rectangle.width > 30) {
            n = 1;
        } else if (rectangle.height > 30) {
            n = 0;
        }
        int n3 = n == 0 ? rectangle.height : rectangle.width;
        int n4 = Math.min(9, (n3 - 6) / 4);
        int n5 = rectangle.y;
        int n6 = rectangle.x;
        if (n == 0) {
            n5 += rectangle.height / 2 - n4 * 2;
            n6 += rectangle.width / 2 - 1;
        } else {
            n6 += rectangle.width / 2 - n4 * 2;
            n5 += rectangle.height / 2 - 1;
        }
        for (int i = 0; i < n4; ++i) {
            graphics.setColor(this.getGripperForegroundLt());
            graphics.fillRect(n6 + 1, n5 + 1, 2, 2);
            graphics.setColor(this.getGripperForeground());
            graphics.fillRect(n6, n5, 2, 2);
            if (n == 0) {
                n5 += 4;
                continue;
            }
            n6 += 4;
        }
    }

    @Override
    public void paintChevronMore(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3;
        int n4 = rectangle.x + 4;
        int n5 = rectangle.x + 5;
        int n6 = n3 = n == 0 ? 1 : 0;
        if (n == 0) {
            if (!jComponent.getComponentOrientation().isLeftToRight()) {
                n4 = rectangle.width - 8;
                JideSwingUtilities.paintArrow(jComponent, graphics, Color.WHITE, --n4, ++n5, 3, n3);
                JideSwingUtilities.paintArrow(jComponent, graphics, Color.WHITE, n4 -= 4, n5, 3, n3);
                ++n4;
                JideSwingUtilities.paintArrow(jComponent, graphics, Color.BLACK, n4 += 4, --n5, 3, n3);
                JideSwingUtilities.paintArrow(jComponent, graphics, Color.BLACK, n4 -= 4, n5, 3, n3);
            } else {
                JideSwingUtilities.paintArrow(graphics, Color.WHITE, ++n4, ++n5, 3, n3);
                JideSwingUtilities.paintArrow(graphics, Color.WHITE, n4 += 4, n5, 3, n3);
                --n4;
                JideSwingUtilities.paintArrow(graphics, Color.BLACK, n4 -= 4, --n5, 3, n3);
                JideSwingUtilities.paintArrow(graphics, Color.BLACK, n4 += 4, n5, 3, n3);
            }
        } else if (n == 1) {
            JideSwingUtilities.paintArrow(graphics, Color.WHITE, ++n4, ++n5, 3, n3);
            JideSwingUtilities.paintArrow(graphics, Color.WHITE, n4, n5 += 4, 3, n3);
            --n5;
            JideSwingUtilities.paintArrow(graphics, Color.BLACK, --n4, n5 -= 4, 3, n3);
            JideSwingUtilities.paintArrow(graphics, Color.BLACK, n4, n5 += 4, 3, n3);
        }
    }

    @Override
    public void paintChevronOption(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3;
        int n4;
        if (n == 0) {
            if (!jComponent.getComponentOrientation().isLeftToRight()) {
                n4 = rectangle.x + 2;
                n3 = rectangle.y + rectangle.height - 10;
            } else {
                n4 = rectangle.x + rectangle.width - 8;
                n3 = rectangle.y + rectangle.height - 10;
            }
        } else if (n == 1) {
            n4 = rectangle.x + rectangle.width - 10;
            n3 = rectangle.y + rectangle.height - 8;
        } else {
            return;
        }
        graphics.setColor(Color.WHITE);
        this.paintDown(graphics, ++n4, ++n3, n);
        graphics.setColor(Color.BLACK);
        this.paintDown(graphics, --n4, --n3, n);
    }

    private void paintDown(Graphics graphics, int n, int n2, int n3) {
        if (n3 == 0) {
            graphics.drawLine(n, n2, n + 4, n2);
            JideSwingUtilities.paintArrow(graphics, graphics.getColor(), n, n2 + 3, 5, 0);
        } else {
            graphics.drawLine(n, n2, n, n2 + 4);
            JideSwingUtilities.paintArrow(graphics, graphics.getColor(), n + 3, n2, 5, n3);
        }
    }

    @Override
    public void paintDockableFrameBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (!jComponent.isOpaque()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), this.getCurrentTheme().getColor("DockableFrame.backgroundLt"), this.getCurrentTheme().getColor("DockableFrame.backgroundDk"), n == 0);
    }

    @Override
    public void paintDockableFrameTitlePane(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintDockableFrameTitlePane(jComponent, graphics, rectangle, n, n2);
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (jComponent.getBorder() != null) {
            Insets insets = jComponent.getBorder().getBorderInsets(jComponent);
            n3 += insets.left;
            n4 += insets.top;
            n5 -= insets.right + insets.left;
            n6 -= insets.top + insets.bottom;
        }
        rectangle = new Rectangle(n3, n4, n5, n6);
        boolean bl2 = n2 == 3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        JideSwingUtilities.fillGradient(graphics2D, rectangle, bl2 ? this.getCurrentTheme().getColor("selection.SelectedLt") : this.getCurrentTheme().getColor("DockableFrameTitlePane.backgroundLt"), bl2 ? this.getCurrentTheme().getColor("selection.SelectedDk") : this.getCurrentTheme().getColor("DockableFrameTitlePane.backgroundDk"), n == 0);
    }

    private void paintCollapsiblePaneTitlePane(Graphics2D graphics2D, Color color, Color color2, int n, Rectangle rectangle) {
        Color color3 = graphics2D.getColor();
        graphics2D.setColor(color);
        switch (n) {
            case 3: {
                graphics2D.drawLine(rectangle.x + 2, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
                JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y + 2, rectangle.width, rectangle.height - 4), color, color2, true);
                graphics2D.setColor(color2);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 2);
                graphics2D.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                break;
            }
            case 7: {
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 3, rectangle.y);
                graphics2D.drawLine(rectangle.x, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
                JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y + 2, rectangle.width, rectangle.height - 4), color, color2, true);
                graphics2D.setColor(color2);
                graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 2);
                graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 1);
                break;
            }
            case 1: {
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y + rectangle.height - 1);
                JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x + 2, rectangle.y, rectangle.width - 4, rectangle.height), color, color2, false);
                graphics2D.setColor(color2);
                graphics2D.drawLine(rectangle.x + rectangle.width - 2, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 1);
                graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 2);
                break;
            }
            case 5: {
                graphics2D.drawLine(rectangle.x, rectangle.y + 2, rectangle.x, rectangle.y + rectangle.height - 1);
                graphics2D.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 1);
                JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x + 2, rectangle.y, rectangle.width - 4, rectangle.height), color, color2, false);
                graphics2D.setColor(color2);
                graphics2D.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 1);
                graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
        }
        graphics2D.setColor(color3);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Color color;
        Color color2;
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color3 = jComponent.getBackground();
        if (!(color3 instanceof UIResource)) {
            color2 = ColorUtils.getDerivedColor(color3, 0.6f);
            color = ColorUtils.getDerivedColor(color3, 0.5f);
        } else {
            color2 = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundLt");
            color = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundDk");
        }
        this.paintCollapsiblePaneTitlePane(graphics2D, color2, color, n, rectangle);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Color color;
        Color color2;
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundEmphasized(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color3 = jComponent.getBackground();
        if (!(color3 instanceof UIResource)) {
            color2 = ColorUtils.getDerivedColor(color3, 0.5f);
            color = ColorUtils.getDerivedColor(color3, 0.4f);
        } else {
            color2 = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundLt.emphasized");
            color = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundDk.emphasized");
        }
        this.paintCollapsiblePaneTitlePane(graphics2D, color2, color, n, rectangle);
    }

    @Override
    public void paintCollapsiblePanesBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (!jComponent.isOpaque()) {
            return;
        }
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePanesBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!(jComponent.getBackground() instanceof UIResource)) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), ColorUtils.getDerivedColor(jComponent.getBackground(), 0.6f), jComponent.getBackground(), n == 0);
        } else {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), this.getCurrentTheme().getColor("CollapsiblePanes.backgroundLt"), this.getCurrentTheme().getColor("CollapsiblePanes.backgroundDk"), n == 0);
        }
    }

    private void paintCollapsiblePaneTitlePanePlain(Graphics2D graphics2D, Color color, Color color2, int n, Rectangle rectangle) {
        Rectangle rectangle2;
        switch (n) {
            case 3: {
                rectangle2 = new Rectangle(rectangle.x + rectangle.width - 1, rectangle.y, 1, rectangle.height);
                break;
            }
            case 7: {
                rectangle2 = new Rectangle(rectangle.x, rectangle.y, 1, rectangle.height);
                break;
            }
            case 1: {
                rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, 1);
                break;
            }
            default: {
                rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.width, 1);
            }
        }
        JideSwingUtilities.fillGradient(graphics2D, rectangle2, color2, color, n == 1 || n == 5);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlainEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundPlainEmphasized(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundLt.emphasized");
        Color color2 = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundDk.emphasized");
        this.paintCollapsiblePaneTitlePanePlain(graphics2D, color2, color, n, rectangle);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlain(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundPlain(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundLt");
        Color color2 = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundDk");
        this.paintCollapsiblePaneTitlePanePlain(graphics2D, color2, color, n, rectangle);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundLt.emphasized");
        Color color2 = this.getCurrentTheme().getColor("CollapsiblePaneTitlePane.backgroundDk.emphasized");
        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, n == 1 || n == 5);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparator(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.getCurrentTheme().getColor("backgroundLt");
        Color color2 = this.getCurrentTheme().getColor("backgroundDk");
        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, n == 1 || n == 5);
    }

    @Override
    public void paintTabAreaBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintTabAreaBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (jComponent instanceof JideTabbedPane && ((JideTabbedPane)jComponent).getColorTheme() != 2) {
            super.paintTabAreaBackground(jComponent, graphics, rectangle, n, n2);
        } else if (jComponent.isOpaque()) {
            boolean bl2;
            Object object = jComponent.getClientProperty("JideTabbedPane.gradientTabArea");
            boolean bl3 = bl2 = object instanceof Boolean ? (Boolean)object : UIDefaultsLookup.getBoolean((Object)"JideTabbedPane.gradientTabArea", true);
            if (jComponent instanceof JideTabbedPane && bl2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = this.getTabAreaBackgroundDk();
                Color color2 = this.getTabAreaBackgroundLt();
                int n3 = ((JideTabbedPane)jComponent).getTabPlacement();
                switch (n3) {
                    case 1: {
                        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, true);
                        break;
                    }
                    case 3: {
                        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, true);
                        break;
                    }
                    case 2: {
                        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, false);
                        break;
                    }
                    case 4: {
                        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, false);
                    }
                }
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("control"));
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    @Override
    public void paintHeaderBoxBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        super.paintHeaderBoxBackground(jComponent, graphics, rectangle, n, n2);
        if (n2 == 2) {
            graphics.setColor(ColorUtils.getDerivedColor(this.getCurrentTheme().getColor("selection.Rollover"), 0.3f));
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 3, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 3);
            graphics.setColor(ColorUtils.getDerivedColor(this.getCurrentTheme().getColor("selection.Rollover"), 0.35f));
            graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 2);
            graphics.setColor(ColorUtils.getDerivedColor(this.getCurrentTheme().getColor("selection.Rollover"), 0.4f));
            graphics.drawLine(rectangle.x + 3, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height - 1);
        }
    }

    @Override
    public void paintToolBarSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = n == 0 ? rectangle.height : rectangle.width;
        n3 -= 9;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
            int n4 = rectangle.y + 5;
            int n5 = rectangle.x + 1;
            graphics.setColor(this.getSeparatorForeground());
            graphics.drawLine(n5, n4, n5, n4 + n3);
            graphics.setColor(this.getSeparatorForegroundLt());
            graphics.drawLine(n5 + 1, n4 + 1, n5 + 1, n4 + n3 + 1);
        } else {
            int n6 = rectangle.y + 1;
            int n7 = rectangle.x + 5;
            graphics.setColor(this.getSeparatorForeground());
            graphics.drawLine(n7, n6, n7 + n3, n6);
            graphics.setColor(this.getSeparatorForegroundLt());
            graphics.drawLine(n7 + 1, n6 + 1, n7 + 1 + n3, n6 + 1);
        }
    }

    @Override
    public void paintPopupMenuSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        int n4 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            this.paintMenuShadow(jComponent, graphics, new Rectangle(rectangle.x, rectangle.y, n3, rectangle.height), 0, 0);
            graphics.setColor(this.getMenuItemBackground());
            graphics.fillRect(rectangle.x + n3, rectangle.y, rectangle.width - n3, rectangle.height);
            graphics.setColor(this.getSeparatorForeground());
            graphics.drawLine(rectangle.x + n3 + n4, rectangle.y + 1, rectangle.x + rectangle.width, rectangle.y + 1);
        } else {
            this.paintMenuShadow(jComponent, graphics, new Rectangle(rectangle.x + rectangle.width - n3, rectangle.y, n3, rectangle.height), 0, 0);
            graphics.setColor(this.getMenuItemBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - n3, rectangle.height);
            graphics.setColor(this.getSeparatorForeground());
            graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x + rectangle.width - n3 - n4, rectangle.y + 1);
        }
    }

    @Override
    public void paintStatusBarSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = n == 0 ? jComponent.getHeight() : jComponent.getWidth();
        n3 -= 3;
        if (n == 0) {
            int n4 = rectangle.x;
            int n5 = rectangle.y + 1;
            graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
            graphics.drawLine(n4, n5, n4, n5 + n3);
            graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
            graphics.drawLine(n4 + 1, n5, n4 + 1, n5 + n3);
        } else {
            int n6 = rectangle.x + 1;
            int n7 = rectangle.y;
            graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
            graphics.drawLine(n6, n7, n6 + n3, n7);
            graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
            graphics.drawLine(n6, n7 + 1, n6 + n3, n7 + 1);
        }
    }

    @Override
    public void fillBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (n == 0) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), ColorUtils.getDerivedColor(color, 0.6f), ColorUtils.getDerivedColor(color, 0.4f), true);
        } else {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), ColorUtils.getDerivedColor(color, 0.55f), color, false);
        }
        graphics2D.dispose();
    }

    static {
        ImageIcon imageIcon;
        ImageIcon imageIcon2;
        ImageIcon imageIcon3;
        ImageIcon imageIcon4;
        ImageIcon imageIcon5;
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        _native = SystemInfo.isWindowsXP() || SystemInfo.isWindowsVistaAbove();
        _defaultTheme = new DefaultOffice2003Theme();
        _normalTheme = new Office2003Theme("Gray");
        _blueTheme = new Office2003Theme("NormalColor");
        _homeSteadTheme = new Office2003Theme("HomeStead");
        _metallicTheme = new Office2003Theme("Metallic");
        _themeCache = new TreeMap<String, Office2003Theme>();
        _themeCache.put(_defaultTheme.getThemeName(), _defaultTheme);
        _themeCache.put(_normalTheme.getThemeName(), _normalTheme);
        _themeCache.put(_blueTheme.getThemeName(), _blueTheme);
        _themeCache.put(_homeSteadTheme.getThemeName(), _homeSteadTheme);
        _themeCache.put(_metallicTheme.getThemeName(), _metallicTheme);
        int n = LookAndFeelFactory.getProductsUsed();
        Object[] objectArray4 = new Object[]{"control", new ColorUIResource(219, 216, 209), "controlLt", new ColorUIResource(245, 244, 242), "controlDk", new ColorUIResource(213, 210, 202), "controlShadow", new ColorUIResource(128, 128, 128), "TabbedPane.selectDk", new ColorUIResource(230, 139, 44), "TabbedPane.selectLt", new ColorUIResource(255, 199, 60), "OptionPane.bannerLt", new ColorUIResource(0, 52, 206), "OptionPane.bannerDk", new ColorUIResource(45, 96, 249), "OptionPane.bannerForeground", new ColorUIResource(255, 255, 255), "Separator.foreground", new ColorUIResource(166, 166, 166), "Separator.foregroundLt", new ColorUIResource(255, 255, 255), "Gripper.foreground", new ColorUIResource(160, 160, 160), "Gripper.foregroundLt", new ColorUIResource(255, 255, 255), "Chevron.backgroundLt", new ColorUIResource(160, 160, 160), "Chevron.backgroundDk", new ColorUIResource(128, 128, 128), "Divider.backgroundLt", new ColorUIResource(110, 110, 110), "Divider.backgroundDk", new ColorUIResource(90, 90, 90), "backgroundLt", new ColorUIResource(245, 245, 244), "backgroundDk", new ColorUIResource(212, 208, 200), "selection.border", new ColorUIResource(0, 0, 128), "MenuItem.background", new ColorUIResource(249, 248, 247), "DockableFrameTitlePane.backgroundLt", new ColorUIResource(243, 242, 240), "DockableFrameTitlePane.backgroundDk", new ColorUIResource(212, 208, 200), "DockableFrameTitlePane.activeForeground", new ColorUIResource(0, 0, 0), "DockableFrameTitlePane.inactiveForeground", new ColorUIResource(0, 0, 0), "DockableFrame.backgroundLt", new ColorUIResource(234, 232, 228), "DockableFrame.backgroundDk", new ColorUIResource(234, 232, 228), "CommandBar.titleBarBackground", new ColorUIResource(128, 128, 128)};
        _normalTheme.putDefaults(objectArray4);
        if ((n & 2) != 0) {
            objectArray3 = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_gray.png");
            objectArray2 = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_mask.png");
            objectArray = IconsFactory.getIcon(null, (ImageIcon)objectArray3, 0, 0, 20, 20);
            imageIcon5 = IconsFactory.getIcon(null, (ImageIcon)objectArray3, 20, 0, 20, 20);
            imageIcon4 = IconsFactory.getIcon(null, (ImageIcon)objectArray2, 0, 0, 11, 11);
            imageIcon3 = IconsFactory.getIcon(null, (ImageIcon)objectArray2, 0, 11, 11, 11);
            objectArray4 = new Object[]{"CollapsiblePane.contentBackground", new ColorUIResource(255, 255, 255), "CollapsiblePanes.backgroundLt", new ColorUIResource(160, 160, 160), "CollapsiblePanes.backgroundDk", new ColorUIResource(128, 128, 128), "CollapsiblePaneTitlePane.backgroundLt", new ColorUIResource(255, 255, 255), "CollapsiblePaneTitlePane.backgroundDk", new ColorUIResource(213, 210, 202), "CollapsiblePaneTitlePane.foreground", new ColorUIResource(91, 91, 91), "CollapsiblePaneTitlePane.foreground.focus", new ColorUIResource(137, 137, 137), "CollapsiblePaneTitlePane.backgroundLt.emphasized", new ColorUIResource(68, 68, 68), "CollapsiblePaneTitlePane.backgroundDk.emphasized", new ColorUIResource(94, 94, 94), "CollapsiblePaneTitlePane.foreground.emphasized", new ColorUIResource(255, 255, 255), "CollapsiblePaneTitlePane.foreground.focus.emphasized", new ColorUIResource(230, 230, 230), "CollapsiblePane.downIcon", IconsFactory.getOverlayIcon(null, (ImageIcon)objectArray, imageIcon4, 0), "CollapsiblePane.upIcon", IconsFactory.getOverlayIcon(null, (ImageIcon)objectArray, imageIcon3, 0), "CollapsiblePane.downIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon5, imageIcon4, 0), "CollapsiblePane.upIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon5, imageIcon3, 0), "CollapsiblePane.upMask", imageIcon3, "CollapsiblePane.downMask", imageIcon4, "CollapsiblePane.titleButtonBackground", objectArray, "CollapsiblePane.titleButtonBackground.emphasized", imageIcon5};
            _normalTheme.putDefaults(objectArray4);
        }
        objectArray3 = new Object[]{"control", new ColorUIResource(196, 219, 249), "controlLt", new ColorUIResource(218, 234, 253), "controlDk", new ColorUIResource(129, 169, 226), "controlShadow", new ColorUIResource(59, 67, 156), "TabbedPane.selectDk", new ColorUIResource(230, 139, 44), "TabbedPane.selectLt", new ColorUIResource(255, 199, 60), "OptionPane.bannerLt", new ColorUIResource(0, 52, 206), "OptionPane.bannerDk", new ColorUIResource(45, 96, 249), "OptionPane.bannerForeground", new ColorUIResource(255, 255, 255), "Separator.foreground", new ColorUIResource(106, 140, 203), "Separator.foregroundLt", new ColorUIResource(241, 249, 255), "Gripper.foreground", new ColorUIResource(39, 65, 118), "Gripper.foregroundLt", new ColorUIResource(255, 255, 255), "Chevron.backgroundLt", new ColorUIResource(117, 166, 241), "Chevron.backgroundDk", new ColorUIResource(0, 53, 145), "Divider.backgroundLt", new ColorUIResource(89, 135, 214), "Divider.backgroundDk", new ColorUIResource(0, 45, 150), "backgroundLt", new ColorUIResource(195, 218, 249), "backgroundDk", new ColorUIResource(158, 190, 245), "selection.border", new ColorUIResource(0, 0, 128), "MenuItem.background", new ColorUIResource(246, 246, 246), "DockableFrameTitlePane.backgroundLt", new ColorUIResource(218, 234, 253), "DockableFrameTitlePane.backgroundDk", new ColorUIResource(123, 164, 224), "DockableFrameTitlePane.activeForeground", new ColorUIResource(0, 0, 0), "DockableFrameTitlePane.inactiveForeground", new ColorUIResource(0, 0, 0), "DockableFrame.backgroundLt", new ColorUIResource(221, 236, 254), "DockableFrame.backgroundDk", new ColorUIResource(221, 236, 254), "CommandBar.titleBarBackground", new ColorUIResource(42, 102, 201)};
        _blueTheme.putDefaults(objectArray3);
        if ((n & 2) != 0) {
            objectArray2 = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_blue.png");
            objectArray = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_mask.png");
            imageIcon5 = IconsFactory.getIcon(null, (ImageIcon)objectArray2, 0, 0, 20, 20);
            imageIcon4 = IconsFactory.getIcon(null, (ImageIcon)objectArray2, 20, 0, 20, 20);
            imageIcon3 = IconsFactory.getIcon(null, (ImageIcon)objectArray, 0, 11, 11, 11);
            imageIcon2 = IconsFactory.getIcon(null, (ImageIcon)objectArray, 0, 0, 11, 11);
            objectArray4 = new Object[]{"CollapsiblePane.contentBackground", new ColorUIResource(214, 223, 247), "CollapsiblePanes.backgroundLt", new ColorUIResource(123, 162, 231), "CollapsiblePanes.backgroundDk", new ColorUIResource(103, 125, 217), "CollapsiblePaneTitlePane.backgroundLt", new ColorUIResource(255, 255, 255), "CollapsiblePaneTitlePane.backgroundDk", new ColorUIResource(198, 211, 247), "CollapsiblePaneTitlePane.foreground", new ColorUIResource(33, 93, 198), "CollapsiblePaneTitlePane.foreground.focus", new ColorUIResource(65, 142, 254), "CollapsiblePaneTitlePane.backgroundLt.emphasized", new ColorUIResource(0, 73, 181), "CollapsiblePaneTitlePane.backgroundDk.emphasized", new ColorUIResource(41, 93, 206), "CollapsiblePaneTitlePane.foreground.emphasized", new ColorUIResource(255, 255, 255), "CollapsiblePaneTitlePane.foreground.focus.emphasized", new ColorUIResource(65, 142, 254), "CollapsiblePane.downIcon", IconsFactory.getOverlayIcon(null, imageIcon5, imageIcon2, 0), "CollapsiblePane.upIcon", IconsFactory.getOverlayIcon(null, imageIcon5, imageIcon3, 0), "CollapsiblePane.downIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon4, imageIcon2, 0), "CollapsiblePane.upIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon4, imageIcon3, 0), "CollapsiblePane.upMask", imageIcon3, "CollapsiblePane.downMask", imageIcon2, "CollapsiblePane.titleButtonBackground", imageIcon5, "CollapsiblePane.titleButtonBackground.emphasized", imageIcon4};
            _blueTheme.putDefaults(objectArray4);
        }
        objectArray2 = new Object[]{"control", new ColorUIResource(209, 222, 173), "controlLt", new ColorUIResource(244, 247, 222), "controlDk", new ColorUIResource(183, 198, 145), "controlShadow", new ColorUIResource(96, 128, 88), "TabbedPane.selectDk", new ColorUIResource(207, 114, 37), "TabbedPane.selectLt", new ColorUIResource(227, 145, 79), "OptionPane.bannerLt", new ColorUIResource(150, 185, 120), "OptionPane.bannerDk", new ColorUIResource(179, 214, 149), "OptionPane.bannerForeground", new ColorUIResource(255, 255, 255), "Separator.foreground", new ColorUIResource(96, 128, 88), "Separator.foregroundLt", new ColorUIResource(244, 247, 242), "Gripper.foreground", new ColorUIResource(81, 94, 51), "Gripper.foregroundLt", new ColorUIResource(255, 255, 255), "Chevron.backgroundLt", new ColorUIResource(176, 194, 140), "Chevron.backgroundDk", new ColorUIResource(96, 119, 107), "Divider.backgroundLt", new ColorUIResource(120, 142, 111), "Divider.backgroundDk", new ColorUIResource(73, 91, 67), "backgroundLt", new ColorUIResource(242, 240, 228), "backgroundDk", new ColorUIResource(217, 217, 167), "selection.border", new ColorUIResource(63, 93, 56), "MenuItem.background", new ColorUIResource(244, 244, 238), "DockableFrameTitlePane.backgroundLt", new ColorUIResource(237, 242, 212), "DockableFrameTitlePane.backgroundDk", new ColorUIResource(181, 196, 143), "DockableFrameTitlePane.activeForeground", new ColorUIResource(0, 0, 0), "DockableFrameTitlePane.inactiveForeground", new ColorUIResource(0, 0, 0), "DockableFrame.backgroundLt", new ColorUIResource(243, 242, 231), "DockableFrame.backgroundDk", new ColorUIResource(243, 242, 231), "CommandBar.titleBarBackground", new ColorUIResource(116, 134, 94)};
        _homeSteadTheme.putDefaults(objectArray2);
        if ((n & 2) != 0) {
            objectArray = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_homestead.png");
            imageIcon5 = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_mask.png");
            imageIcon4 = IconsFactory.getIcon(null, (ImageIcon)objectArray, 0, 0, 20, 20);
            imageIcon3 = IconsFactory.getIcon(null, (ImageIcon)objectArray, 20, 0, 20, 20);
            imageIcon2 = IconsFactory.getIcon(null, imageIcon5, 0, 0, 11, 11);
            imageIcon = IconsFactory.getIcon(null, imageIcon5, 0, 11, 11, 11);
            objectArray4 = new Object[]{"CollapsiblePane.contentBackground", new ColorUIResource(246, 246, 246), "CollapsiblePanes.backgroundLt", new ColorUIResource(204, 217, 173), "CollapsiblePanes.backgroundDk", new ColorUIResource(165, 189, 132), "CollapsiblePaneTitlePane.backgroundLt", new ColorUIResource(254, 252, 236), "CollapsiblePaneTitlePane.backgroundDk", new ColorUIResource(224, 231, 184), "CollapsiblePaneTitlePane.foreground", new ColorUIResource(86, 102, 45), "CollapsiblePaneTitlePane.foreground.focus", new ColorUIResource(114, 146, 29), "CollapsiblePaneTitlePane.backgroundLt.emphasized", new ColorUIResource(119, 140, 64), "CollapsiblePaneTitlePane.backgroundDk.emphasized", new ColorUIResource(150, 168, 103), "CollapsiblePaneTitlePane.foreground.emphasized", new ColorUIResource(255, 255, 255), "CollapsiblePaneTitlePane.foreground.focus.emphasized", new ColorUIResource(224, 231, 151), "CollapsiblePane.downIcon", IconsFactory.getOverlayIcon(null, imageIcon4, imageIcon2, 0), "CollapsiblePane.upIcon", IconsFactory.getOverlayIcon(null, imageIcon4, imageIcon, 0), "CollapsiblePane.downIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon3, imageIcon2, 0), "CollapsiblePane.upIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon3, imageIcon, 0), "CollapsiblePane.upMask", imageIcon, "CollapsiblePane.downMask", imageIcon2, "CollapsiblePane.titleButtonBackground", imageIcon4, "CollapsiblePane.titleButtonBackground.emphasized", imageIcon3};
            _homeSteadTheme.putDefaults(objectArray4);
        }
        objectArray = new Object[]{"control", new ColorUIResource(219, 218, 228), "controlLt", new ColorUIResource(243, 244, 250), "controlDk", new ColorUIResource(153, 151, 181), "controlShadow", new ColorUIResource(124, 124, 148), "TabbedPane.selectDk", new ColorUIResource(230, 139, 44), "TabbedPane.selectLt", new ColorUIResource(255, 200, 60), "OptionPane.bannerLt", new ColorUIResource(181, 195, 222), "OptionPane.bannerDk", new ColorUIResource(120, 140, 167), "OptionPane.bannerForeground", new ColorUIResource(255, 255, 255), "Separator.foreground", new ColorUIResource(110, 109, 143), "Separator.foregroundLt", new ColorUIResource(255, 255, 255), "Gripper.foreground", new ColorUIResource(84, 84, 117), "Gripper.foregroundLt", new ColorUIResource(255, 255, 255), "Chevron.backgroundLt", new ColorUIResource(179, 178, 200), "Chevron.backgroundDk", new ColorUIResource(118, 116, 146), "Divider.backgroundLt", new ColorUIResource(168, 167, 191), "Divider.backgroundDk", new ColorUIResource(119, 118, 151), "backgroundLt", new ColorUIResource(243, 243, 247), "backgroundDk", new ColorUIResource(215, 215, 229), "selection.border", new ColorUIResource(75, 75, 111), "MenuItem.background", new ColorUIResource(253, 250, 255), "DockableFrameTitlePane.backgroundLt", new ColorUIResource(240, 240, 248), "DockableFrameTitlePane.backgroundDk", new ColorUIResource(147, 145, 176), "DockableFrameTitlePane.activeForeground", new ColorUIResource(0, 0, 0), "DockableFrameTitlePane.inactiveForeground", new ColorUIResource(0, 0, 0), "DockableFrame.backgroundLt", new ColorUIResource(238, 238, 244), "DockableFrame.backgroundDk", new ColorUIResource(238, 238, 244), "CommandBar.titleBarBackground", new ColorUIResource(122, 121, 153)};
        _metallicTheme.putDefaults(objectArray);
        if ((n & 2) != 0) {
            imageIcon5 = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_metallic.png");
            imageIcon4 = IconsFactory.getImageIcon(Office2003WindowsUtils.class, "icons/collapsible_pane_mask.png");
            imageIcon3 = IconsFactory.getIcon(null, imageIcon5, 0, 0, 20, 20);
            imageIcon2 = IconsFactory.getIcon(null, imageIcon5, 20, 0, 20, 20);
            imageIcon = IconsFactory.getIcon(null, imageIcon4, 0, 0, 11, 11);
            ImageIcon imageIcon6 = IconsFactory.getIcon(null, imageIcon4, 0, 11, 11, 11);
            objectArray4 = new Object[]{"CollapsiblePane.contentBackground", new ColorUIResource(240, 241, 245), "CollapsiblePanes.backgroundLt", new ColorUIResource(196, 200, 212), "CollapsiblePanes.backgroundDk", new ColorUIResource(177, 179, 200), "CollapsiblePaneTitlePane.backgroundLt", new ColorUIResource(255, 255, 255), "CollapsiblePaneTitlePane.backgroundDk", new ColorUIResource(214, 215, 224), "CollapsiblePaneTitlePane.foreground", new ColorUIResource(63, 61, 61), "CollapsiblePaneTitlePane.foreground.focus", new ColorUIResource(126, 124, 124), "CollapsiblePaneTitlePane.backgroundLt.emphasized", new ColorUIResource(119, 119, 145), "CollapsiblePaneTitlePane.backgroundDk.emphasized", new ColorUIResource(180, 182, 199), "CollapsiblePaneTitlePane.foreground.emphasized", new ColorUIResource(255, 255, 255), "CollapsiblePaneTitlePane.foreground.focus.emphasized", new ColorUIResource(230, 230, 230), "CollapsiblePane.downIcon", IconsFactory.getOverlayIcon(null, imageIcon3, imageIcon, 0), "CollapsiblePane.upIcon", IconsFactory.getOverlayIcon(null, imageIcon3, imageIcon6, 0), "CollapsiblePane.downIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon2, imageIcon, 0), "CollapsiblePane.upIcon.emphasized", IconsFactory.getOverlayIcon(null, imageIcon2, imageIcon6, 0), "CollapsiblePane.upMask", imageIcon6, "CollapsiblePane.downMask", imageIcon, "CollapsiblePane.titleButtonBackground", imageIcon3, "CollapsiblePane.titleButtonBackground.emphasized", imageIcon2};
            _metallicTheme.putDefaults(objectArray4);
        }
    }
}

