/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.A.J;
import twaver.base.A.H.I;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.network.SVGContext;

public class SVGPieChart
extends AbstractSVGChart {
    private boolean \u012b = TUIManager.getBoolean("tchart.hollow");
    private double \u0125 = TUIManager.getDouble("tchart.hollow.percent");
    private boolean \u012a = TUIManager.getBoolean("tchart.value.text.percent");
    private double \u0129 = TUIManager.getDouble("tchart.start.angle");
    private Color \u0127 = TUIManager.getColor("tchart.shadow.color");
    private boolean \u012d = TUIManager.getBoolean("tchart.pie.3d");
    private double \u012e = TUIManager.getDouble("tchart.pie.value.text.position.scale");
    private Rectangle2D.Double \u0124;
    private double \u012c = 0.0;
    private double \u0128 = 0.0;
    private double \u0123 = 0.0;
    private double \u0126 = 0.0;

    public SVGPieChart() {
        this(new TDataBox());
    }

    public SVGPieChart(TDataBox box) {
        super(box, null, null);
    }

    public SVGPieChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor, null);
    }

    public SVGPieChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    protected boolean isAppearable(Element element) {
        return true;
    }

    protected void calculate() {
        Element element;
        int i2;
        this.sum = 0.0;
        this.proportionsOfSum.clear();
        int count = this.publishedElements.size();
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            double value = this.getValue(element);
            this.sum += value;
        }
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            if (this.sum == 0.0) {
                this.proportionsOfSum.add(new Double(0.0));
                continue;
            }
            this.proportionsOfSum.add(new Double(this.getValue(element) / this.sum));
        }
    }

    private Shape A(double x, double y, double w, double h2, double start, double extent) {
        Arc2D.Double shape = new Arc2D.Double(x, y, w, h2, start, extent, 2);
        if (this.\u012b) {
            Area area = new Area(shape);
            double cx = shape.getCenterX();
            double cy = shape.getCenterY();
            double sw = shape.getWidth() * this.\u0125;
            double sh = shape.getHeight() * this.\u0125;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(cx - sw / 2.0, cy - sh / 2.0, sw, sh);
            area.subtract(new Area(ellipse));
            return area;
        }
        return shape;
    }

    public StringBuffer toSVGContent(SVGContext context, int width, int height) {
        StringBuffer result = new StringBuffer();
        this.paintChart(context, result, width, height);
        return result;
    }

    public void paintChart(SVGContext context, StringBuffer result, int width, int height) {
        this.calculateLabelSize();
        this.backgroundBounds.x = (int)((double)this.xGap + this.\u012c);
        this.backgroundBounds.y = (int)((double)this.yGap + this.\u0128);
        this.backgroundBounds.width = (int)((double)(width - 2 * this.xGap) - 2.0 * this.\u012c);
        this.backgroundBounds.height = (int)((double)((height -= this.shadowOffset) - 2 * this.yGap + this.shadowOffset) - 2.0 * this.\u0128);
        this.\u0123 = 0.0;
        this.\u0126 = 0.0;
        if (this.\u012e >= 1.0) {
            this.\u0123 = ((double)(width - 2 * this.xGap) - 2.0 * this.\u012c) / 2.0 * (this.\u012e - 1.0);
            this.\u0126 = ((double)(height - 2 * this.yGap) - 2.0 * this.\u0128) / 2.0 * (this.\u012e - 1.0);
            this.\u0124 = new Rectangle2D.Double((double)this.xGap + this.\u012c + this.\u0123, (double)this.yGap + this.\u0128 + this.\u0126, (double)(width - 2 * this.xGap) - 2.0 * this.\u012c - 2.0 * this.\u0123, (double)(height - 2 * this.yGap) - 2.0 * this.\u0128 - 2.0 * this.\u0126);
        } else {
            this.\u0124 = new Rectangle2D.Double(this.xGap, this.yGap, width - 2 * this.xGap, height - 2 * this.yGap);
        }
        this.paintBackground(context, result);
        if (this.sum == 0.0) {
            return;
        }
        if (this.is3D()) {
            this.A(context, result, width, height);
        } else {
            this.B(context, result, width, height);
        }
    }

    protected void calculateLabelSize() {
        int count = this.publishedElements.size();
        this.\u012c = 0.0;
        this.\u0128 = 0.0;
        if (this.\u012e < 1.0) {
            return;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Dimension size;
            Element element = (Element)this.publishedElements.get(i2);
            String text = this.getFormatedText(element, this.getValue(element));
            Double proportion = (Double)this.proportionsOfSum.get(i2);
            if (this.\u012a) {
                text = text + "(" + (int)(proportion * 100.0) + "%)";
            }
            if (this.\u012c < (size = this.A(text, this.valueTextFont)).getWidth()) {
                this.\u012c = size.getWidth();
            }
            if (!(this.\u0128 < size.getHeight())) continue;
            this.\u0128 = size.getHeight();
        }
    }

    private void B(SVGContext context, StringBuffer result, int width, int height) {
        int offset;
        double value;
        Double proportion;
        Element element;
        int i2;
        int count = this.publishedElements.size();
        double start = this.\u0129;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (this.isAppearable(element)) {
                offset = element.isSelected() ? -this.selectedOffset : 0;
                Shape pieShadow = this.A(this.\u0124.getX(), this.\u0124.getY() + (double)this.shadowOffset + (double)offset, this.\u0124.getWidth(), this.\u0124.getHeight(), start, value);
                I.A(context, result, pieShadow, this.\u0127);
            }
            start += value;
        }
        start = this.\u0129;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (!element.isSelected()) {
                this.A(context, result, width, height, start, element, value);
            }
            start += value;
        }
        start = this.\u0129;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (element.isSelected()) {
                this.A(context, result, width, height, start, element, value);
            }
            start += value;
        }
        start = this.\u0129;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfSum.get(i2);
            value = 360.0 * proportion;
            if (value == 0.0) continue;
            if (this.isAppearable(element)) {
                int n2 = offset = element.isSelected() ? -this.selectedOffset : 0;
                if (this.valueTextVisible) {
                    String text = this.getFormatedText(element, this.getValue(element));
                    if (this.\u012a) {
                        text = text + "(" + (int)(proportion * 100.0) + "%)";
                    }
                    if (text != null) {
                        Arc2D.Double pie = new Arc2D.Double(this.\u0124.getX(), this.\u0124.getY() + (double)offset, this.\u0124.getWidth(), this.\u0124.getHeight(), start, value, 2);
                        double cx = pie.getCenterX();
                        double cy = pie.getCenterY();
                        if (this.\u012e >= 1.0) {
                            Arc2D.Double s2 = new Arc2D.Double(this.\u0124.getX() - this.\u0123, this.\u0124.getY() + (double)offset - this.\u0126, this.\u0124.getWidth() + 2.0 * this.\u0123, this.\u0124.getHeight() + 2.0 * this.\u0126, start, value / 2.0, 2);
                            int position = this.getLabelTextPosition(-(start + value / 2.0));
                            Point2D p2 = s2.getEndPoint();
                            I.A(context, result, text, this.valueTextColor, this.valueTextFont, (int)p2.getX(), (int)p2.getY(), position);
                        } else {
                            double sw = pie.getWidth() * this.\u012e;
                            double sh = pie.getHeight() * this.\u012e;
                            Arc2D.Double s2 = new Arc2D.Double(cx - sw / 2.0, cy - sh / 2.0, sw, sh, pie.getAngleStart() + pie.getAngleExtent() / 2.0, 1.0, 2);
                            Point2D p3 = s2.getStartPoint();
                            I.A(context, result, text, this.valueTextColor, this.valueTextFont, (int)p3.getX(), (int)p3.getY(), 1);
                        }
                    }
                }
            }
            start += value;
        }
    }

    protected int getLabelTextPosition(double angle) {
        angle = (angle % 360.0 + 360.0) % 360.0;
        int position = 1;
        if (angle == 0.0) {
            position = 5;
        } else if (angle == 180.0) {
            position = 4;
        } else if (angle == 90.0) {
            position = 3;
        } else if (angle == 270.0) {
            position = 2;
        } else if (angle > 270.0 && angle < 360.0) {
            position = 7;
        } else if (angle > 180.0 && angle < 270.0) {
            position = 6;
        } else if (angle > 90.0 && angle < 180.0) {
            position = 8;
        } else if (angle > 0.0 && angle < 90.0) {
            position = 9;
        }
        return position;
    }

    private void A(SVGContext context, StringBuffer result, int width, int height, double start, Element element, double value) {
        if (!this.isAppearable(element)) {
            return;
        }
        int offset = element.isSelected() ? -this.selectedOffset : 0;
        Shape shape = this.A(this.\u0124.getX(), this.\u0124.getY() + (double)offset, this.\u0124.getWidth(), this.\u0124.getHeight(), start, value);
        I.A(context, result, shape, this.getColor(element));
        if (element.isSelected()) {
            I.A(context, result, shape, this.getSelectedColor(element), this.getSelectedStroke(element));
        }
    }

    public double getStartAngle() {
        return this.\u0129;
    }

    public void setStartAngle(double startAngle) {
        this.\u0129 = startAngle;
    }

    public boolean isValueTextPercent() {
        return this.\u012a;
    }

    public void setValueTextPercent(boolean valueTextPercent) {
        this.\u012a = valueTextPercent;
    }

    public Color getShadowColor() {
        return this.\u0127;
    }

    public void setShadowColor(Color shadowColor) {
        this.\u0127 = shadowColor;
    }

    public boolean isHollow() {
        return this.\u012b;
    }

    public void setHollow(boolean hollow) {
        this.\u012b = hollow;
    }

    public double getHollowPercent() {
        return this.\u0125;
    }

    public void setHollowPercent(double hollowPercent) {
        this.\u0125 = hollowPercent;
    }

    private void A(SVGContext context, StringBuffer result, int width, int height) {
        _B painter = new _B(this);
        painter.A(context, result, width, height);
    }

    private static boolean A(double betweenAngle, double start, double extend) {
        double distance = 360.0 - start;
        start = 0.0;
        return extend > (betweenAngle = SVGPieChart.A(betweenAngle + distance)) - start;
    }

    public boolean is3D() {
        return this.\u012d;
    }

    public void set3D(boolean is3D) {
        this.\u012d = is3D;
    }

    public double getValueTextPositionScale() {
        return this.\u012e;
    }

    public void setValueTextPositionScale(double valueTextPositionScale) {
        this.\u012e = valueTextPositionScale;
    }

    private static double A(double s1) {
        if ((s1 %= 360.0) < 0.0) {
            s1 += 360.0;
        }
        return s1;
    }

    class _A {
        private double B = 0.0;
        private double E = 0.0;
        private int D = 0;
        private Element A = null;
        private _A C = null;

        public _A(_A parent, int index, Element element, double startAngle, double extendAngle) {
            this.A = element;
            this.B = startAngle;
            this.E = extendAngle;
            this.C = parent;
        }

        public _A(int index, Element element, double startAngle, double extendAngle) {
            this(null, index, element, startAngle, extendAngle);
        }

        public _A A() {
            return this.C;
        }

        public void A(_A parent) {
            this.C = parent;
        }

        public int B() {
            return this.D;
        }

        public void A(int elementIndex) {
            this.D = elementIndex;
        }

        public Element D() {
            return this.A;
        }

        public void A(Element element) {
            this.A = element;
        }

        public double C() {
            this.B %= 360.0;
            if (this.B < 0.0) {
                this.B += 360.0;
            }
            return this.B;
        }

        public void B(double startAngle) {
            this.B = startAngle;
        }

        public double E() {
            return this.E;
        }

        public void A(double extendAngle) {
            this.E = extendAngle;
        }
    }

    class _B {
        SVGPieChart F;
        Area H = null;
        Area D = null;
        Area E = null;
        private Comparator A = new Comparator(this){
            private final /* synthetic */ _B this$1;
            {
                this.this$1 = this$1;
            }

            public int compare(Object o1, Object o2) {
                _A item1 = (_A)o1;
                _A item2 = (_A)o2;
                double s1 = SVGPieChart.access$000(item1.C());
                double e1 = item1.E();
                double s2 = SVGPieChart.access$000(item2.C());
                double e2 = item2.E();
                if (s1 >= 90.0 && s1 <= 270.0 && s2 >= 90.0 && s2 <= 270.0) {
                    if (s1 == s2) {
                        if (e1 == 0.0 && e2 == 0.0) {
                            if (item1.B() < item2.B()) {
                                return -1;
                            }
                            return 1;
                        }
                        if (e1 == 0.0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (s1 < s2) {
                        return -1;
                    }
                    return 1;
                }
                if ((s1 >= 270.0 || s1 <= 90.0) && (s2 >= 270.0 || s2 <= 90.0)) {
                    if (s1 == s2) {
                        if (e1 == 0.0 && e2 == 0.0) {
                            if (item1.B() < item2.B()) {
                                return 1;
                            }
                            return -1;
                        }
                        if (e1 == 0.0) {
                            return 1;
                        }
                        return -1;
                    }
                    if (SVGPieChart.access$000(s1 + 90.0) > SVGPieChart.access$000(s2 + 90.0)) {
                        return -1;
                    }
                    return 1;
                }
                return 1;
            }

            public boolean equals(Object obj) {
                return false;
            }
        };
        double J;
        double B;
        double K;
        double I;
        double G;
        AffineTransform C = null;

        _B(SVGPieChart chart) {
            this.F = chart;
            this.C = AffineTransform.getTranslateInstance(0.0, chart.getShadowOffset());
        }

        void A(int width, int height) {
            this.J = this.F.getHollowPercent();
            if (!this.F.isHollow()) {
                this.J = 0.0;
            }
            this.I = (double)this.F.getXGap() + SVGPieChart.this.\u012c + SVGPieChart.this.\u0123;
            this.G = (double)this.F.getYGap() + SVGPieChart.this.\u0128 + SVGPieChart.this.\u0126;
            width = (int)((double)width - this.I * 2.0);
            height = (int)((double)height - 2.0 * this.G);
            if (width <= 0) {
                width = 1;
            }
            if (height <= 0) {
                height = 1;
            }
            this.B = width;
            this.K = height;
        }

        void A(SVGContext context, StringBuffer result, int width, int height) {
            int i2;
            _A _item;
            double d2;
            _A item;
            int i3;
            this.A(width, height);
            ArrayList<_A> items3D = new ArrayList<_A>();
            ArrayList<_A> items3DSplit = new ArrayList<_A>();
            double start = SVGPieChart.A(this.F.getStartAngle());
            double extendTotal = 0.0;
            int index = 0;
            block0: for (i3 = 0; i3 < SVGPieChart.this.publishedElements.size(); ++i3) {
                Element element = (Element)SVGPieChart.this.publishedElements.get(i3);
                double extend = i3 == SVGPieChart.this.publishedElements.size() - 1 ? 360.0 - extendTotal : 360.0 * SVGPieChart.this.getValue(element) / this.F.sum;
                extendTotal += extend;
                _A parent = new _A(i3, element, start, extend);
                items3DSplit.add(parent);
                int startI = (int)start / 90;
                for (int ii = 0; ii < 5; ++ii) {
                    double betweenAngle = 90 * (startI = (startI + 1) % 4);
                    if (SVGPieChart.A(betweenAngle, start, extend)) {
                        if (items3DSplit == null) {
                            items3DSplit = new ArrayList();
                        }
                        double _extend = SVGPieChart.A(betweenAngle - start);
                        items3D.add(new _A(parent, index++, element, start, _extend));
                        start = betweenAngle;
                        extend -= _extend;
                        continue;
                    }
                    _A item2 = new _A(parent.E() > extend ? parent : null, index++, element, start, extend);
                    items3D.add(item2);
                    start = SVGPieChart.A(start + extend);
                    continue block0;
                }
            }
            Collections.sort(items3D, this.A);
            for (i3 = 0; i3 < items3D.size(); ++i3) {
                item = (_A)items3D.get(i3);
                if (!SVGPieChart.this.isAppearable(item.D())) continue;
                this.A(context, result, width, height, item, true, true, true, false, false);
            }
            for (i3 = 0; i3 < items3DSplit.size(); ++i3) {
                item = (_A)items3DSplit.get(i3);
                if (!this.F.isAppearable(item.D()) || !SVGPieChart.A(90.0, item.C(), item.E())) continue;
                d2 = 1.0;
                double s = item.C() < 90.0 - d2 || item.C() > 90.0 ? 90.0 - d2 : item.C();
                double extend = item.C() + item.E() > 90.0 + d2 ? 90.0 - s + d2 : item.C() + item.E() - s;
                _item = new _A(item, 0, item.D(), s, extend);
                this.A(context, result, width, height, _item, true, false, false, false, false);
            }
            for (i3 = 0; i3 < items3DSplit.size(); ++i3) {
                item = (_A)items3DSplit.get(i3);
                if (!this.F.isAppearable(item.D()) || !SVGPieChart.A(270.0, item.C(), item.E())) continue;
                d2 = 2.0;
                double s = item.C() <= 270.0 - d2 || item.C() > 270.0 ? 270.0 - d2 : item.C();
                double extend = SVGPieChart.A(item.C() + item.E()) > 270.0 + d2 || SVGPieChart.A(item.C() + item.E()) < item.C() ? 270.0 - s + d2 : SVGPieChart.A(item.C() + item.E()) - s;
                _item = new _A(item, 0, item.D(), s, extend);
                this.A(context, result, width, height, _item, false, false, true, false, false);
            }
            Area allTopArea = new Area();
            for (i2 = 0; i2 < items3DSplit.size(); ++i2) {
                _A item3 = (_A)items3DSplit.get(i2);
                if (!this.F.isAppearable(item3.D())) continue;
                Area topArea = this.A(context, result, width, height, item3, false, false, false, true, false);
                allTopArea.add(topArea);
                if (!item3.D().isSelected()) continue;
                twaver.base.A.H.I.A(context, result, topArea, SVGPieChart.this.getSelectedColor(item3.D()), SVGPieChart.this.getSelectedStroke(item3.D()));
            }
            twaver.base.A.H.I.A(context, result, allTopArea, new Color(220, 220, 220, 100));
            for (i2 = 0; i2 < items3DSplit.size(); ++i2) {
                _A item4 = (_A)items3DSplit.get(i2);
                if (!this.F.isAppearable(item4.D())) continue;
                this.A(context, result, width, height, item4, false, false, false, false, true);
            }
        }

        private Area A(SVGContext context, StringBuffer result, int width, int height, _A item, boolean inner, boolean cut, boolean outter, boolean top, boolean label) {
            Area resultArea = new Area();
            if (item != null) {
                double xP = this.I;
                double yP = this.G;
                if (item.D().isSelected()) {
                    _A parent = item.A();
                    if (parent == null) {
                        parent = item;
                    }
                    double diagonalAngle = parent.C() + parent.E() / 2.0;
                    double scale = (double)(this.F.getSelectedOffset() * 2) / (double)(width > height ? width : height);
                    xP += scale * (double)width / 2.0 * Math.cos(diagonalAngle * Math.PI / 180.0);
                    yP -= scale * (double)height / 2.0 * Math.sin(diagonalAngle * Math.PI / 180.0);
                }
                double extendP = item.E();
                double s1P = SVGPieChart.A(item.C());
                double endP = SVGPieChart.A(s1P + item.E());
                Color colorP = this.F.getColor(item.D());
                if (cut) {
                    Area cutSide = this.A(context, result, item, s1P, endP, extendP, xP, yP, colorP);
                    resultArea.add(cutSide);
                }
                if (outter) {
                    Area outterSide = this.D(context, result, item, s1P, endP, extendP, xP, yP, colorP);
                    resultArea.add(outterSide);
                }
                if (inner) {
                    Area innerSide = this.C(context, result, item, s1P, endP, extendP, xP, yP, colorP);
                    resultArea.add(innerSide);
                }
                if (top) {
                    Area topSide = this.B(context, result, item, s1P, endP, extendP, xP, yP, colorP);
                    resultArea.add(topSide);
                }
                if (label) {
                    this.A(context, result, item, xP, yP);
                }
            }
            return resultArea;
        }

        private Area A(SVGContext context, StringBuffer sb, _A item, double start, double end, double extend, double x, double y, Color color) {
            Area resultArea = new Area();
            Arc2D.Double topArcReal = new Arc2D.Double(x, y, this.B, this.K, start, extend, 0);
            Arc2D.Double topHollowArcReal = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, start, extend, 0);
            if (extend != 360.0) {
                GeneralPath startCutSide;
                if ((item.C() + 90.0) % 360.0 < 180.0) {
                    startCutSide = new GeneralPath();
                    startCutSide.moveTo((float)topArcReal.getStartPoint().getX(), (float)topArcReal.getStartPoint().getY());
                    startCutSide.lineTo((float)topArcReal.getStartPoint().getX(), (float)(topArcReal.getStartPoint().getY() + (double)SVGPieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getStartPoint().getX(), (float)(topHollowArcReal.getStartPoint().getY() + (double)SVGPieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getStartPoint().getX(), (float)topHollowArcReal.getStartPoint().getY());
                    startCutSide.closePath();
                    Area cut = new Area(startCutSide);
                    twaver.base.A.H.I.A(context, sb, cut, color.darker().darker());
                }
                if (end > 90.0 && end < 270.0) {
                    startCutSide = new GeneralPath();
                    startCutSide.moveTo((float)topArcReal.getEndPoint().getX(), (float)topArcReal.getEndPoint().getY());
                    startCutSide.lineTo((float)topArcReal.getEndPoint().getX(), (float)(topArcReal.getEndPoint().getY() + (double)SVGPieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getEndPoint().getX(), (float)(topHollowArcReal.getEndPoint().getY() + (double)SVGPieChart.this.getShadowOffset()));
                    startCutSide.lineTo((float)topHollowArcReal.getEndPoint().getX(), (float)topHollowArcReal.getEndPoint().getY());
                    startCutSide.closePath();
                    twaver.base.A.H.I.A(context, sb, startCutSide, color.darker().darker());
                    resultArea.add(new Area(startCutSide));
                }
            }
            return resultArea;
        }

        private Area C(SVGContext context, StringBuffer sb, _A item, double s1, double end1, double extend, double x, double y, Color color) {
            Area innerSide = new Area();
            if (extend != 360.0) {
                if (s1 < 180.0) {
                    Arc2D.Double topHollowArcRealT = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, s1, end1 > 180.0 || end1 < s1 ? 180.0 - s1 : extend, 0);
                    GeneralPath startCutSide = new GeneralPath();
                    startCutSide.append(topHollowArcRealT, false);
                    startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topHollowArcRealT)), true);
                    startCutSide.closePath();
                    innerSide.add(new Area(startCutSide));
                }
                if (end1 < s1) {
                    Arc2D.Double topHollowArcRealT2 = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, 0.0, end1 > 180.0 ? 180.0 : end1, 0);
                    GeneralPath startCutSide2 = new GeneralPath();
                    startCutSide2.append(topHollowArcRealT2, false);
                    startCutSide2.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topHollowArcRealT2)), true);
                    startCutSide2.closePath();
                    innerSide.add(new Area(startCutSide2));
                }
            } else {
                Arc2D.Double topHollowArcRealT = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, 0.0, 180.0, 0);
                GeneralPath startCutSide = new GeneralPath();
                startCutSide.append(topHollowArcRealT, false);
                startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topHollowArcRealT)), true);
                startCutSide.closePath();
                innerSide.add(new Area(startCutSide));
            }
            twaver.base.A.H.I.A(context, sb, innerSide, color.darker());
            return innerSide;
        }

        private Area D(SVGContext context, StringBuffer sb, _A item, double s1, double end1, double extend, double x, double y, Color color) {
            Area outterSide = new Area();
            if (extend != 360.0) {
                GeneralPath startCutSide;
                Arc2D.Double topArcRealT;
                if (end1 > 180.0) {
                    topArcRealT = new Arc2D.Double(x, y, this.B, this.K, s1 < 180.0 || s1 > end1 ? 180.0 : s1, end1 - (s1 < 180.0 || s1 > end1 ? 180.0 : s1), 0);
                    startCutSide = new GeneralPath();
                    startCutSide.append(topArcRealT, false);
                    startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topArcRealT)), true);
                    startCutSide.closePath();
                    outterSide.add(new Area(startCutSide));
                }
                if (end1 < s1) {
                    topArcRealT = new Arc2D.Double(x, y, this.B, this.K, s1 < 180.0 ? 180.0 : s1, 360.0 - (s1 < 180.0 ? 180.0 : s1), 0);
                    startCutSide = new GeneralPath();
                    startCutSide.append(topArcRealT, false);
                    startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topArcRealT)), true);
                    startCutSide.closePath();
                    outterSide.add(new Area(startCutSide));
                }
            } else {
                Arc2D.Double topArcRealT = new Arc2D.Double(x, y, this.B, this.K, 180.0, 180.0, 0);
                GeneralPath startCutSide = new GeneralPath();
                startCutSide.append(topArcRealT, false);
                startCutSide.append(twaver.base.A.A.J.A(this.C.createTransformedShape(topArcRealT)), true);
                startCutSide.closePath();
                outterSide.add(new Area(startCutSide));
            }
            twaver.base.A.H.I.A(context, sb, outterSide, color.darker());
            return outterSide;
        }

        private Area B(SVGContext context, StringBuffer sb, _A item, double s1, double end1, double extend, double x, double y, Color color) {
            Arc2D.Double topArcReal = new Arc2D.Double(x, y, this.B, this.K, item.C(), extend, 0);
            Arc2D.Double topHollowArcReal = new Arc2D.Double(x + this.B / 2.0 * (1.0 - this.J), y + this.K / 2.0 * (1.0 - this.J), this.B * this.J, this.K * this.J, item.C(), extend, 0);
            GeneralPath sideShape = new GeneralPath();
            sideShape.append(topArcReal, false);
            sideShape.append(twaver.base.A.A.J.A(topHollowArcReal), true);
            sideShape.closePath();
            twaver.base.A.H.I.A(context, sb, new Area(sideShape), color);
            this.A(context, sb, item, x, y);
            return new Area(sideShape);
        }

        private void A(SVGContext context, StringBuffer sb, _A item, double x, double y) {
            if (this.F.valueTextVisible) {
                Element element = item.D();
                double proportion = SVGPieChart.this.getValue(element) / this.F.sum;
                String text = this.F.getFormatedText(element, SVGPieChart.this.getValue(element));
                if (this.F.isValueTextPercent()) {
                    text = text + "(" + (int)(proportion * 100.0) + "%)";
                }
                if (text != null) {
                    if (SVGPieChart.this.\u012e >= 1.0) {
                        Arc2D.Double arcText = new Arc2D.Double(x - SVGPieChart.this.\u0123, y - SVGPieChart.this.\u0126, this.B + 2.0 * SVGPieChart.this.\u0123, this.K + 2.0 * SVGPieChart.this.\u0126, item.C(), item.E() / 2.0, 0);
                        Point2D p2 = arcText.getEndPoint();
                        int position = SVGPieChart.this.getLabelTextPosition(-(item.C() + item.E() / 2.0));
                        twaver.base.A.H.I.A(context, sb, text, SVGPieChart.this.valueTextColor, SVGPieChart.this.valueTextFont, (int)p2.getX(), (int)p2.getY(), position);
                    } else {
                        double h2 = SVGPieChart.this.\u012e;
                        Arc2D.Double arcText = new Arc2D.Double(x + this.B / 2.0 * (1.0 - h2), y + this.K / 2.0 * (1.0 - h2), this.B * h2, this.K * h2, item.C(), item.E() / 2.0, 0);
                        Point2D p3 = arcText.getEndPoint();
                        twaver.base.A.H.I.A(context, sb, text, SVGPieChart.this.valueTextColor, SVGPieChart.this.valueTextFont, (int)p3.getX(), (int)p3.getY(), 1);
                    }
                }
            }
        }
    }
}

