/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.EdgeMap;
import y.layout.CompositeLayoutStage;
import y.layout.LayoutStage;
import y.layout.organic.RemoveOverlapsLayoutStage;
import y.layout.router.OrganicEdgeRouter;
import y.module.LayoutModule;
import y.option.OptionHandler;
import y.view.Selections;

public class OrganicEdgeRouterModule
extends LayoutModule {
    private static final String ee = "ORGANIC_EDGE_ROUTER";
    private static final String eh = "MINIMAL_NODE_DISTANCE";
    private static final String eg = "USE_BENDS";
    private static final String ei = "ROUTE_ONLY_NECESSARY";
    private static final String ef = "SELECTION_ONLY";

    public OrganicEdgeRouterModule() {
        super(ee, "Sebastian Mueller", "Routes edges organically");
    }

    public OptionHandler createOptionHandler() {
        OrganicEdgeRouter organicEdgeRouter = new OrganicEdgeRouter();
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.addBool(ef, false);
        optionHandler.addInt(eh, (int)organicEdgeRouter.getMinimalDistance(), 10, 300);
        optionHandler.addBool(eg, organicEdgeRouter.isUsingBends());
        optionHandler.addBool(ei, !organicEdgeRouter.isRoutingAll());
        return optionHandler;
    }

    protected void mainrun() {
        OrganicEdgeRouter organicEdgeRouter = new OrganicEdgeRouter();
        OptionHandler optionHandler = this.getOptionHandler();
        organicEdgeRouter.setMinimalDistance(optionHandler.getInt(eh));
        organicEdgeRouter.setUsingBends(optionHandler.getBool(eg));
        organicEdgeRouter.setRoutingAll(!optionHandler.getBool(ei));
        RemoveOverlapsLayoutStage removeOverlapsLayoutStage = new RemoveOverlapsLayoutStage(0.0);
        LayoutStage layoutStage = organicEdgeRouter.createNodeEnlargementStage();
        CompositeLayoutStage compositeLayoutStage = new CompositeLayoutStage();
        compositeLayoutStage.appendStage(organicEdgeRouter);
        compositeLayoutStage.appendStage(layoutStage);
        compositeLayoutStage.appendStage(removeOverlapsLayoutStage);
        if (optionHandler.getBool(ef)) {
            EdgeMap edgeMap = Selections.createSelectionEdgeMap(this.getGraph2D());
            this.getGraph2D().addDataProvider(OrganicEdgeRouter.ROUTE_EDGE_DPKEY, edgeMap);
            this.launchLayouter(compositeLayoutStage, true);
            this.getGraph2D().removeDataProvider(OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
        } else {
            this.launchLayouter(compositeLayoutStage, true);
        }
    }
}

