/*
 * Decompiled with CFR 0.152.
 */
package twaver.animate;

import java.awt.geom.Point2D;
import java.util.Map;
import twaver.Element;
import twaver.animate.AnimateProperty;

public class AnimateCenterLocation
extends AnimateProperty {
    public AnimateCenterLocation(Map newCenterLocations) {
        this(newCenterLocations, null);
    }

    public AnimateCenterLocation(Map newCenterLocations, Runnable runnable) {
        this(newCenterLocations, runnable, -1, -1);
    }

    public AnimateCenterLocation(Map newCenterLocations, Runnable runnable, int stepSize, int sleep) {
        super(newCenterLocations, runnable, stepSize, sleep);
    }

    public Object getPropertyValue(Element element) {
        return element.getCenterLocation();
    }

    public void step(int stepIndex, Element element, Object oldPropertyValue, Object newPropertyValue) {
        Point2D oldLocation = (Point2D)oldPropertyValue;
        Point2D newLocation = (Point2D)newPropertyValue;
        double x = oldLocation.getX() + (double)stepIndex * (newLocation.getX() - oldLocation.getX()) / (double)this.stepSize;
        double y = oldLocation.getY() + (double)stepIndex * (newLocation.getY() - oldLocation.getY()) / (double)this.stepSize;
        element.setCenterLocation(x, y);
    }
}

