/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree.lazyloader;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.tree.TreeController;
import com.nepxion.swing.tree.lazyloader.ILazyLoaderAdapter;
import com.nepxion.swing.tree.lazyloader.ILazyLoaderTree;
import com.nepxion.swing.tree.lazyloader.JLazyLoaderTreeNode;
import com.nepxion.swing.tree.lazyloader.LoadingTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class LazyLoaderTreeController
extends TreeController {
    public static JSecurityAction getLoadAction(final ILazyLoaderTree lazyLoaderTree, final ILazyLoaderAdapter lazyLoaderAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("load"), IconFactory.getSwingIcon("stereo/control_play_16.png"), SwingLocale.getString("load") + SwingLocale.getString("children_nodes")){

            @Override
            public void execute(ActionEvent e) {
                boolean isMultiLoadable = LazyLoaderTreeController.isMultiLoadable(lazyLoaderTree);
                if (!isMultiLoadable) {
                    return;
                }
                TreeNode[] treeNodes = lazyLoaderTree.getSelectionTreeNodes();
                if (!lazyLoaderAdapter.loadPermitted(treeNodes)) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node_selection") + SwingLocale.getString("load_no_permission"), SwingLocale.getString("warning"), 2);
                    return;
                }
                lazyLoaderTree.getLazyLoader().setRecursive(false);
                lazyLoaderTree.load(treeNodes);
                lazyLoaderAdapter.load(treeNodes);
            }
        };
        KeyStrokeManager.registerComponent((JComponent)((JTree)((Object)lazyLoaderTree)), (ActionListener)action, 114);
        return action;
    }

    public static JSecurityAction getLoadGrandchildrenAction(final ILazyLoaderTree lazyLoaderTree, final ILazyLoaderAdapter lazyLoaderAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("load") + SwingLocale.getString("grandchildren_nodes"), IconFactory.getSwingIcon("stereo/control_play_16.png"), SwingLocale.getString("load") + SwingLocale.getString("grandchildren_nodes")){

            @Override
            public void execute(ActionEvent e) {
                boolean isMultiLoadable = LazyLoaderTreeController.isMultiLoadable(lazyLoaderTree);
                if (!isMultiLoadable) {
                    return;
                }
                TreeNode[] treeNodes = lazyLoaderTree.getSelectionTreeNodes();
                if (!lazyLoaderAdapter.loadPermitted(treeNodes)) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node_selection") + SwingLocale.getString("load_no_permission"), SwingLocale.getString("warning"), 2);
                    return;
                }
                lazyLoaderTree.getLazyLoader().setRecursive(false);
                lazyLoaderTree.loadGrandchildren(treeNodes);
                lazyLoaderAdapter.loadGrandchildren(treeNodes);
            }
        };
        return action;
    }

    public static JSecurityAction getLoadAllAction(final ILazyLoaderTree lazyLoaderTree, final ILazyLoaderAdapter lazyLoaderAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("load") + SwingLocale.getString("all_nodes"), IconFactory.getSwingIcon("stereo/control_play_16.png"), SwingLocale.getString("load") + SwingLocale.getString("all_nodes")){

            @Override
            public void execute(ActionEvent e) {
                if (!lazyLoaderAdapter.loadPermitted(null)) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node_selection") + SwingLocale.getString("load_no_permission"), SwingLocale.getString("warning"), 2);
                    return;
                }
                lazyLoaderTree.getLazyLoader().setRecursive(true);
                lazyLoaderTree.loadAll();
                lazyLoaderAdapter.loadAll();
            }
        };
        return action;
    }

    public static JSecurityAction getCancelAction(final ILazyLoaderTree lazyLoaderTree, final ILazyLoaderAdapter lazyLoaderAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("cancel_load"), IconFactory.getSwingIcon("stereo/cancel_16.png"), SwingLocale.getString("cancel_load") + SwingLocale.getString("children_nodes")){

            @Override
            public void execute(ActionEvent e) {
                boolean isMultiCancelable = LazyLoaderTreeController.isMultiCancelable(lazyLoaderTree);
                if (!isMultiCancelable) {
                    return;
                }
                TreeNode[] treeNodes = lazyLoaderTree.getSelectionTreeNodes();
                if (!lazyLoaderAdapter.loadPermitted(treeNodes)) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node_selection") + SwingLocale.getString("cancel_load_no_permission"), SwingLocale.getString("warning"), 2);
                    return;
                }
                lazyLoaderTree.cancel(treeNodes);
                lazyLoaderTree.getLazyLoader().setRecursive(false);
                lazyLoaderAdapter.cancel(treeNodes);
            }
        };
        return action;
    }

    public static JSecurityAction getCancelGrandchildrenAction(final ILazyLoaderTree lazyLoaderTree, final ILazyLoaderAdapter lazyLoaderAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("cancel_load") + SwingLocale.getString("grandchildren_nodes"), IconFactory.getSwingIcon("stereo/cancel_16.png"), SwingLocale.getString("cancel_load") + SwingLocale.getString("grandchildren_nodes")){

            @Override
            public void execute(ActionEvent e) {
                boolean isMultiCancelable = LazyLoaderTreeController.isMultiCancelable(lazyLoaderTree);
                if (!isMultiCancelable) {
                    return;
                }
                TreeNode[] treeNodes = lazyLoaderTree.getSelectionTreeNodes();
                if (!lazyLoaderAdapter.loadPermitted(treeNodes)) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node_selection") + SwingLocale.getString("cancel_load_no_permission"), SwingLocale.getString("warning"), 2);
                    return;
                }
                lazyLoaderTree.cancelGrandchildren(treeNodes);
                lazyLoaderTree.getLazyLoader().setRecursive(false);
                lazyLoaderAdapter.cancelGrandchildren(treeNodes);
            }
        };
        return action;
    }

    public static JSecurityAction getCancelAllAction(final ILazyLoaderTree lazyLoaderTree, final ILazyLoaderAdapter lazyLoaderAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("cancel_load") + SwingLocale.getString("all_nodes"), IconFactory.getSwingIcon("stereo/cancel_16.png"), SwingLocale.getString("cancel_load") + SwingLocale.getString("all_nodes")){

            @Override
            public void execute(ActionEvent e) {
                if (!lazyLoaderAdapter.loadPermitted(null)) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node_selection") + SwingLocale.getString("cancel_load_no_permission"), SwingLocale.getString("warning"), 2);
                    return;
                }
                lazyLoaderTree.cancelAll();
                lazyLoaderTree.getLazyLoader().setRecursive(false);
                lazyLoaderAdapter.cancelAll();
            }
        };
        KeyStrokeManager.registerComponent((JComponent)((JTree)((Object)lazyLoaderTree)), (ActionListener)action, 27);
        return action;
    }

    public static JSecurityAction getSyncLoadStrategyAction(final ILazyLoaderTree lazyLoaderTree) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("sync_loader_strategy"), IconFactory.getSwingIcon("stereo/application_16.png"), SwingLocale.getString("sync_loader_strategy")){

            @Override
            public void execute(ActionEvent e) {
                lazyLoaderTree.getLazyLoader().setSynchronized(true);
            }
        };
        return action;
    }

    public static JSecurityAction getAsynLoadStrategyAction(final ILazyLoaderTree lazyLoaderTree) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("asyn_loader_strategy"), IconFactory.getSwingIcon("stereo/application_16.png"), SwingLocale.getString("asyn_loader_strategy")){

            @Override
            public void execute(ActionEvent e) {
                lazyLoaderTree.getLazyLoader().setSynchronized(false);
            }
        };
        return action;
    }

    public static JSecurityAction getRefreshAction(final ILazyLoaderTree lazyLoaderTree, final ILazyLoaderAdapter lazyLoaderAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("refresh"), IconFactory.getSwingIcon("stereo/refresh_16.png"), SwingLocale.getString("refresh") + SwingLocale.getString("children_nodes")){

            @Override
            public void execute(ActionEvent e) {
                boolean isLoadable = LazyLoaderTreeController.isLoadable(lazyLoaderTree);
                if (!isLoadable) {
                    return;
                }
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("load_refresh_description"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                TreeNode treeNode = lazyLoaderTree.getSelectionTreeNode();
                if (!lazyLoaderAdapter.refreshPermitted(treeNode)) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node") + " " + SwingLocale.getString("quotation_left") + treeNode.toString() + SwingLocale.getString("quotation_right") + " " + SwingLocale.getString("refresh_no_permission"), SwingLocale.getString("warning"), 2);
                    return;
                }
                lazyLoaderTree.getLazyLoader().setRecursive(false);
                lazyLoaderTree.refresh(treeNode);
                lazyLoaderAdapter.refresh(treeNode);
            }
        };
        KeyStrokeManager.registerComponent((JComponent)((JTree)((Object)lazyLoaderTree)), (ActionListener)action, 116);
        return action;
    }

    public static JSecurityAction getSearchAction(final ILazyLoaderTree lazyLoaderTree) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("search"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("search_recursion")){

            @Override
            public void execute(ActionEvent e) {
                if (lazyLoaderTree.getLazyLoaderContainer() != null) {
                    lazyLoaderTree.getLazyLoaderContainer().toggleShown();
                }
            }
        };
        return action;
    }

    public static boolean isLoadable(ILazyLoaderTree lazyLoaderTree) {
        boolean isSingleSelection = LazyLoaderTreeController.isSingleSelection((JTree)((Object)lazyLoaderTree), SwingLocale.getString("load"));
        if (!isSingleSelection) {
            return false;
        }
        TreeNode treeNode = lazyLoaderTree.getSelectionTreeNode();
        if (!(treeNode instanceof JLazyLoaderTreeNode)) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node") + " " + SwingLocale.getString("quotation_left") + treeNode.toString() + SwingLocale.getString("quotation_right") + " " + SwingLocale.getString("load_forbidden"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }

    public static boolean isMultiLoadable(ILazyLoaderTree lazyLoaderTree) {
        boolean isMultiSelection = LazyLoaderTreeController.isMultiSelection((JTree)((Object)lazyLoaderTree), SwingLocale.getString("load"));
        if (!isMultiSelection) {
            return false;
        }
        TreeNode[] treeNodes = lazyLoaderTree.getSelectionTreeNodes();
        for (int i = 0; i < treeNodes.length; ++i) {
            TreeNode treeNode = treeNodes[i];
            if (treeNode instanceof JLazyLoaderTreeNode) continue;
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node") + " " + SwingLocale.getString("quotation_left") + treeNode.toString() + SwingLocale.getString("quotation_right") + " " + SwingLocale.getString("load_forbidden"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }

    public static boolean isCancelable(ILazyLoaderTree lazyLoaderTree) {
        boolean isSingleSelection = LazyLoaderTreeController.isSingleSelection((JTree)((Object)lazyLoaderTree), SwingLocale.getString("cancel_load"));
        if (!isSingleSelection) {
            return false;
        }
        TreeNode treeNode = lazyLoaderTree.getSelectionTreeNode();
        if (!(treeNode instanceof JLazyLoaderTreeNode) && !(treeNode instanceof LoadingTreeNode)) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node") + " " + SwingLocale.getString("quotation_left") + treeNode.toString() + SwingLocale.getString("quotation_right") + " " + SwingLocale.getString("cancel_load_forbidden"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }

    public static boolean isMultiCancelable(ILazyLoaderTree lazyLoaderTree) {
        boolean isMultiSelection = LazyLoaderTreeController.isMultiSelection((JTree)((Object)lazyLoaderTree), SwingLocale.getString("cancel_load"));
        if (!isMultiSelection) {
            return false;
        }
        TreeNode[] treeNodes = lazyLoaderTree.getSelectionTreeNodes();
        for (int i = 0; i < treeNodes.length; ++i) {
            TreeNode treeNode = treeNodes[i];
            if (treeNode instanceof JLazyLoaderTreeNode || treeNode instanceof LoadingTreeNode) continue;
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)lazyLoaderTree)), SwingLocale.getString("node") + " " + SwingLocale.getString("quotation_left") + treeNode.toString() + SwingLocale.getString("quotation_right") + " " + SwingLocale.getString("cancel_load_forbidden"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }
}

