/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.ribbon.xml;

import com.nepxion.swing.action.JAction;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.button.JBasicMenuButton;
import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.button.JClassicMenuButton;
import com.nepxion.swing.framework.ribbon.JRibbon;
import com.nepxion.swing.framework.ribbon.JRibbonBar;
import com.nepxion.swing.framework.ribbon.JRibbonContainer;
import com.nepxion.swing.framework.ribbon.JRibbonTabbedPane;
import com.nepxion.swing.framework.ribbon.action.JRibbonAction;
import com.nepxion.swing.framework.ribbon.action.RibbonActionFactory;
import com.nepxion.swing.framework.ribbon.xml.Dom4JRibbonConstants;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.lookandfeel.LookAndFeelManager;
import com.nepxion.swing.menu.JBasicMenu;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.separator.JBasicSeparator;
import com.nepxion.util.string.StringUtil;
import com.nepxion.util.xml.dom4j.Dom4JReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.SwingConstants;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class Dom4JRibbonParser
implements Dom4JRibbonConstants,
SwingConstants {
    protected JRibbonContainer ribbonContainer;
    protected JRibbonTabbedPane ribbonTabbedPane;
    protected boolean isContextIcon = true;
    protected int textShowValue = 1;
    protected int iconShowValue = 1;

    public Dom4JRibbonParser(JRibbonContainer ribbonContainer, JRibbonTabbedPane ribbonTabbedPane) {
        this.ribbonContainer = ribbonContainer;
        this.ribbonTabbedPane = ribbonTabbedPane;
    }

    public int getTextShowValue() {
        return this.textShowValue;
    }

    public void setTextShowValue(int textShowValue) {
        this.textShowValue = textShowValue;
    }

    public int getIconShowValue() {
        return this.iconShowValue;
    }

    public void setIconShowValue(int iconShowValue) {
        this.iconShowValue = iconShowValue;
    }

    public boolean isContextIcon() {
        return this.isContextIcon;
    }

    public void setContextIcon(boolean isContextIcon) {
        this.isContextIcon = isContextIcon;
    }

    public void parse(String text) throws DocumentException {
        Document document = Dom4JReader.getDocument((String)text);
        this.parse(document);
    }

    public void parseFormat(String text) throws DocumentException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((String)text);
        this.parse(document);
    }

    public void parse(File file) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getDocument((File)file);
        this.parse(document);
    }

    public void parseFormat(File file) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((File)file);
        this.parse(document);
    }

    public void parse(InputStream inputStream) throws DocumentException, IOException {
        Document document = Dom4JReader.getDocument((InputStream)inputStream);
        this.parse(document);
    }

    public void parseFormat(InputStream inputStream) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((InputStream)inputStream);
        this.parse(document);
    }

    public void parse(Document document) {
        Element rootElement = document.getRootElement();
        this.parseRibbonNavigatorElement(rootElement);
        this.parseRibbonContainerElement(rootElement);
    }

    public void parseRibbonNavigatorElement(Element element) {
        Iterator elementIterator = element.element("ribbonnavigator").elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            this.parseRibbonBarAttribute(childElement);
        }
    }

    public void parseRibbonContainerElement(Element element) {
        Element ribbonContainerElement = element.element("ribboncontainer");
        Attribute containerStyleAttribute = ribbonContainerElement.attribute("containerstyle");
        Attribute maximumcountAttribute = ribbonContainerElement.attribute("maximumcount");
        int containerStyle = Integer.valueOf(containerStyleAttribute.getText());
        int maximumCount = Integer.valueOf(maximumcountAttribute.getText());
        this.ribbonContainer.setContainerStyle(containerStyle);
        this.ribbonContainer.setMaximumCount(maximumCount);
    }

    public void parseRibbonBarAttribute(Element element) {
        JRibbonBar ribbonBar = new JRibbonBar(this.ribbonContainer);
        String title = null;
        ImageIcon icon = null;
        String toolTipText = null;
        boolean isClosable = false;
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String attributeName = attribute.getName().trim();
            String attributeText = attribute.getText().trim();
            if (attributeName.equals("title")) {
                title = attributeText;
                continue;
            }
            if (attributeName.equals("icon")) {
                if (attributeText == null || attributeText.equals("")) continue;
                icon = this.isContextIcon ? IconFactory.getContextIcon(attributeText) : IconFactory.getSwingIcon(attributeText);
                continue;
            }
            if (attributeName.equals("tooltip")) {
                toolTipText = attributeText;
                continue;
            }
            if (!attributeName.equals("closable") || attributeText == null || attributeText.equals("")) continue;
            isClosable = Boolean.valueOf(attributeText);
        }
        this.ribbonTabbedPane.addTab(title, icon, (Component)((Object)ribbonBar), toolTipText, isClosable);
        this.parseRibbonElement(element, ribbonBar);
    }

    public void parseRibbonElement(Element element, JRibbonBar ribbonBar) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            this.parseRibbonAttribute(childElement, ribbonBar);
        }
    }

    public void parseRibbonAttribute(Element element, JRibbonBar ribbonBar) {
        JRibbon ribbon = new JRibbon();
        String title = null;
        ImageIcon icon = null;
        String toolTipText = null;
        TableLayout layout = null;
        int[] buttonLayout = BUTTON_LAYOUT;
        Insets buttonInsets = BUTTON_INSETS;
        String cornerName = null;
        String cornerToolTipText = null;
        String cornerActionClass = null;
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String attributeName = attribute.getName().trim();
            String attributeText = attribute.getText().trim();
            if (attributeName.equals("title")) {
                title = attributeText;
                continue;
            }
            if (attributeName.equals("icon")) {
                if (attributeText == null || attributeText.equals("")) continue;
                icon = this.isContextIcon ? IconFactory.getContextIcon(attributeText) : IconFactory.getSwingIcon(attributeText);
                continue;
            }
            if (attributeName.equals("tooltip")) {
                toolTipText = attributeText;
                continue;
            }
            if (attributeName.equals("layout")) {
                String layoutClass;
                if (attributeText.equals("") || (layoutClass = attributeText.substring(0, attributeText.indexOf("("))).indexOf("TableLayout") <= -1) continue;
                String layoutParameters = attributeText.substring(attributeText.indexOf("{"), attributeText.lastIndexOf("}") + 1);
                double[][] size = StringUtil.parseDouble2Array((String)layoutParameters);
                layout = new TableLayout(size);
                continue;
            }
            if (attributeName.equals("buttonlayout")) {
                buttonLayout = StringUtil.parseIntArray((String)attributeText);
                continue;
            }
            if (attributeName.equals("buttoninsets")) {
                attributeText = StringUtils.deleteWhitespace((String)attributeText);
                String[] stringArray = attributeText.split(",");
                buttonInsets = new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                continue;
            }
            if (attributeName.equals("cornername")) {
                cornerName = attributeText;
                continue;
            }
            if (attributeName.equals("cornertooltip")) {
                cornerToolTipText = attributeText;
                continue;
            }
            if (!attributeName.equals("corneraction")) continue;
            cornerActionClass = attributeText;
        }
        ribbon.setTitle(title);
        ribbon.setIcon(icon);
        ribbon.setToolTipText(toolTipText);
        if (cornerActionClass != null && !cornerActionClass.equals("")) {
            JAction cornerAction = this.createAction(cornerName, null, null, null, null, null, null, cornerToolTipText, cornerActionClass);
            ribbon.setCornerAction(cornerAction);
        }
        if (layout != null) {
            ribbon.getToolBar().setLayout(layout);
        }
        ribbonBar.getRibbonView().add(ribbon);
        this.parseButtonElement(element, ribbon);
        ButtonManager.updateUI((Container)ribbon.getToolBar(), buttonInsets, buttonLayout);
    }

    public void parseButtonElement(Element element, JRibbon ribbon) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            this.parseButtonAttribute(childElement, ribbon);
        }
    }

    public void parseButtonAttribute(Element element, JRibbon ribbon) {
        String name = null;
        String text = null;
        String smallText = null;
        String largeText = null;
        ImageIcon icon = null;
        ImageIcon smallIcon = null;
        ImageIcon largeIcon = null;
        String toolTipText = null;
        String ribbonName = null;
        String ribbonTitle = null;
        ImageIcon ribbonIcon = null;
        String ribbonToolTipText = null;
        int orientation = 1;
        int arrowPosition = 1;
        String constraints = null;
        String ribbonComponentClass = null;
        String actionClass = null;
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String attributeName = attribute.getName().trim();
            String attributeText = attribute.getText().trim();
            if (attributeName.equals("name")) {
                name = attributeText;
                continue;
            }
            if (attributeName.equals("text")) {
                smallText = attributeText;
                continue;
            }
            if (attributeName.equals("largetext")) {
                largeText = attributeText;
                continue;
            }
            if (attributeName.equals("icon")) {
                if (attributeText == null || attributeText.equals("")) continue;
                smallIcon = this.isContextIcon ? IconFactory.getContextIcon(attributeText) : IconFactory.getSwingIcon(attributeText);
                continue;
            }
            if (attributeName.equals("largeicon")) {
                if (attributeText == null || attributeText.equals("")) continue;
                largeIcon = this.isContextIcon ? IconFactory.getContextIcon(attributeText) : IconFactory.getSwingIcon(attributeText);
                continue;
            }
            if (attributeName.equals("tooltip")) {
                toolTipText = attributeText;
                continue;
            }
            if (attributeName.equals("ribbonname")) {
                ribbonName = attributeText;
                continue;
            }
            if (attributeName.equals("ribbontitle")) {
                ribbonTitle = attributeText;
                continue;
            }
            if (attributeName.equals("ribbonicon")) {
                if (attributeText == null || attributeText.equals("")) continue;
                ribbonIcon = this.isContextIcon ? IconFactory.getContextIcon(attributeText) : IconFactory.getSwingIcon(attributeText);
                continue;
            }
            if (attributeName.equals("ribbontooltip")) {
                ribbonToolTipText = attributeText;
                continue;
            }
            if (attributeName.equals("orientation")) {
                orientation = Integer.parseInt(attributeText);
                continue;
            }
            if (attributeName.equals("arrowposition")) {
                arrowPosition = Integer.parseInt(attributeText);
                continue;
            }
            if (attributeName.equals("constraints")) {
                constraints = attributeText;
                continue;
            }
            if (attributeName.equals("component")) {
                ribbonComponentClass = attributeText;
                continue;
            }
            if (!attributeName.equals("action")) continue;
            actionClass = attributeText;
        }
        if (largeText == null) {
            largeText = smallText;
        }
        if (largeIcon == null) {
            largeIcon = smallIcon;
        }
        switch (this.textShowValue) {
            case 0: {
                text = smallText;
                break;
            }
            case 1: {
                text = largeText;
                if (text != null) break;
                text = smallText;
                break;
            }
            case 2: {
                text = null;
            }
        }
        switch (this.iconShowValue) {
            case 0: {
                icon = smallIcon;
                break;
            }
            case 1: {
                icon = largeIcon;
                if (icon != null) break;
                icon = smallIcon;
                break;
            }
            case 2: {
                icon = null;
            }
        }
        if (ribbonName == null || ribbonName.equals("")) {
            ribbonName = name;
        }
        if (ribbonTitle == null || ribbonTitle.equals("")) {
            ribbonTitle = toolTipText;
        }
        if (ribbonToolTipText == null || ribbonToolTipText.equals("")) {
            ribbonToolTipText = toolTipText;
        }
        JComponent component = null;
        if (!element.getName().equals("separator")) {
            if (element.elements().size() == 0) {
                JAction action = null;
                action = actionClass != null && !actionClass.equals("") ? this.createAction(name, ButtonManager.getHtmlText(text), ButtonManager.getHtmlText(smallText), ButtonManager.getHtmlText(largeText), icon, smallIcon, largeIcon, toolTipText, actionClass) : this.createRibbonAction(name, ButtonManager.getHtmlText(text), ButtonManager.getHtmlText(smallText), ButtonManager.getHtmlText(largeText), icon, smallIcon, largeIcon, toolTipText, ribbonName, ribbonTitle, ribbonIcon, ribbonToolTipText, ribbonComponentClass);
                component = LookAndFeelManager.isNimbusLookAndFeel() ? new JClassicButton(action) : new JBasicButton(action);
            } else {
                JBasicPopupMenu popupMenu = new JBasicPopupMenu();
                JAction action = new JAction(ButtonManager.getHtmlText(text), (Icon)icon, toolTipText){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                action.setSmallText(ButtonManager.getHtmlText(smallText));
                action.setLargeText(ButtonManager.getHtmlText(largeText));
                action.setSmallIcon(smallIcon);
                action.setLargeIcon(largeIcon);
                if (LookAndFeelManager.isNimbusLookAndFeel()) {
                    component = new JClassicMenuButton(action);
                    ((JClassicMenuButton)component).setShowArrowRight(arrowPosition == 0);
                    ((JClassicMenuButton)component).setPopupMenu(popupMenu);
                } else {
                    component = new JBasicMenuButton(action);
                    ((JBasicMenuButton)component).setPopupMenu(popupMenu);
                }
                this.parseMenuElement(element, popupMenu);
            }
        } else {
            component = new JBasicSeparator();
            component.setOrientation(orientation);
        }
        if (constraints != null) {
            ribbon.getToolBar().add((Component)component, constraints);
        } else {
            ribbon.getToolBar().add(component);
        }
    }

    public void parseMenuElement(Element element, MenuElement menu) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            this.parseMenuAttribute(childElement, menu);
        }
    }

    public void parseMenuAttribute(Element element, MenuElement menu) {
        String name = null;
        String text = null;
        ImageIcon icon = null;
        String toolTipText = null;
        String ribbonName = null;
        String ribbonTitle = null;
        ImageIcon ribbonIcon = null;
        String ribbonToolTipText = null;
        String ribbonComponentClass = null;
        String actionClass = null;
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String attributeName = attribute.getName().trim();
            String attributeText = attribute.getText().trim();
            if (attributeName.equals("name")) {
                name = attributeText;
                continue;
            }
            if (attributeName.equals("text")) {
                text = attributeText;
                continue;
            }
            if (attributeName.equals("icon")) {
                if (attributeText == null || attributeText.equals("")) continue;
                icon = this.isContextIcon ? IconFactory.getContextIcon(attributeText) : IconFactory.getSwingIcon(attributeText);
                continue;
            }
            if (attributeName.equals("tooltip")) {
                toolTipText = attributeText;
                continue;
            }
            if (attributeName.equals("ribbonname")) {
                ribbonName = attributeText;
                continue;
            }
            if (attributeName.equals("ribbontitle")) {
                ribbonTitle = attributeText;
                continue;
            }
            if (attributeName.equals("ribbonicon")) {
                if (attributeText == null || attributeText.equals("")) continue;
                ribbonIcon = this.isContextIcon ? IconFactory.getContextIcon(attributeText) : IconFactory.getSwingIcon(attributeText);
                continue;
            }
            if (attributeName.equals("ribbontooltip")) {
                ribbonToolTipText = attributeText;
                continue;
            }
            if (attributeName.equals("component")) {
                ribbonComponentClass = attributeText;
                continue;
            }
            if (!attributeName.equals("action")) continue;
            actionClass = attributeText;
        }
        if (ribbonName == null || ribbonName.equals("")) {
            ribbonName = name;
        }
        if (ribbonTitle == null || ribbonTitle.equals("")) {
            ribbonTitle = toolTipText;
        }
        if (ribbonToolTipText == null || ribbonToolTipText.equals("")) {
            ribbonToolTipText = toolTipText;
        }
        if (!element.getName().equals("separator")) {
            JMenuItem childMenu = null;
            if (element.elements().size() == 0) {
                JAction action = null;
                action = actionClass != null && !actionClass.toString().equals("") ? this.createAction(name, ButtonManager.getHtmlText(text), null, null, icon, null, null, toolTipText, actionClass) : this.createRibbonAction(name, ButtonManager.getHtmlText(text), null, null, icon, null, null, toolTipText, ribbonName, ribbonTitle, ribbonIcon, ribbonToolTipText, ribbonComponentClass);
                childMenu = new JBasicMenuItem(action);
            } else {
                childMenu = new JBasicMenu(ButtonManager.getHtmlText(text), icon, toolTipText);
                this.parseMenuElement(element, childMenu);
            }
            ((JComponent)((Object)menu)).add(childMenu);
        } else if (menu instanceof JBasicPopupMenu) {
            ((JBasicPopupMenu)menu).addSeparator();
        } else if (menu instanceof JBasicMenu) {
            ((JBasicMenu)menu).addSeparator();
        }
    }

    public JRibbonAction createRibbonAction(String name, String text, String smallText, String largeText, Icon icon, Icon smallIcon, Icon largeIcon, String toolTipText, String ribbonName, String ribbonTitle, Icon ribbonIcon, String ribbonToolTipText, String ribbonComponentClass) {
        return RibbonActionFactory.createRibbonAction(name, text, smallText, largeText, icon, smallIcon, largeIcon, toolTipText, ribbonName, ribbonTitle, ribbonIcon, ribbonToolTipText, ribbonComponentClass, this.ribbonContainer);
    }

    public JAction createAction(String name, String text, String smallText, String largeText, Icon icon, Icon smallIcon, Icon largeIcon, String toolTipText, String actionClass) {
        JAction action = null;
        try {
            action = (JAction)Class.forName(actionClass).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        action.setName(name);
        action.setText(text);
        action.setIcon(icon);
        action.setToolTipText(toolTipText);
        action.setSmallText(smallText);
        action.setLargeText(largeText);
        action.setSmallIcon(smallIcon);
        action.setLargeIcon(largeIcon);
        return action;
    }
}

