/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.dockable;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.framework.dockable.DockableManager;
import com.nepxion.swing.framework.dockable.JDockable;
import com.nepxion.swing.framework.dockable.JDockableContainer;
import com.nepxion.swing.fullscreen.FullScreenConstants;
import com.nepxion.swing.fullscreen.FullScreenManager;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.panel.decoration.JDecorationHeader;
import com.nepxion.swing.panel.decoration.JDecorationPanel;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.style.framework.IStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class JDockableView
extends JDecorationPanel
implements FullScreenConstants {
    private boolean isMaximized = false;
    private boolean isClosable = true;
    private boolean isMaximizable = true;
    private ToolBar toolBar;
    private JPopupMenu popupMenu;
    private JDockable dockable;
    private JDockableContainer dockableContainer;
    private int dockIndex;
    private Object constraints;
    private AbstractButton foreignButton;

    public JDockableView() {
        this.initComponents();
    }

    public JDockableView(String title, String toolTipText) {
        super(title, toolTipText);
        this.initComponents();
    }

    public JDockableView(String title, String toolTipText, boolean selected) {
        super(title, toolTipText, selected);
        this.initComponents();
    }

    public JDockableView(String title, String toolTipText, IStyle style) {
        super(title, toolTipText, style);
        this.initComponents();
    }

    public JDockableView(String title, String toolTipText, boolean selected, IStyle style) {
        super(title, toolTipText, selected, style);
        this.initComponents();
    }

    public JDockableView(Icon icon, String toolTipText) {
        super(icon, toolTipText);
        this.initComponents();
    }

    public JDockableView(Icon icon, String toolTipText, boolean selected) {
        super(icon, toolTipText, selected);
        this.initComponents();
    }

    public JDockableView(Icon icon, String toolTipText, IStyle style) {
        super(icon, toolTipText, style);
        this.initComponents();
    }

    public JDockableView(Icon icon, String toolTipText, boolean selected, IStyle style) {
        super(icon, toolTipText, selected, style);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText) {
        super(title, icon, toolTipText);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText, boolean selected) {
        super(title, icon, toolTipText, selected);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText, IStyle style) {
        super(title, icon, toolTipText, style);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText, boolean selected, IStyle style) {
        super(title, icon, toolTipText, selected, style);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText, Component contentPane) {
        super(title, icon, toolTipText, contentPane);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText, Component contentPane, IStyle style) {
        super(title, icon, toolTipText, contentPane, style);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText, boolean selected, Component contentPane) {
        super(title, icon, toolTipText, selected, contentPane);
        this.initComponents();
    }

    public JDockableView(String title, Icon icon, String toolTipText, boolean selected, Component contentPane, IStyle style) {
        super(title, icon, toolTipText, selected, contentPane, style);
        this.initComponents();
    }

    private void initComponents() {
        JDecorationHeader header = this.getHeader();
        this.toolBar = new ToolBar();
        this.popupMenu = new PopupMenu();
        MaximizeAndRestoreMouseListener maximizeAndRestoreMouseListener = new MaximizeAndRestoreMouseListener();
        header.add((Component)this.toolBar, "East");
        header.addMouseListener(maximizeAndRestoreMouseListener);
        header.getLabel().addMouseListener(maximizeAndRestoreMouseListener);
    }

    private void initDock() {
        if (this.dockable == null) {
            this.dockable = DockableManager.getDockable(this);
        }
        if (this.dockableContainer == null) {
            this.dockableContainer = DockableManager.getDockableContainer(this);
        }
    }

    protected void restoreToMaximize() {
        this.initDock();
        this.dockIndex = this.dockable.indexOfPane(this);
        if (this.dockableContainer != null) {
            this.dockableContainer.dock(this);
        }
    }

    protected void maximizeToRestore() {
        this.initDock();
        if (this.dockableContainer != null) {
            this.dockableContainer.dock(null);
        }
        if (this.dockable != null) {
            if (this.constraints != null) {
                this.dockable.insertPane(this, this.constraints, this.dockIndex);
            } else {
                this.dockable.insertPane(this, this.dockIndex);
            }
        }
    }

    private void toggleMaximum() {
        JPopupMenu popupMenu;
        String text = null;
        Icon icon = null;
        if (this.isMaximized) {
            this.maximizeToRestore();
            text = TEXT_MAXIMIZE;
            icon = ICON_MAXIMIZE;
        } else {
            this.restoreToMaximize();
            text = TEXT_RESTORE;
            icon = ICON_MAXIMIZE_RESTORE;
        }
        this.isMaximized = !this.isMaximized;
        JBasicButton maximizeButton = this.toolBar.getMaximizeButton();
        maximizeButton.setIcon(icon);
        maximizeButton.setToolTipText(text);
        if (this.isClosable) {
            this.toolBar.getCloseButton().setVisible(!this.isMaximized);
        }
        if ((popupMenu = this.getPopupMenu()) instanceof PopupMenu) {
            JBasicMenuItem maximizeMenuItem = ((PopupMenu)popupMenu).getMaximizeMenuItem();
            maximizeMenuItem.setText(text);
            maximizeMenuItem.setIcon(icon);
            maximizeMenuItem.setToolTipText(text);
            if (this.isClosable) {
                ((PopupMenu)popupMenu).getCloseMenuItem().setVisible(!this.isMaximized);
            }
        }
    }

    public void registerForeignButton(AbstractButton foreignButton) {
        this.foreignButton = foreignButton;
    }

    public boolean isClosable() {
        return this.isClosable;
    }

    public void setClosable(boolean isClosable) {
        this.isClosable = isClosable;
        this.toolBar.getCloseButton().setVisible(isClosable);
        if (this.popupMenu instanceof PopupMenu) {
            ((PopupMenu)this.popupMenu).getCloseMenuItem().setVisible(false);
        }
    }

    public boolean isMaximizable() {
        return this.isMaximizable;
    }

    public void setMaximizable(boolean isMaximizable) {
        this.isMaximizable = isMaximizable;
        this.toolBar.getMaximizeButton().setVisible(isMaximizable);
        if (this.popupMenu instanceof PopupMenu) {
            ((PopupMenu)this.popupMenu).getMaximizeMenuItem().setVisible(false);
        }
    }

    public Object getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Object constraints) {
        this.constraints = constraints;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public class MaximizeAndRestoreMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (!JDockableView.this.isMaximizable) {
                return;
            }
            if (JDockableView.this.isMaximizable && e.getClickCount() > 1) {
                JDockableView.this.toggleMaximum();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!JDockableView.this.isMaximizable && !JDockableView.this.isClosable) {
                return;
            }
            if (JDockableView.this.popupMenu != null) {
                if (!e.isPopupTrigger()) {
                    return;
                }
                JDockableView.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public class ToolBar
    extends JPanel {
        private JBasicButton maximizeButton = FullScreenManager.createMaximizeButton(false);
        private JBasicButton closeButton;

        public ToolBar() {
            this.maximizeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDockableView.this.toggleMaximum();
                }
            });
            this.add(this.maximizeButton);
            this.closeButton = FullScreenManager.createCloseButton(false);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDockableView.this.setVisible(false);
                    if (JDockableView.this.foreignButton != null) {
                        JDockableView.this.foreignButton.setSelected(false);
                    }
                }
            });
            this.add(this.closeButton);
            this.add(Box.createHorizontalStrut(1));
            ButtonManager.updateUI((Container)this, new Dimension(20, 20), true);
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
        }

        public JBasicButton getMaximizeButton() {
            return this.maximizeButton;
        }

        public JBasicButton getCloseButton() {
            return this.closeButton;
        }
    }

    public class PopupMenu
    extends JBasicPopupMenu {
        private JBasicMenuItem maximizeMenuItem = FullScreenManager.createMaximizeMenuItem();
        private JBasicMenuItem closeMenuItem;

        public PopupMenu() {
            this.maximizeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDockableView.this.toggleMaximum();
                }
            });
            this.add(this.maximizeMenuItem);
            this.closeMenuItem = FullScreenManager.createCloseMenuItem();
            this.closeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDockableView.this.setVisible(false);
                    if (JDockableView.this.foreignButton != null) {
                        JDockableView.this.foreignButton.setSelected(false);
                    }
                }
            });
            this.add(this.closeMenuItem);
        }

        public JBasicMenuItem getMaximizeMenuItem() {
            return this.maximizeMenuItem;
        }

        public JBasicMenuItem getCloseMenuItem() {
            return this.closeMenuItem;
        }
    }
}

