/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Cursor;
import y.base.DataProvider;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.NodeCursor;
import y.base.YCursor;
import y.util.Maps;
import y.view.BendCursor;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.ViewContainer;
import y.view.ViewMode;

public class MoveSelectionMode
extends ViewMode {
    private double ch;
    private double ce;
    private double cd;
    private double cc;
    private boolean cg;
    private NodeCursor cf;
    private BendCursor cb;

    public MoveSelectionMode(ViewContainer viewContainer) {
        super(viewContainer);
    }

    public MoveSelectionMode() {
    }

    public void mouseShiftPressedLeft(double d2, double d3) {
        this.d(d2, d3);
    }

    public void mousePressedLeft(double d2, double d3) {
        this.d(d2, d3);
    }

    public void mouseReleasedLeft(double d2, double d3) {
        d2 = this.getGridX(d2);
        d3 = this.getGridY(d3);
        Graph2D graph2D = this.getGraph2D();
        this.view.updateWorldRect();
        this.view.setDrawingMode(0);
        this.selectionMovedAction(d2 - this.ch, d3 - this.ce, d2, d3);
        graph2D.updateViews();
        this.reactivateParent();
    }

    public void mouseDraggedLeft(double d2, double d3) {
        d2 = this.getGridX(d2);
        d3 = this.getGridY(d3);
        Graph2D graph2D = this.getGraph2D();
        if (this.cg && this.f() && this.isGridMode()) {
            if (this.cf.ok()) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(this.cf.node());
                nodeRealizer.setCenter(d2, d3);
            }
            if (this.cb.ok()) {
                this.cb.bend().setLocation(d2, d3);
            }
            this.cg = false;
            this.cd = d2;
            this.cc = d3;
        } else {
            this.ch = this.getGridX(this.ch);
            this.ce = this.getGridY(this.ce);
            this.cd = this.getGridX(this.cd);
            this.cc = this.getGridY(this.cc);
            d2 = this.getGridX(d2);
            d3 = this.getGridY(d3);
            double d4 = d2 - this.cd;
            double d5 = d3 - this.cc;
            this.cd = d2;
            this.cc = d3;
            this.getGraph2D().moveBends(this.cb, d4, d5);
            this.getGraph2D().moveNodes(this.cf, d4, d5);
        }
        this.selectionOnMove(d2 - this.ch, d3 - this.ce, d2, d3);
        this.view.updateView();
    }

    protected void selectionOnMove(double d2, double d3, double d4, double d5) {
    }

    protected void selectionMovedAction(double d2, double d3, double d4, double d5) {
    }

    void d(double d2, double d3) {
        Graph2D graph2D = this.getGraph2D();
        this.cg = true;
        this.ch = this.cd = d2;
        this.ce = this.cc = d3;
        this.view.updateView();
        this.view.setDrawingMode(1);
        this.view.setViewCursor(Cursor.getPredefinedCursor(13));
        this.cf = graph2D.selectedNodes();
        this.cb = graph2D.selectedBends();
        graph2D.firePreEvent();
        if (this.cb.ok()) {
            YCursor yCursor;
            int n = 0;
            EdgeCursor edgeCursor = graph2D.edges();
            while (edgeCursor.ok()) {
                n += graph2D.getRealizer(edgeCursor.edge()).bendCount();
                edgeCursor.next();
            }
            boolean[] blArray = new boolean[n];
            EdgeMap edgeMap = Maps.createIndexEdgeMap(new boolean[graph2D.E()]);
            while (this.cb.ok()) {
                edgeMap.setBool(this.cb.bend().getEdge(), true);
                this.cb.next();
            }
            EdgeList edgeList = new EdgeList(graph2D.edges(), (DataProvider)edgeMap);
            int n2 = 0;
            EdgeCursor edgeCursor2 = graph2D.edges();
            while (edgeCursor2.ok()) {
                yCursor = graph2D.getRealizer(edgeCursor2.edge()).bends();
                while (yCursor.ok()) {
                    if (yCursor.bend().isSelected()) {
                        blArray[n2] = true;
                    }
                    yCursor.next();
                    ++n2;
                }
                edgeCursor2.next();
            }
            graph2D.backupRealizers(edgeList.edges());
            n2 = 0;
            yCursor = graph2D.edges();
            while (yCursor.ok()) {
                BendCursor bendCursor = graph2D.getRealizer(yCursor.edge()).bends();
                while (bendCursor.ok()) {
                    if (blArray[n2]) {
                        bendCursor.bend().setSelected(true);
                    }
                    bendCursor.next();
                    ++n2;
                }
                yCursor.next();
            }
            this.cb = graph2D.selectedBends();
        }
        this.getGraph2D().backupRealizers(this.cf);
        this.cf.toFirst();
        graph2D.firePostEvent();
    }

    private boolean f() {
        return this.cb.size() + this.cf.size() == 1;
    }
}

